/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.Assert;

public abstract class BaseLockFactoryTestCase
extends LuceneTestCase {
    protected abstract Directory getDirectory(Path var1) throws IOException;

    public void testBasics() throws IOException {
        Directory dir = this.getDirectory(BaseLockFactoryTestCase.createTempDir());
        Lock l = dir.obtainLock("commit");
        try {
            dir.obtainLock("commit");
            BaseLockFactoryTestCase.fail((String)"succeeded in obtaining lock twice, didn't get exception");
        }
        catch (LockObtainFailedException lockObtainFailedException) {
            // empty catch block
        }
        l.close();
        l = dir.obtainLock("commit");
        l.close();
        dir.close();
    }

    public void testDoubleClose() throws IOException {
        Directory dir = this.getDirectory(BaseLockFactoryTestCase.createTempDir());
        Lock l = dir.obtainLock("commit");
        l.close();
        l.close();
        dir.close();
    }

    public void testValidAfterAcquire() throws IOException {
        Directory dir = this.getDirectory(BaseLockFactoryTestCase.createTempDir());
        Lock l = dir.obtainLock("commit");
        l.ensureValid();
        l.close();
        dir.close();
    }

    public void testInvalidAfterClose() throws IOException {
        Directory dir = this.getDirectory(BaseLockFactoryTestCase.createTempDir());
        Lock l = dir.obtainLock("commit");
        l.close();
        try {
            l.ensureValid();
            BaseLockFactoryTestCase.fail((String)"didn't get exception");
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
        dir.close();
    }

    public void testObtainConcurrently() throws InterruptedException, IOException {
        int i;
        final Directory directory = this.getDirectory(BaseLockFactoryTestCase.createTempDir());
        final AtomicBoolean running = new AtomicBoolean(true);
        final AtomicInteger atomicCounter = new AtomicInteger(0);
        final ReentrantLock assertingLock = new ReentrantLock();
        int numThreads = 2 + BaseLockFactoryTestCase.random().nextInt(10);
        final int runs = BaseLockFactoryTestCase.atLeast(10000);
        final CyclicBarrier barrier = new CyclicBarrier(numThreads);
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    while (running.get()) {
                        try (Lock lock = directory.obtainLock("foo.lock");){
                            Assert.assertFalse((boolean)assertingLock.isLocked());
                            if (assertingLock.tryLock()) {
                                assertingLock.unlock();
                            } else {
                                Assert.fail();
                            }
                            assert (lock != null);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (atomicCounter.incrementAndGet() <= runs) continue;
                        running.set(false);
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        directory.close();
    }

    public void testStressLocks() throws Exception {
        Directory dir = this.getDirectory(BaseLockFactoryTestCase.createTempDir());
        IndexWriter w = new IndexWriter(dir, new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseLockFactoryTestCase.random())).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        this.addDoc(w);
        w.close();
        WriterThread writer = new WriterThread(100, dir);
        SearcherThread searcher = new SearcherThread(100, dir);
        writer.start();
        searcher.start();
        while (writer.isAlive() || searcher.isAlive()) {
            Thread.sleep(1000L);
        }
        BaseLockFactoryTestCase.assertTrue((String)"IndexWriter hit unexpected exceptions", (!writer.hitException ? 1 : 0) != 0);
        BaseLockFactoryTestCase.assertTrue((String)"IndexSearcher hit unexpected exceptions", (!searcher.hitException ? 1 : 0) != 0);
        dir.close();
    }

    private void addDoc(IndexWriter writer) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)BaseLockFactoryTestCase.newTextField("content", "aaa", Field.Store.NO));
        writer.addDocument((Iterable)doc);
    }

    private class SearcherThread
    extends Thread {
        private Directory dir;
        private int numIteration;
        public boolean hitException = false;

        public SearcherThread(int numIteration, Directory dir) {
            this.numIteration = numIteration;
            this.dir = dir;
        }

        @Override
        public void run() {
            DirectoryReader reader = null;
            IndexSearcher searcher = null;
            TermQuery query = new TermQuery(new Term("content", "aaa"));
            for (int i = 0; i < this.numIteration; ++i) {
                try {
                    reader = DirectoryReader.open((Directory)this.dir);
                    searcher = LuceneTestCase.newSearcher((IndexReader)reader);
                }
                catch (Exception e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Searcher: create hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
                try {
                    searcher.search((Query)query, 1000);
                }
                catch (IOException e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Searcher: search hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
                try {
                    reader.close();
                    continue;
                }
                catch (IOException e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Searcher: close hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
            }
        }
    }

    private class WriterThread
    extends Thread {
        private Directory dir;
        private int numIteration;
        public boolean hitException = false;

        public WriterThread(int numIteration, Directory dir) {
            this.numIteration = numIteration;
            this.dir = dir;
        }

        @Override
        public void run() {
            IndexWriter writer = null;
            for (int i = 0; i < this.numIteration; ++i) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: WriterThread iter=" + i);
                }
                try {
                    writer = new IndexWriter(this.dir, new IndexWriterConfig((Analyzer)new MockAnalyzer(LuceneTestCase.random())).setOpenMode(IndexWriterConfig.OpenMode.APPEND));
                }
                catch (LockObtainFailedException e) {
                }
                catch (Exception e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Writer: creation hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
                if (writer == null) continue;
                try {
                    BaseLockFactoryTestCase.this.addDoc(writer);
                }
                catch (IOException e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Writer: addDoc hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.hitException = true;
                    System.out.println("Stress Test Index Writer: close hit unexpected exception: " + e.toString());
                    e.printStackTrace(System.out);
                    break;
                }
                writer = null;
            }
        }
    }
}

