/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;

public class FilterPath
implements Path {
    protected final Path delegate;
    protected final FileSystem fileSystem;

    public FilterPath(Path delegate, FileSystem fileSystem) {
        this.delegate = delegate;
        this.fileSystem = fileSystem;
    }

    public Path getDelegate() {
        return this.delegate;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    @Override
    public Path getRoot() {
        Path root = this.delegate.getRoot();
        if (root == null) {
            return null;
        }
        return this.wrap(root);
    }

    @Override
    public Path getFileName() {
        Path fileName = this.delegate.getFileName();
        if (fileName == null) {
            return null;
        }
        return this.wrap(fileName);
    }

    @Override
    public Path getParent() {
        Path parent = this.delegate.getParent();
        if (parent == null) {
            return null;
        }
        return this.wrap(parent);
    }

    @Override
    public int getNameCount() {
        return this.delegate.getNameCount();
    }

    @Override
    public Path getName(int index) {
        return this.wrap(this.delegate.getName(index));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return this.wrap(this.delegate.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (other instanceof FilterPath) {
            FilterPath f = (FilterPath)other;
            return this.fileSystem == f.fileSystem && this.delegate.startsWith(f.delegate);
        }
        return false;
    }

    @Override
    public boolean startsWith(String other) {
        return this.delegate.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other instanceof FilterPath) {
            FilterPath f = (FilterPath)other;
            return this.fileSystem == f.fileSystem && this.delegate.endsWith(f.delegate);
        }
        return false;
    }

    @Override
    public boolean endsWith(String other) {
        return this.delegate.startsWith(other);
    }

    @Override
    public Path normalize() {
        return this.wrap(this.delegate.normalize());
    }

    @Override
    public Path resolve(Path other) {
        if (other instanceof FilterPath) {
            other = ((FilterPath)other).delegate;
        }
        return this.wrap(this.delegate.resolve(other));
    }

    @Override
    public Path resolve(String other) {
        return this.wrap(this.delegate.resolve(other));
    }

    @Override
    public Path resolveSibling(Path other) {
        if (other instanceof FilterPath) {
            other = ((FilterPath)other).delegate;
        }
        return this.wrap(this.delegate.resolveSibling(other));
    }

    @Override
    public Path resolveSibling(String other) {
        return this.wrap(this.delegate.resolveSibling(other));
    }

    @Override
    public Path relativize(Path other) {
        if (other instanceof FilterPath) {
            other = ((FilterPath)other).delegate;
        }
        return this.wrap(this.delegate.relativize(other));
    }

    @Override
    public URI toUri() {
        return this.delegate.toUri();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Path toAbsolutePath() {
        return this.wrap(this.delegate.toAbsolutePath());
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.wrap(this.delegate.toRealPath(options));
    }

    @Override
    public File toFile() {
        return this.delegate.toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.delegate.register(watcher, events, modifiers);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.delegate.register(watcher, events);
    }

    @Override
    public Iterator<Path> iterator() {
        final Iterator<Path> iterator = this.delegate.iterator();
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Path next() {
                return FilterPath.this.wrap((Path)iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        if (other instanceof FilterPath) {
            other = ((FilterPath)other).delegate;
        }
        return this.delegate.compareTo(other);
    }

    public static Path unwrap(Path path) {
        while (path instanceof FilterPath) {
            path = ((FilterPath)path).delegate;
        }
        return path;
    }

    protected Path wrap(Path other) {
        return new FilterPath(other, this.fileSystem);
    }
}

