/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.mockfile.FilterFileSystemProvider;

public class ExtrasFS
extends FilterFileSystemProvider {
    final AtomicLong counter = new AtomicLong();
    final Random random;

    public ExtrasFS(FileSystem delegate, Random random) {
        super("extras://", delegate);
        this.random = random;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        super.createDirectory(dir, attrs);
        if (this.random.nextInt(4) == 0) {
            try {
                Path target = dir.resolve("extra" + this.counter.incrementAndGet());
                if (this.random.nextBoolean()) {
                    super.createDirectory(target, new FileAttribute[0]);
                } else {
                    Files.createFile(target, new FileAttribute[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

