/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.generators.RandomInts;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.asserting.AssertingCodec;
import org.apache.lucene.codecs.blockterms.LuceneFixedGap;
import org.apache.lucene.codecs.blocktreeords.BlockTreeOrdsPostingsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50Codec;
import org.apache.lucene.codecs.lucene50.Lucene50DocValuesFormat;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsFormat;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.mockfile.FilterFileSystem;
import org.apache.lucene.mockfile.WindowsFS;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.UnicodeUtil;
import org.junit.Assert;

public final class TestUtil {
    private static final int maxRecursionBound = 5;
    private static final List<String> ops = Arrays.asList(".", "?", "{0,5}", "{1,5}", "(", ")", "-", "[", "]", "|");
    private static final String[] HTML_CHAR_ENTITIES = new String[]{"AElig", "Aacute", "Acirc", "Agrave", "Alpha", "AMP", "Aring", "Atilde", "Auml", "Beta", "COPY", "Ccedil", "Chi", "Dagger", "Delta", "ETH", "Eacute", "Ecirc", "Egrave", "Epsilon", "Eta", "Euml", "Gamma", "GT", "Iacute", "Icirc", "Igrave", "Iota", "Iuml", "Kappa", "Lambda", "LT", "Mu", "Ntilde", "Nu", "OElig", "Oacute", "Ocirc", "Ograve", "Omega", "Omicron", "Oslash", "Otilde", "Ouml", "Phi", "Pi", "Prime", "Psi", "QUOT", "REG", "Rho", "Scaron", "Sigma", "THORN", "Tau", "Theta", "Uacute", "Ucirc", "Ugrave", "Upsilon", "Uuml", "Xi", "Yacute", "Yuml", "Zeta", "aacute", "acirc", "acute", "aelig", "agrave", "alefsym", "alpha", "amp", "and", "ang", "apos", "aring", "asymp", "atilde", "auml", "bdquo", "beta", "brvbar", "bull", "cap", "ccedil", "cedil", "cent", "chi", "circ", "clubs", "cong", "copy", "crarr", "cup", "curren", "dArr", "dagger", "darr", "deg", "delta", "diams", "divide", "eacute", "ecirc", "egrave", "empty", "emsp", "ensp", "epsilon", "equiv", "eta", "eth", "euml", "euro", "exist", "fnof", "forall", "frac12", "frac14", "frac34", "frasl", "gamma", "ge", "gt", "hArr", "harr", "hearts", "hellip", "iacute", "icirc", "iexcl", "igrave", "image", "infin", "int", "iota", "iquest", "isin", "iuml", "kappa", "lArr", "lambda", "lang", "laquo", "larr", "lceil", "ldquo", "le", "lfloor", "lowast", "loz", "lrm", "lsaquo", "lsquo", "lt", "macr", "mdash", "micro", "middot", "minus", "mu", "nabla", "nbsp", "ndash", "ne", "ni", "not", "notin", "nsub", "ntilde", "nu", "oacute", "ocirc", "oelig", "ograve", "oline", "omega", "omicron", "oplus", "or", "ordf", "ordm", "oslash", "otilde", "otimes", "ouml", "para", "part", "permil", "perp", "phi", "pi", "piv", "plusmn", "pound", "prime", "prod", "prop", "psi", "quot", "rArr", "radic", "rang", "raquo", "rarr", "rceil", "rdquo", "real", "reg", "rfloor", "rho", "rlm", "rsaquo", "rsquo", "sbquo", "scaron", "sdot", "sect", "shy", "sigma", "sigmaf", "sim", "spades", "sub", "sube", "sum", "sup", "sup1", "sup2", "sup3", "supe", "szlig", "tau", "there4", "theta", "thetasym", "thinsp", "thorn", "tilde", "times", "trade", "uArr", "uacute", "uarr", "ucirc", "ugrave", "uml", "upsih", "upsilon", "uuml", "weierp", "xi", "yacute", "yen", "yuml", "zeta", "zwj", "zwnj"};
    private static final int[] blockStarts = new int[]{0, 128, 256, 384, 592, 688, 768, 880, 1024, 1280, 1328, 1424, 1536, 1792, 1872, 1920, 1984, 2048, 2304, 2432, 2560, 2688, 2816, 2944, 3072, 3200, 3328, 3456, 3584, 3712, 3840, 4096, 4256, 4352, 4608, 4992, 5024, 5120, 5760, 5792, 5888, 5920, 5952, 5984, 6016, 6144, 6320, 6400, 6480, 6528, 6624, 6656, 6688, 6912, 7040, 7168, 7248, 7376, 7424, 7552, 7616, 7680, 7936, 8192, 8304, 8352, 8400, 8448, 8528, 8592, 8704, 8960, 9216, 9280, 9312, 9472, 9600, 9632, 9728, 9984, 10176, 10224, 10240, 10496, 10624, 10752, 11008, 11264, 11360, 11392, 11520, 11568, 11648, 11744, 11776, 11904, 12032, 12272, 12288, 12352, 12448, 12544, 12592, 12688, 12704, 12736, 12784, 12800, 13056, 13312, 19904, 19968, 40960, 42128, 42192, 42240, 42560, 42656, 42752, 42784, 43008, 43056, 43072, 43136, 43232, 43264, 43312, 43360, 43392, 43520, 43616, 43648, 43968, 44032, 55216, 57344, 63744, 64256, 64336, 65024, 65040, 65056, 65072, 65104, 65136, 65280, 65520, 65536, 65664, 65792, 65856, 65936, 66000, 66176, 66208, 66304, 66352, 66432, 66464, 66560, 66640, 66688, 67584, 67648, 67840, 67872, 68096, 68192, 68352, 68416, 68448, 68608, 69216, 69760, 73728, 74752, 77824, 118784, 119040, 119296, 119552, 119648, 119808, 126976, 127024, 127232, 127488, 131072, 173824, 194560, 917504, 917760, 983040, 0x100000};
    private static final int[] blockEnds = new int[]{127, 255, 383, 591, 687, 767, 879, 1023, 1279, 1327, 1423, 1535, 1791, 1871, 1919, 1983, 2047, 2111, 2431, 2559, 2687, 2815, 2943, 3071, 3199, 3327, 3455, 3583, 3711, 3839, 4095, 4255, 4351, 4607, 4991, 5023, 5119, 5759, 5791, 5887, 5919, 5951, 5983, 6015, 6143, 6319, 6399, 6479, 6527, 6623, 6655, 6687, 6831, 7039, 7103, 7247, 7295, 7423, 7551, 7615, 7679, 7935, 8191, 8303, 8351, 8399, 8447, 8527, 8591, 8703, 8959, 9215, 9279, 9311, 9471, 9599, 9631, 9727, 9983, 10175, 10223, 10239, 10495, 10623, 10751, 11007, 11263, 11359, 11391, 11519, 11567, 11647, 11743, 11775, 11903, 12031, 12255, 12287, 12351, 12447, 12543, 12591, 12687, 12703, 12735, 12783, 12799, 13055, 13311, 19903, 19967, 40959, 42127, 42191, 42239, 42559, 42655, 42751, 42783, 43007, 43055, 43071, 43135, 43231, 43263, 43311, 43359, 43391, 43487, 43615, 43647, 43743, 44031, 55215, 55295, 63743, 64255, 64335, 65023, 65039, 65055, 65071, 65103, 65135, 65279, 65519, 65535, 65663, 65791, 65855, 65935, 65999, 66047, 66207, 66271, 66351, 66383, 66463, 66527, 66639, 66687, 66735, 67647, 67679, 67871, 67903, 68191, 68223, 68415, 68447, 68479, 68687, 69247, 69839, 74751, 74879, 78895, 119039, 119295, 119375, 119647, 119679, 120831, 127023, 127135, 127487, 127743, 173791, 177983, 195103, 917631, 917999, 1048575, 0x10FFFF};
    public static final char[] WHITESPACE_CHARACTERS = new char[]{'\t', '\n', '\u000b', '\f', '\r', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u2028', '\u2029', '\u205f', '\u3000'};

    private TestUtil() {
    }

    public static void unzip(InputStream in, Path destDir) throws IOException {
        in = new BufferedInputStream(in);
        IOUtils.rm((Path[])new Path[]{destDir});
        Files.createDirectory(destDir, new FileAttribute[0]);
        try (ZipInputStream zipInput = new ZipInputStream(in);){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInput.getNextEntry()) != null) {
                Path targetFile = destDir.resolve(entry.getName());
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                if (!entry.isDirectory()) {
                    int len;
                    OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);
                    while ((len = zipInput.read(buffer)) >= 0) {
                        out.write(buffer, 0, len);
                    }
                    out.close();
                }
                zipInput.closeEntry();
            }
        }
    }

    public static <T> void checkIterator(Iterator<T> iterator, long expectedSize, boolean allowNull) {
        for (long i = 0L; i < expectedSize; ++i) {
            boolean hasNext = iterator.hasNext();
            assert (hasNext);
            T v = iterator.next();
            assert (allowNull || v != null);
            try {
                iterator.remove();
                throw new AssertionError((Object)("broken iterator (supports remove): " + iterator));
            }
            catch (UnsupportedOperationException expected) {
                continue;
            }
        }
        assert (!iterator.hasNext());
        try {
            iterator.next();
            throw new AssertionError((Object)("broken iterator (allows next() when hasNext==false) " + iterator));
        }
        catch (NoSuchElementException expected) {
            return;
        }
    }

    public static <T> void checkIterator(Iterator<T> iterator) {
        while (iterator.hasNext()) {
            T v = iterator.next();
            assert (v != null);
            try {
                iterator.remove();
                throw new AssertionError((Object)("broken iterator (supports remove): " + iterator));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        try {
            iterator.next();
            throw new AssertionError((Object)("broken iterator (allows next() when hasNext==false) " + iterator));
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static <T> void checkReadOnly(Collection<T> coll) {
        int size = 0;
        Iterator<T> it = coll.iterator();
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        if (size != coll.size()) {
            throw new AssertionError((Object)("broken collection, reported size is " + coll.size() + " but iterator has " + size + " elements: " + coll));
        }
        if (!coll.isEmpty()) {
            try {
                coll.remove(coll.iterator().next());
                throw new AssertionError((Object)("broken collection (supports remove): " + coll));
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        try {
            coll.add(null);
            throw new AssertionError((Object)("broken collection (supports add): " + coll));
        }
        catch (UnsupportedOperationException e) {
            try {
                coll.addAll(Collections.singleton(null));
                throw new AssertionError((Object)("broken collection (supports addAll): " + coll));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                TestUtil.checkIterator(coll.iterator());
                return;
            }
        }
    }

    public static void syncConcurrentMerges(IndexWriter writer) {
        TestUtil.syncConcurrentMerges(writer.getConfig().getMergeScheduler());
    }

    public static void syncConcurrentMerges(MergeScheduler ms) {
        if (ms instanceof ConcurrentMergeScheduler) {
            ((ConcurrentMergeScheduler)ms).sync();
        }
    }

    public static CheckIndex.Status checkIndex(Directory dir) throws IOException {
        return TestUtil.checkIndex(dir, true);
    }

    public static CheckIndex.Status checkIndex(Directory dir, boolean crossCheckTermVectors) throws IOException {
        return TestUtil.checkIndex(dir, crossCheckTermVectors, false);
    }

    public static CheckIndex.Status checkIndex(Directory dir, boolean crossCheckTermVectors, boolean failFast) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        try (CheckIndex checker = new CheckIndex(dir, NoLockFactory.INSTANCE.makeLock(dir, "bogus"));){
            checker.setCrossCheckTermVectors(crossCheckTermVectors);
            checker.setFailFast(failFast);
            checker.setInfoStream(new PrintStream((OutputStream)bos, false, IOUtils.UTF_8), false);
            CheckIndex.Status indexStatus = checker.checkIndex(null);
            if (indexStatus == null || !indexStatus.clean) {
                System.out.println("CheckIndex failed");
                System.out.println(bos.toString(IOUtils.UTF_8));
                throw new RuntimeException("CheckIndex failed");
            }
            if (LuceneTestCase.INFOSTREAM) {
                System.out.println(bos.toString(IOUtils.UTF_8));
            }
            CheckIndex.Status status = indexStatus;
            return status;
        }
    }

    public static void checkReader(IndexReader reader) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            TestUtil.checkReader(context.reader(), true);
        }
    }

    public static void checkReader(LeafReader reader, boolean crossCheckTermVectors) throws IOException {
        LeafReader unwrapped;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        PrintStream infoStream = new PrintStream((OutputStream)bos, false, IOUtils.UTF_8);
        reader.checkIntegrity();
        CheckIndex.testLiveDocs((LeafReader)reader, (PrintStream)infoStream, (boolean)true);
        CheckIndex.testFieldInfos((LeafReader)reader, (PrintStream)infoStream, (boolean)true);
        CheckIndex.testFieldNorms((LeafReader)reader, (PrintStream)infoStream, (boolean)true);
        CheckIndex.testPostings((LeafReader)reader, (PrintStream)infoStream, (boolean)false, (boolean)true);
        CheckIndex.testStoredFields((LeafReader)reader, (PrintStream)infoStream, (boolean)true);
        CheckIndex.testTermVectors((LeafReader)reader, (PrintStream)infoStream, (boolean)false, (boolean)crossCheckTermVectors, (boolean)true);
        CheckIndex.testDocValues((LeafReader)reader, (PrintStream)infoStream, (boolean)true);
        if (LuceneTestCase.INFOSTREAM) {
            System.out.println(bos.toString(IOUtils.UTF_8));
        }
        if ((unwrapped = FilterLeafReader.unwrap((LeafReader)reader)) instanceof SegmentReader) {
            SegmentReader sr = (SegmentReader)unwrapped;
            long bytesUsed = sr.ramBytesUsed();
            if (sr.ramBytesUsed() < 0L) {
                throw new IllegalStateException("invalid ramBytesUsed for reader: " + bytesUsed);
            }
            assert (Accountables.toString((Accountable)sr) != null);
        }
    }

    public static int nextInt(Random r, int start, int end) {
        return RandomInts.randomIntBetween((Random)r, (int)start, (int)end);
    }

    public static long nextLong(Random r, long start, long end) {
        assert (end >= start);
        BigInteger range = BigInteger.valueOf(end).add(BigInteger.valueOf(1L)).subtract(BigInteger.valueOf(start));
        if (range.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
            return start + (long)r.nextInt(range.intValue());
        }
        BigInteger augend = new BigDecimal(range).multiply(new BigDecimal(r.nextDouble())).toBigInteger();
        long result = BigInteger.valueOf(start).add(augend).longValue();
        assert (result >= start);
        assert (result <= end);
        return result;
    }

    public static String randomSimpleString(Random r, int maxLength) {
        return TestUtil.randomSimpleString(r, 0, maxLength);
    }

    public static String randomSimpleString(Random r, int minLength, int maxLength) {
        int end = TestUtil.nextInt(r, minLength, maxLength);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        for (int i = 0; i < end; ++i) {
            buffer[i] = (char)TestUtil.nextInt(r, 97, 122);
        }
        return new String(buffer, 0, end);
    }

    public static String randomSimpleStringRange(Random r, char minChar, char maxChar, int maxLength) {
        int end = TestUtil.nextInt(r, 0, maxLength);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        for (int i = 0; i < end; ++i) {
            buffer[i] = (char)TestUtil.nextInt(r, minChar, maxChar);
        }
        return new String(buffer, 0, end);
    }

    public static String randomSimpleString(Random r) {
        return TestUtil.randomSimpleString(r, 0, 10);
    }

    public static String randomUnicodeString(Random r) {
        return TestUtil.randomUnicodeString(r, 20);
    }

    public static String randomUnicodeString(Random r, int maxLength) {
        int end = TestUtil.nextInt(r, 0, maxLength);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        TestUtil.randomFixedLengthUnicodeString(r, buffer, 0, buffer.length);
        return new String(buffer, 0, end);
    }

    public static void randomFixedLengthUnicodeString(Random random, char[] chars, int offset, int length) {
        int i = offset;
        int end = offset + length;
        while (i < end) {
            int t = random.nextInt(5);
            if (0 == t && i < length - 1) {
                chars[i++] = (char)TestUtil.nextInt(random, 55296, 56319);
                chars[i++] = (char)TestUtil.nextInt(random, 56320, 57343);
                continue;
            }
            if (t <= 1) {
                chars[i++] = (char)random.nextInt(128);
                continue;
            }
            if (2 == t) {
                chars[i++] = (char)TestUtil.nextInt(random, 128, 2047);
                continue;
            }
            if (3 == t) {
                chars[i++] = (char)TestUtil.nextInt(random, 2048, 55295);
                continue;
            }
            if (4 != t) continue;
            chars[i++] = (char)TestUtil.nextInt(random, 57344, 65535);
        }
    }

    public static String randomRegexpishString(Random r) {
        return TestUtil.randomRegexpishString(r, 20);
    }

    public static String randomRegexpishString(Random r, int maxLength) {
        StringBuilder regexp = new StringBuilder(maxLength);
        for (int i = TestUtil.nextInt(r, 0, maxLength); i > 0; --i) {
            if (r.nextBoolean()) {
                regexp.append((char)RandomInts.randomIntBetween((Random)r, (int)97, (int)122));
                continue;
            }
            regexp.append((String)RandomPicks.randomFrom((Random)r, ops));
        }
        return regexp.toString();
    }

    public static String randomHtmlishString(Random random, int numElements) {
        int end = TestUtil.nextInt(random, 0, numElements);
        if (end == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block35: for (int i = 0; i < end; ++i) {
            int val = random.nextInt(25);
            switch (val) {
                case 0: {
                    sb.append("<p>");
                    continue block35;
                }
                case 1: {
                    sb.append("<");
                    sb.append("    ".substring(TestUtil.nextInt(random, 0, 4)));
                    sb.append(TestUtil.randomSimpleString(random));
                    for (int j = 0; j < TestUtil.nextInt(random, 0, 10); ++j) {
                        sb.append(' ');
                        sb.append(TestUtil.randomSimpleString(random));
                        sb.append(" ".substring(TestUtil.nextInt(random, 0, 1)));
                        sb.append('=');
                        sb.append(" ".substring(TestUtil.nextInt(random, 0, 1)));
                        sb.append("\"".substring(TestUtil.nextInt(random, 0, 1)));
                        sb.append(TestUtil.randomSimpleString(random));
                        sb.append("\"".substring(TestUtil.nextInt(random, 0, 1)));
                    }
                    sb.append("    ".substring(TestUtil.nextInt(random, 0, 4)));
                    sb.append("/".substring(TestUtil.nextInt(random, 0, 1)));
                    sb.append(">".substring(TestUtil.nextInt(random, 0, 1)));
                    continue block35;
                }
                case 2: {
                    sb.append("</");
                    sb.append("    ".substring(TestUtil.nextInt(random, 0, 4)));
                    sb.append(TestUtil.randomSimpleString(random));
                    sb.append("    ".substring(TestUtil.nextInt(random, 0, 4)));
                    sb.append(">".substring(TestUtil.nextInt(random, 0, 1)));
                    continue block35;
                }
                case 3: {
                    sb.append(">");
                    continue block35;
                }
                case 4: {
                    sb.append("</p>");
                    continue block35;
                }
                case 5: {
                    sb.append("<!--");
                    continue block35;
                }
                case 6: {
                    sb.append("<!--#");
                    continue block35;
                }
                case 7: {
                    sb.append("<script><!-- f('");
                    continue block35;
                }
                case 8: {
                    sb.append("</script>");
                    continue block35;
                }
                case 9: {
                    sb.append("<?");
                    continue block35;
                }
                case 10: {
                    sb.append("?>");
                    continue block35;
                }
                case 11: {
                    sb.append("\"");
                    continue block35;
                }
                case 12: {
                    sb.append("\\\"");
                    continue block35;
                }
                case 13: {
                    sb.append("'");
                    continue block35;
                }
                case 14: {
                    sb.append("\\'");
                    continue block35;
                }
                case 15: {
                    sb.append("-->");
                    continue block35;
                }
                case 16: {
                    sb.append("&");
                    switch (TestUtil.nextInt(random, 0, 2)) {
                        case 0: {
                            sb.append(TestUtil.randomSimpleString(random));
                            break;
                        }
                        case 1: {
                            sb.append(HTML_CHAR_ENTITIES[random.nextInt(HTML_CHAR_ENTITIES.length)]);
                        }
                    }
                    sb.append(";".substring(TestUtil.nextInt(random, 0, 1)));
                    continue block35;
                }
                case 17: {
                    sb.append("&#");
                    if (0 != TestUtil.nextInt(random, 0, 1)) continue block35;
                    sb.append(TestUtil.nextInt(random, 0, 0x7FFFFFFE));
                    sb.append(";".substring(TestUtil.nextInt(random, 0, 1)));
                    continue block35;
                }
                case 18: {
                    sb.append("&#x");
                    if (0 != TestUtil.nextInt(random, 0, 1)) continue block35;
                    sb.append(Integer.toString(TestUtil.nextInt(random, 0, 0x7FFFFFFE), 16));
                    sb.append(";".substring(TestUtil.nextInt(random, 0, 1)));
                    continue block35;
                }
                case 19: {
                    sb.append(";");
                    continue block35;
                }
                case 20: {
                    sb.append(TestUtil.nextInt(random, 0, 0x7FFFFFFE));
                    continue block35;
                }
                case 21: {
                    sb.append("\n");
                    continue block35;
                }
                case 22: {
                    sb.append("          ".substring(TestUtil.nextInt(random, 0, 10)));
                    continue block35;
                }
                case 23: {
                    sb.append("<");
                    if (0 == TestUtil.nextInt(random, 0, 3)) {
                        sb.append("          ".substring(TestUtil.nextInt(random, 1, 10)));
                    }
                    if (0 == TestUtil.nextInt(random, 0, 1)) {
                        sb.append("/");
                        if (0 == TestUtil.nextInt(random, 0, 3)) {
                            sb.append("          ".substring(TestUtil.nextInt(random, 1, 10)));
                        }
                    }
                    switch (TestUtil.nextInt(random, 0, 3)) {
                        case 0: {
                            sb.append(TestUtil.randomlyRecaseCodePoints(random, "script"));
                            break;
                        }
                        case 1: {
                            sb.append(TestUtil.randomlyRecaseCodePoints(random, "style"));
                            break;
                        }
                        case 2: {
                            sb.append(TestUtil.randomlyRecaseCodePoints(random, "br"));
                        }
                    }
                    sb.append(">".substring(TestUtil.nextInt(random, 0, 1)));
                    continue block35;
                }
                default: {
                    sb.append(TestUtil.randomSimpleString(random));
                }
            }
        }
        return sb.toString();
    }

    public static String randomlyRecaseCodePoints(Random random, String str) {
        StringBuilder builder = new StringBuilder();
        int pos = 0;
        while (pos < str.length()) {
            int codePoint = str.codePointAt(pos);
            pos += Character.charCount(codePoint);
            switch (TestUtil.nextInt(random, 0, 2)) {
                case 0: {
                    builder.appendCodePoint(Character.toUpperCase(codePoint));
                    break;
                }
                case 1: {
                    builder.appendCodePoint(Character.toLowerCase(codePoint));
                    break;
                }
                case 2: {
                    builder.appendCodePoint(codePoint);
                }
            }
        }
        return builder.toString();
    }

    public static String randomRealisticUnicodeString(Random r) {
        return TestUtil.randomRealisticUnicodeString(r, 20);
    }

    public static String randomRealisticUnicodeString(Random r, int maxLength) {
        return TestUtil.randomRealisticUnicodeString(r, 0, maxLength);
    }

    public static String randomRealisticUnicodeString(Random r, int minLength, int maxLength) {
        int end = TestUtil.nextInt(r, minLength, maxLength);
        int block = r.nextInt(blockStarts.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < end; ++i) {
            sb.appendCodePoint(TestUtil.nextInt(r, blockStarts[block], blockEnds[block]));
        }
        return sb.toString();
    }

    public static String randomFixedByteLengthUnicodeString(Random r, int length) {
        int i;
        char[] buffer = new char[length * 3];
        int bytes = length;
        for (i = 0; i < buffer.length && bytes != 0; ++i) {
            int t = bytes >= 4 ? r.nextInt(5) : (bytes >= 3 ? r.nextInt(4) : (bytes >= 2 ? r.nextInt(2) : 0));
            if (t == 0) {
                buffer[i] = (char)r.nextInt(128);
                --bytes;
                continue;
            }
            if (1 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 128, 2047);
                bytes -= 2;
                continue;
            }
            if (2 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 2048, 55295);
                bytes -= 3;
                continue;
            }
            if (3 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 57344, 65535);
                bytes -= 3;
                continue;
            }
            if (4 != t) continue;
            buffer[i++] = (char)TestUtil.nextInt(r, 55296, 56319);
            buffer[i] = (char)TestUtil.nextInt(r, 56320, 57343);
            bytes -= 4;
        }
        return new String(buffer, 0, i);
    }

    public static Codec alwaysPostingsFormat(final PostingsFormat format) {
        if (LuceneTestCase.VERBOSE) {
            System.out.println("forcing postings format to:" + format);
        }
        return new AssertingCodec(){

            @Override
            public PostingsFormat getPostingsFormatForField(String field) {
                return format;
            }
        };
    }

    public static Codec alwaysDocValuesFormat(final DocValuesFormat format) {
        if (LuceneTestCase.VERBOSE) {
            System.out.println("forcing docvalues format to:" + format);
        }
        return new AssertingCodec(){

            @Override
            public DocValuesFormat getDocValuesFormatForField(String field) {
                return format;
            }
        };
    }

    public static Codec getDefaultCodec() {
        return new Lucene50Codec();
    }

    public static PostingsFormat getDefaultPostingsFormat() {
        return new Lucene50PostingsFormat();
    }

    public static PostingsFormat getDefaultPostingsFormat(int minItemsPerBlock, int maxItemsPerBlock) {
        return new Lucene50PostingsFormat(minItemsPerBlock, maxItemsPerBlock);
    }

    public static PostingsFormat getPostingsFormatWithOrds(Random r) {
        switch (r.nextInt(2)) {
            case 0: {
                return new LuceneFixedGap();
            }
            case 1: {
                return new BlockTreeOrdsPostingsFormat();
            }
        }
        throw new AssertionError();
    }

    public static DocValuesFormat getDefaultDocValuesFormat() {
        return new Lucene50DocValuesFormat();
    }

    public static String getPostingsFormat(String field) {
        return TestUtil.getPostingsFormat(Codec.getDefault(), field);
    }

    public static String getPostingsFormat(Codec codec, String field) {
        PostingsFormat p = codec.postingsFormat();
        if (p instanceof PerFieldPostingsFormat) {
            return ((PerFieldPostingsFormat)p).getPostingsFormatForField(field).getName();
        }
        return p.getName();
    }

    public static String getDocValuesFormat(String field) {
        return TestUtil.getDocValuesFormat(Codec.getDefault(), field);
    }

    public static String getDocValuesFormat(Codec codec, String field) {
        DocValuesFormat f = codec.docValuesFormat();
        if (f instanceof PerFieldDocValuesFormat) {
            return ((PerFieldDocValuesFormat)f).getDocValuesFormatForField(field).getName();
        }
        return f.getName();
    }

    public static boolean fieldSupportsHugeBinaryDocValues(String field) {
        String dvFormat = TestUtil.getDocValuesFormat(field);
        return !dvFormat.equals("Lucene40") && !dvFormat.equals("Lucene42") && !dvFormat.equals("Memory");
    }

    public static boolean anyFilesExceptWriteLock(Directory dir) throws IOException {
        String[] files = dir.listAll();
        return files.length > 1 || files.length == 1 && !files[0].equals("write.lock");
    }

    public static void addIndexesSlowly(IndexWriter writer, DirectoryReader ... readers) throws IOException {
        ArrayList<CodecReader> leaves = new ArrayList<CodecReader>();
        for (DirectoryReader reader : readers) {
            for (LeafReaderContext context : reader.leaves()) {
                leaves.add(SlowCodecReaderWrapper.wrap((LeafReader)context.reader()));
            }
        }
        writer.addIndexes(leaves.toArray(new CodecReader[leaves.size()]));
    }

    public static void reduceOpenFiles(IndexWriter w) {
        MergePolicy mp = w.getConfig().getMergePolicy();
        if (mp instanceof LogMergePolicy) {
            LogMergePolicy lmp = (LogMergePolicy)mp;
            lmp.setMergeFactor(Math.min(5, lmp.getMergeFactor()));
            lmp.setNoCFSRatio(1.0);
        } else if (mp instanceof TieredMergePolicy) {
            TieredMergePolicy tmp = (TieredMergePolicy)mp;
            tmp.setMaxMergeAtOnce(Math.min(5, tmp.getMaxMergeAtOnce()));
            tmp.setSegmentsPerTier(Math.min(5.0, tmp.getSegmentsPerTier()));
            tmp.setNoCFSRatio(1.0);
        }
        MergeScheduler ms = w.getConfig().getMergeScheduler();
        if (ms instanceof ConcurrentMergeScheduler) {
            ((ConcurrentMergeScheduler)ms).setMaxMergesAndThreads(3, 2);
        }
    }

    public static <T> void assertAttributeReflection(AttributeImpl att, Map<String, T> reflectedValues) {
        final HashMap map = new HashMap();
        att.reflectWith(new AttributeReflector(){

            public void reflect(Class<? extends Attribute> attClass, String key, Object value) {
                map.put(attClass.getName() + '#' + key, value);
            }
        });
        Assert.assertEquals((String)"Reflection does not produce same map", reflectedValues, map);
    }

    public static void assertEquals(TopDocs expected, TopDocs actual) {
        Assert.assertEquals((String)"wrong total hits", (long)expected.totalHits, (long)actual.totalHits);
        Assert.assertEquals((String)"wrong maxScore", (double)expected.getMaxScore(), (double)actual.getMaxScore(), (double)0.0);
        Assert.assertEquals((String)"wrong hit count", (long)expected.scoreDocs.length, (long)actual.scoreDocs.length);
        for (int hitIDX = 0; hitIDX < expected.scoreDocs.length; ++hitIDX) {
            ScoreDoc expectedSD = expected.scoreDocs[hitIDX];
            ScoreDoc actualSD = actual.scoreDocs[hitIDX];
            Assert.assertEquals((String)"wrong hit docID", (long)expectedSD.doc, (long)actualSD.doc);
            Assert.assertEquals((String)"wrong hit score", (double)expectedSD.score, (double)actualSD.score, (double)0.0);
            if (expectedSD instanceof FieldDoc) {
                Assert.assertTrue((boolean)(actualSD instanceof FieldDoc));
                Assert.assertArrayEquals((String)"wrong sort field values", (Object[])((FieldDoc)expectedSD).fields, (Object[])((FieldDoc)actualSD).fields);
                continue;
            }
            Assert.assertFalse((boolean)(actualSD instanceof FieldDoc));
        }
    }

    public static Document cloneDocument(Document doc1) {
        Document doc2 = new Document();
        for (IndexableField f : doc1.getFields()) {
            Field field2;
            block13: {
                Field field1;
                block14: {
                    FieldType.NumericType numType;
                    block12: {
                        field1 = (Field)f;
                        DocValuesType dvType = field1.fieldType().docValuesType();
                        numType = field1.fieldType().numericType();
                        if (dvType == DocValuesType.NONE) break block12;
                        switch (dvType) {
                            case NUMERIC: {
                                field2 = new NumericDocValuesField(field1.name(), field1.numericValue().longValue());
                                break block13;
                            }
                            case BINARY: {
                                field2 = new BinaryDocValuesField(field1.name(), field1.binaryValue());
                                break block13;
                            }
                            case SORTED: {
                                field2 = new SortedDocValuesField(field1.name(), field1.binaryValue());
                                break block13;
                            }
                            default: {
                                throw new IllegalStateException("unknown Type: " + dvType);
                            }
                        }
                    }
                    if (numType == null) break block14;
                    switch (numType) {
                        case INT: {
                            field2 = new IntField(field1.name(), field1.numericValue().intValue(), field1.fieldType());
                            break block13;
                        }
                        case FLOAT: {
                            field2 = new FloatField(field1.name(), (float)field1.numericValue().intValue(), field1.fieldType());
                            break block13;
                        }
                        case LONG: {
                            field2 = new LongField(field1.name(), (long)field1.numericValue().intValue(), field1.fieldType());
                            break block13;
                        }
                        case DOUBLE: {
                            field2 = new DoubleField(field1.name(), (double)field1.numericValue().intValue(), field1.fieldType());
                            break block13;
                        }
                        default: {
                            throw new IllegalStateException("unknown Type: " + numType);
                        }
                    }
                }
                field2 = new Field(field1.name(), field1.stringValue(), field1.fieldType());
            }
            doc2.add((IndexableField)field2);
        }
        return doc2;
    }

    public static DocsEnum docs(Random random, IndexReader r, String field, BytesRef term, Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
        Terms terms = MultiFields.getTerms((IndexReader)r, (String)field);
        if (terms == null) {
            return null;
        }
        TermsEnum termsEnum = terms.iterator(null);
        if (!termsEnum.seekExact(term)) {
            return null;
        }
        return TestUtil.docs(random, termsEnum, liveDocs, reuse, flags);
    }

    public static DocsEnum docs(Random random, TermsEnum termsEnum, Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
        if (random.nextBoolean()) {
            if (random.nextBoolean()) {
                int posFlags;
                switch (random.nextInt(4)) {
                    case 0: {
                        posFlags = 0;
                        break;
                    }
                    case 1: {
                        posFlags = 1;
                        break;
                    }
                    case 2: {
                        posFlags = 2;
                        break;
                    }
                    default: {
                        posFlags = 3;
                    }
                }
                DocsAndPositionsEnum docsAndPositions = termsEnum.docsAndPositions(liveDocs, null, posFlags);
                if (docsAndPositions != null) {
                    return docsAndPositions;
                }
            }
            flags |= 1;
        }
        return termsEnum.docs(liveDocs, reuse, flags);
    }

    public static CharSequence stringToCharSequence(String string, Random random) {
        return TestUtil.bytesToCharSequence(new BytesRef((CharSequence)string), random);
    }

    public static CharSequence bytesToCharSequence(BytesRef ref, Random random) {
        switch (random.nextInt(5)) {
            case 4: {
                char[] chars = new char[ref.length];
                int len = UnicodeUtil.UTF8toUTF16((byte[])ref.bytes, (int)ref.offset, (int)ref.length, (char[])chars);
                return new CharsRef(chars, 0, len);
            }
            case 3: {
                return CharBuffer.wrap(ref.utf8ToString());
            }
        }
        return ref.utf8ToString();
    }

    public static void shutdownExecutorService(ExecutorService ex) {
        if (ex != null) {
            try {
                ex.shutdown();
                ex.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("Could not properly close executor service.");
                e.printStackTrace(System.err);
            }
        }
    }

    public static Pattern randomPattern(Random random) {
        String nonBmpString = "AB\ud840\udc00C";
        while (true) {
            try {
                Pattern p;
                String replacement;
                do {
                    p = Pattern.compile(TestUtil.randomRegexpishString(random));
                    replacement = null;
                    try {
                        replacement = p.matcher("AB\ud840\udc00C").replaceAll("_");
                    }
                    catch (StringIndexOutOfBoundsException jdkBug) {
                        System.out.println("WARNING: your jdk is buggy!");
                        System.out.println("Pattern.compile(\"" + p.pattern() + "\").matcher(\"AB\\uD840\\uDC00C\").replaceAll(\"_\"); should not throw IndexOutOfBounds!");
                    }
                } while (replacement == null || !UnicodeUtil.validUTF16String((CharSequence)replacement));
                return p;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                continue;
            }
            break;
        }
    }

    public static final FilteredQuery.FilterStrategy randomFilterStrategy(Random random) {
        switch (random.nextInt(6)) {
            case 4: 
            case 5: {
                return new FilteredQuery.RandomAccessFilterStrategy(){

                    protected boolean useRandomAccess(Bits bits, long filterCost) {
                        return LuceneTestCase.random().nextBoolean();
                    }
                };
            }
            case 3: {
                return FilteredQuery.RANDOM_ACCESS_FILTER_STRATEGY;
            }
            case 2: {
                return FilteredQuery.LEAP_FROG_FILTER_FIRST_STRATEGY;
            }
            case 1: {
                return FilteredQuery.LEAP_FROG_QUERY_FIRST_STRATEGY;
            }
            case 0: {
                return FilteredQuery.QUERY_FIRST_FILTER_STRATEGY;
            }
        }
        return FilteredQuery.RANDOM_ACCESS_FILTER_STRATEGY;
    }

    public static String randomWhitespace(Random r, int minLength, int maxLength) {
        int end = TestUtil.nextInt(r, minLength, maxLength);
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < end; ++i) {
            int offset = TestUtil.nextInt(r, 0, WHITESPACE_CHARACTERS.length - 1);
            char c = WHITESPACE_CHARACTERS[offset];
            Assert.assertTrue((String)("Not really whitespace? (@" + offset + "): " + c), (boolean)Character.isWhitespace(c));
            out.append(c);
        }
        return out.toString();
    }

    public static String randomAnalysisString(Random random, int maxLength, boolean simple) {
        assert (maxLength >= 0);
        if (random.nextInt(31) == 0) {
            return TestUtil.randomSubString(random, random.nextInt(maxLength), simple);
        }
        maxLength = random.nextInt(maxLength);
        int avgWordLength = TestUtil.nextInt(random, 3, 8);
        StringBuilder sb = new StringBuilder();
        while (sb.length() < maxLength) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            int wordLength = -1;
            while (wordLength < 0) {
                wordLength = (int)(random.nextGaussian() * 3.0 + (double)avgWordLength);
            }
            wordLength = Math.min(wordLength, maxLength - sb.length());
            sb.append(TestUtil.randomSubString(random, wordLength, simple));
        }
        return sb.toString();
    }

    public static String randomSubString(Random random, int wordLength, boolean simple) {
        if (wordLength == 0) {
            return "";
        }
        int evilness = TestUtil.nextInt(random, 0, 20);
        StringBuilder sb = new StringBuilder();
        while (sb.length() < wordLength) {
            if (simple) {
                sb.append(random.nextBoolean() ? TestUtil.randomSimpleString(random, wordLength) : TestUtil.randomHtmlishString(random, wordLength));
                continue;
            }
            if (evilness < 10) {
                sb.append(TestUtil.randomSimpleString(random, wordLength));
                continue;
            }
            if (evilness < 15) {
                assert (sb.length() == 0);
                sb.append(TestUtil.randomRealisticUnicodeString(random, wordLength, wordLength));
                continue;
            }
            if (evilness == 16) {
                sb.append(TestUtil.randomHtmlishString(random, wordLength));
                continue;
            }
            if (evilness == 17) {
                sb.append(TestUtil.randomRegexpishString(random, wordLength));
                continue;
            }
            sb.append(TestUtil.randomUnicodeString(random, wordLength));
        }
        if (sb.length() > wordLength) {
            sb.setLength(wordLength);
            if (Character.isHighSurrogate(sb.charAt(wordLength - 1))) {
                sb.setLength(wordLength - 1);
            }
        }
        if (random.nextInt(17) == 0) {
            String mixedUp = TestUtil.randomlyRecaseCodePoints(random, sb.toString());
            assert (mixedUp.length() == sb.length());
            return mixedUp;
        }
        return sb.toString();
    }

    public static boolean isWindowsFS(Directory dir) {
        while (true) {
            if (dir instanceof FSDirectory) {
                return TestUtil.isWindowsFS(((FSDirectory)dir).getDirectory());
            }
            if (!(dir instanceof FilterDirectory)) break;
            dir = ((FilterDirectory)dir).getDelegate();
        }
        return false;
    }

    public static boolean isWindowsFS(Path path) {
        FileSystem fs = path.getFileSystem();
        while (fs instanceof FilterFileSystem) {
            if (((FilterFileSystem)fs).getParent() instanceof WindowsFS) {
                return true;
            }
            fs = ((FilterFileSystem)fs).getDelegate();
        }
        return false;
    }
}

