/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Random;
import org.apache.lucene.index.AssertingDirectoryReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MismatchedLeafReader;

public class MismatchedDirectoryReader
extends FilterDirectoryReader {
    public MismatchedDirectoryReader(DirectoryReader in, Random random) {
        super(in, (FilterDirectoryReader.SubReaderWrapper)new MismatchedSubReaderWrapper(random));
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
        return new AssertingDirectoryReader(in);
    }

    static class MismatchedSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        final Random random;

        MismatchedSubReaderWrapper(Random random) {
            this.random = random;
        }

        public LeafReader wrap(LeafReader reader) {
            return new MismatchedLeafReader(reader, this.random);
        }
    }
}

