/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.mockrandom;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.blockterms.BlockTermsReader;
import org.apache.lucene.codecs.blockterms.BlockTermsWriter;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexReader;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexWriter;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.codecs.blockterms.VariableGapTermsIndexReader;
import org.apache.lucene.codecs.blockterms.VariableGapTermsIndexWriter;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsReader;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsWriter;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsReader;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsWriter;
import org.apache.lucene.codecs.memory.FSTOrdTermsReader;
import org.apache.lucene.codecs.memory.FSTOrdTermsWriter;
import org.apache.lucene.codecs.memory.FSTTermsReader;
import org.apache.lucene.codecs.memory.FSTTermsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public final class MockRandomPostingsFormat
extends PostingsFormat {
    private final Random seedRandom;
    private final String SEED_EXT = "sd";

    public MockRandomPostingsFormat() {
        this(null);
    }

    public MockRandomPostingsFormat(Random random) {
        super("MockRandom");
        this.seedRandom = random == null ? new Random(0L){

            @Override
            protected int next(int arg0) {
                throw new IllegalStateException("Please use MockRandomPostingsFormat(Random)");
            }
        } : new Random(random.nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FSTTermsWriter fields;
        int minSkipInterval = state.segmentInfo.getDocCount() > 1000000 ? 3 : 2;
        int skipInterval = TestUtil.nextInt(this.seedRandom, minSkipInterval, 10);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: skipInterval=" + skipInterval);
        }
        long seed = this.seedRandom.nextLong();
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: writing to seg=" + state.segmentInfo.name + " formatID=" + state.segmentSuffix + " seed=" + seed);
        }
        String seedFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"sd");
        try (IndexOutput out = state.directory.createOutput(seedFileName, state.context);){
            out.writeLong(seed);
        }
        Random random = new Random(seed);
        random.nextInt();
        Lucene50PostingsWriter postingsWriter = new Lucene50PostingsWriter(state);
        int t1 = random.nextInt(5);
        if (t1 == 0) {
            boolean success = false;
            try {
                fields = new FSTTermsWriter(state, (PostingsWriterBase)postingsWriter);
                success = true;
            }
            finally {
                if (!success) {
                    postingsWriter.close();
                }
            }
        }
        if (t1 == 1) {
            boolean success = false;
            try {
                fields = new FSTOrdTermsWriter(state, (PostingsWriterBase)postingsWriter);
                success = true;
            }
            finally {
                if (!success) {
                    postingsWriter.close();
                }
            }
        }
        if (t1 == 2) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: writing BlockTree terms dict");
            }
            int minTermsInBlock = TestUtil.nextInt(random, 2, 100);
            int maxTermsInBlock = Math.max(2, (minTermsInBlock - 1) * 2 + random.nextInt(100));
            boolean success = false;
            try {
                fields = new BlockTreeTermsWriter(state, (PostingsWriterBase)postingsWriter, minTermsInBlock, maxTermsInBlock);
                success = true;
            }
            finally {
                if (!success) {
                    postingsWriter.close();
                }
            }
        }
        if (t1 == 3) {
            FixedGapTermsIndexWriter indexWriter;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: writing Block terms dict");
            }
            boolean success = false;
            try {
                if (random.nextBoolean()) {
                    int termIndexInterval = TestUtil.nextInt(random, 1, 100);
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("MockRandomCodec: fixed-gap terms index (tii=" + termIndexInterval + ")");
                    }
                    indexWriter = new FixedGapTermsIndexWriter(state, termIndexInterval);
                } else {
                    Object selector;
                    int n2 = random.nextInt(3);
                    if (n2 == 0) {
                        int tii = TestUtil.nextInt(random, 1, 100);
                        selector = new VariableGapTermsIndexWriter.EveryNTermSelector(tii);
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("MockRandomCodec: variable-gap terms index (tii=" + tii + ")");
                        }
                    } else if (n2 == 1) {
                        int docFreqThresh = TestUtil.nextInt(random, 2, 100);
                        int tii = TestUtil.nextInt(random, 1, 100);
                        selector = new VariableGapTermsIndexWriter.EveryNOrDocFreqTermSelector(docFreqThresh, tii);
                    } else {
                        final long seed2 = random.nextLong();
                        final int gap = TestUtil.nextInt(random, 2, 40);
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("MockRandomCodec: random-gap terms index (max gap=" + gap + ")");
                        }
                        selector = new VariableGapTermsIndexWriter.IndexTermSelector(){
                            final Random rand;
                            {
                                this.rand = new Random(seed2);
                            }

                            public boolean isIndexTerm(BytesRef term, TermStats stats) {
                                return this.rand.nextInt(gap) == gap / 2;
                            }

                            public void newField(FieldInfo fieldInfo) {
                            }
                        };
                    }
                    indexWriter = new VariableGapTermsIndexWriter(state, (VariableGapTermsIndexWriter.IndexTermSelector)selector);
                }
                success = true;
            }
            finally {
                if (!success) {
                    postingsWriter.close();
                }
            }
            success = false;
            try {
                fields = new BlockTermsWriter((TermsIndexWriterBase)indexWriter, state, (PostingsWriterBase)postingsWriter);
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        postingsWriter.close();
                    }
                    finally {
                        indexWriter.close();
                    }
                }
            }
        }
        if (t1 == 4) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: writing OrdsBlockTree");
            }
            int minTermsInBlock = TestUtil.nextInt(random, 2, 100);
            int maxTermsInBlock = Math.max(2, (minTermsInBlock - 1) * 2 + random.nextInt(100));
            boolean success = false;
            try {
                fields = new OrdsBlockTreeTermsWriter(state, (PostingsWriterBase)postingsWriter, minTermsInBlock, maxTermsInBlock);
                success = true;
            }
            finally {
                if (!success) {
                    postingsWriter.close();
                }
            }
        } else {
            throw new AssertionError();
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FSTTermsReader fields;
        String seedFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"sd");
        IndexInput in = state.directory.openInput(seedFileName, state.context);
        long seed = in.readLong();
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: reading from seg=" + state.segmentInfo.name + " formatID=" + state.segmentSuffix + " seed=" + seed);
        }
        in.close();
        Random random = new Random(seed);
        int readBufferSize = TestUtil.nextInt(random, 1, 4096);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: readBufferSize=" + readBufferSize);
        }
        Lucene50PostingsReader postingsReader = new Lucene50PostingsReader(state);
        int t1 = random.nextInt(5);
        if (t1 == 0) {
            boolean success = false;
            try {
                fields = new FSTTermsReader(state, (PostingsReaderBase)postingsReader);
                success = true;
            }
            finally {
                if (!success) {
                    postingsReader.close();
                }
            }
        }
        if (t1 == 1) {
            boolean success = false;
            try {
                fields = new FSTOrdTermsReader(state, (PostingsReaderBase)postingsReader);
                success = true;
            }
            finally {
                if (!success) {
                    postingsReader.close();
                }
            }
        }
        if (t1 == 2) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: reading BlockTree terms dict");
            }
            boolean success = false;
            try {
                fields = new BlockTreeTermsReader((PostingsReaderBase)postingsReader, state);
                success = true;
            }
            finally {
                if (!success) {
                    postingsReader.close();
                }
            }
        }
        if (t1 == 3) {
            FixedGapTermsIndexReader indexReader;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: reading Block terms dict");
            }
            boolean success = false;
            try {
                boolean doFixedGap = random.nextBoolean();
                if (doFixedGap) {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("MockRandomCodec: fixed-gap terms index");
                    }
                    indexReader = new FixedGapTermsIndexReader(state);
                } else {
                    int n2 = random.nextInt(3);
                    if (n2 == 1) {
                        random.nextInt();
                    } else if (n2 == 2) {
                        random.nextLong();
                    }
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("MockRandomCodec: variable-gap terms index");
                    }
                    indexReader = new VariableGapTermsIndexReader(state);
                }
                success = true;
            }
            finally {
                if (!success) {
                    postingsReader.close();
                }
            }
            success = false;
            try {
                fields = new BlockTermsReader((TermsIndexReaderBase)indexReader, (PostingsReaderBase)postingsReader, state);
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        postingsReader.close();
                    }
                    finally {
                        indexReader.close();
                    }
                }
            }
        }
        if (t1 == 4) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: reading OrdsBlockTree terms dict");
            }
            boolean success = false;
            try {
                fields = new OrdsBlockTreeTermsReader((PostingsReaderBase)postingsReader, state);
                success = true;
            }
            finally {
                if (!success) {
                    postingsReader.close();
                }
            }
        } else {
            throw new AssertionError();
        }
        return fields;
    }
}

