/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.TestUtil;

public class BaseDirectoryWrapper
extends FilterDirectory {
    private boolean checkIndexOnClose = true;
    private boolean crossCheckTermVectorsOnClose = true;
    protected volatile boolean isOpen = true;

    public BaseDirectoryWrapper(Directory delegate) {
        super(delegate);
    }

    public void close() throws IOException {
        this.isOpen = false;
        if (this.checkIndexOnClose && DirectoryReader.indexExists((Directory)this)) {
            TestUtil.checkIndex((Directory)this, this.crossCheckTermVectorsOnClose);
        }
        super.close();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setCheckIndexOnClose(boolean value) {
        this.checkIndexOnClose = value;
    }

    public boolean getCheckIndexOnClose() {
        return this.checkIndexOnClose;
    }

    public void setCrossCheckTermVectorsOnClose(boolean value) {
        this.crossCheckTermVectorsOnClose = value;
    }

    public boolean getCrossCheckTermVectorsOnClose() {
        return this.crossCheckTermVectorsOnClose;
    }

    public void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        this.in.copy(to, src, dest, context);
    }
}

