/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.BytesRef;

class CrankyDocValuesFormat
extends DocValuesFormat {
    final DocValuesFormat delegate;
    final Random random;

    CrankyDocValuesFormat(DocValuesFormat delegate, Random random) {
        super(delegate.getName());
        this.delegate = delegate;
        this.random = random;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from DocValuesFormat.fieldsConsumer()");
        }
        return new CrankyDocValuesConsumer(this.delegate.fieldsConsumer(state), this.random);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return this.delegate.fieldsProducer(state);
    }

    static class CrankyDocValuesConsumer
    extends DocValuesConsumer {
        final DocValuesConsumer delegate;
        final Random random;

        CrankyDocValuesConsumer(DocValuesConsumer delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.close()");
            }
        }

        public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addNumericField()");
            }
            this.delegate.addNumericField(field, values);
        }

        public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addBinaryField()");
            }
            this.delegate.addBinaryField(field, values);
        }

        public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addSortedField()");
            }
            this.delegate.addSortedField(field, values, docToOrd);
        }

        public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addSortedNumericField()");
            }
            this.delegate.addSortedNumericField(field, docToValueCount, values);
        }

        public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addSortedSetField()");
            }
            this.delegate.addSortedSetField(field, values, docToOrdCount, ords);
        }
    }
}

