/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.BasicOperations;
import org.apache.lucene.util.automaton.RegExp;
import org.apache.lucene.util.automaton.SpecialOperations;
import org.apache.lucene.util.automaton.State;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.Util;

public class AutomatonTestUtil {
    public static String randomRegexp(Random r) {
        while (true) {
            String regexp;
            if (!UnicodeUtil.validUTF16String((CharSequence)(regexp = AutomatonTestUtil.randomRegexpString(r)))) {
                continue;
            }
            try {
                new RegExp(regexp, 0);
                return regexp;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static String randomRegexpString(Random r) {
        int end = r.nextInt(20);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        for (int i = 0; i < end; ++i) {
            int t = r.nextInt(15);
            if (0 == t && i < end - 1) {
                buffer[i++] = (char)TestUtil.nextInt(r, 55296, 56319);
                buffer[i] = (char)TestUtil.nextInt(r, 56320, 57343);
                continue;
            }
            if (t <= 1) {
                buffer[i] = (char)r.nextInt(128);
                continue;
            }
            if (2 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 128, 2048);
                continue;
            }
            if (3 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 2048, 55295);
                continue;
            }
            if (4 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 57344, 65535);
                continue;
            }
            if (5 == t) {
                buffer[i] = 46;
                continue;
            }
            if (6 == t) {
                buffer[i] = 63;
                continue;
            }
            if (7 == t) {
                buffer[i] = 42;
                continue;
            }
            if (8 == t) {
                buffer[i] = 43;
                continue;
            }
            if (9 == t) {
                buffer[i] = 40;
                continue;
            }
            if (10 == t) {
                buffer[i] = 41;
                continue;
            }
            if (11 == t) {
                buffer[i] = 45;
                continue;
            }
            if (12 == t) {
                buffer[i] = 91;
                continue;
            }
            if (13 == t) {
                buffer[i] = 93;
                continue;
            }
            if (14 != t) continue;
            buffer[i] = 124;
        }
        return new String(buffer, 0, end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getRandomCodePoint(Random r, Transition t) {
        int code;
        if (t.max < 55296 || t.min > 56319) {
            code = t.min + r.nextInt(t.max - t.min + 1);
        } else if (t.min >= 55296) {
            if (t.max <= 57343) throw new IllegalArgumentException("transition accepts only surrogates: " + t);
            code = 57344 + r.nextInt(t.max - 57343);
        } else if (t.max <= 57343) {
            if (t.min >= 55296) throw new IllegalArgumentException("transition accepts only surrogates: " + t);
            code = t.min + r.nextInt(55296 - t.min);
        } else {
            int gap1 = 55296 - t.min;
            int gap2 = t.max - 57343;
            int c = r.nextInt(gap1 + gap2);
            code = c < gap1 ? t.min + c : 57343 + c - gap1 + 1;
        }
        assert (code >= t.min && code <= t.max && (code < 55296 || code > 57343)) : "code=" + code + " min=" + t.min + " max=" + t.max;
        return code;
    }

    public static Automaton randomAutomaton(Random random) {
        Automaton a1 = new RegExp(AutomatonTestUtil.randomRegexp(random), 0).toAutomaton();
        if (random.nextBoolean()) {
            a1 = BasicOperations.complement((Automaton)a1);
        }
        Automaton a2 = new RegExp(AutomatonTestUtil.randomRegexp(random), 0).toAutomaton();
        if (random.nextBoolean()) {
            a2 = BasicOperations.complement((Automaton)a2);
        }
        switch (random.nextInt(4)) {
            case 0: {
                return BasicOperations.concatenate((Automaton)a1, (Automaton)a2);
            }
            case 1: {
                return BasicOperations.union((Automaton)a1, (Automaton)a2);
            }
            case 2: {
                return BasicOperations.intersection((Automaton)a1, (Automaton)a2);
            }
        }
        return BasicOperations.minus((Automaton)a1, (Automaton)a2);
    }

    public static void minimizeSimple(Automaton a) {
        if (a.isSingleton()) {
            return;
        }
        AutomatonTestUtil.determinizeSimple(a, SpecialOperations.reverse((Automaton)a));
        AutomatonTestUtil.determinizeSimple(a, SpecialOperations.reverse((Automaton)a));
    }

    public static void determinizeSimple(Automaton a) {
        if (a.deterministic || a.isSingleton()) {
            return;
        }
        HashSet<State> initialset = new HashSet<State>();
        initialset.add(a.initial);
        AutomatonTestUtil.determinizeSimple(a, initialset);
    }

    public static void determinizeSimple(Automaton a, Set<State> initialset) {
        int[] points = a.getStartPoints();
        HashMap<Set<Object>, Set<Object>> sets = new HashMap<Set<Object>, Set<Object>>();
        LinkedList<Set<Object>> worklist = new LinkedList<Set<Object>>();
        HashMap<Set<Object>, State> newstate = new HashMap<Set<Object>, State>();
        sets.put(initialset, initialset);
        worklist.add(initialset);
        a.initial = new State();
        newstate.put(initialset, a.initial);
        while (worklist.size() > 0) {
            Set s = (Set)worklist.removeFirst();
            State r = (State)newstate.get(s);
            for (State q : s) {
                if (!q.accept) continue;
                r.accept = true;
                break;
            }
            for (int n = 0; n < points.length; ++n) {
                HashSet<State> p = new HashSet<State>();
                for (State q : s) {
                    for (Transition t : q.getTransitions()) {
                        if (t.min > points[n] || points[n] > t.max) continue;
                        p.add(t.to);
                    }
                }
                if (!sets.containsKey(p)) {
                    sets.put(p, p);
                    worklist.add(p);
                    newstate.put(p, new State());
                }
                State q = (State)newstate.get(p);
                int min = points[n];
                int max = n + 1 < points.length ? points[n + 1] - 1 : 0x10FFFF;
                r.addTransition(new Transition(min, max, q));
            }
        }
        a.deterministic = true;
        a.clearNumberedStates();
        a.removeDeadTransitions();
    }

    public static Set<IntsRef> getFiniteStringsRecursive(Automaton a, int limit) {
        HashSet<IntsRef> strings = new HashSet<IntsRef>();
        if (a.isSingleton()) {
            if (limit > 0) {
                strings.add(Util.toUTF32((CharSequence)a.singleton, (IntsRef)new IntsRef()));
            }
        } else if (!AutomatonTestUtil.getFiniteStrings(a.initial, new HashSet<State>(), strings, new IntsRef(), limit)) {
            return strings;
        }
        return strings;
    }

    private static boolean getFiniteStrings(State s, HashSet<State> pathstates, HashSet<IntsRef> strings, IntsRef path, int limit) {
        pathstates.add(s);
        for (Transition t : s.getTransitions()) {
            if (pathstates.contains(t.to)) {
                return false;
            }
            for (int n = t.min; n <= t.max; ++n) {
                path.grow(path.length + 1);
                path.ints[path.length] = n;
                ++path.length;
                if (t.to.accept) {
                    strings.add(IntsRef.deepCopyOf((IntsRef)path));
                    if (limit >= 0 && strings.size() > limit) {
                        return false;
                    }
                }
                if (!AutomatonTestUtil.getFiniteStrings(t.to, pathstates, strings, path, limit)) {
                    return false;
                }
                --path.length;
            }
        }
        pathstates.remove(s);
        return true;
    }

    public static boolean isFiniteSlow(Automaton a) {
        if (a.isSingleton()) {
            return true;
        }
        return AutomatonTestUtil.isFiniteSlow(a.initial, new HashSet<State>());
    }

    private static boolean isFiniteSlow(State s, HashSet<State> path) {
        path.add(s);
        for (Transition t : s.getTransitions()) {
            if (!path.contains(t.to) && AutomatonTestUtil.isFiniteSlow(t.to, path)) continue;
            return false;
        }
        path.remove(s);
        return true;
    }

    public static void assertNoDetachedStates(Automaton a) {
        int numStates = a.getNumberOfStates();
        a.clearNumberedStates();
        assert (numStates == a.getNumberOfStates()) : "automaton has " + (numStates - a.getNumberOfStates()) + " detached states";
    }

    public static class RandomAcceptedStrings {
        private final Map<Transition, Boolean> leadsToAccept;
        private final Automaton a;

        public RandomAcceptedStrings(Automaton a) {
            this.a = a;
            if (a.isSingleton()) {
                this.leadsToAccept = null;
                return;
            }
            this.leadsToAccept = new IdentityHashMap<Transition, Boolean>();
            HashMap<State, ArrayList<ArrivingTransition>> allArriving = new HashMap<State, ArrayList<ArrivingTransition>>();
            LinkedList<State> q = new LinkedList<State>();
            HashSet<State> seen = new HashSet<State>();
            for (State s : a.getNumberedStates()) {
                for (int i = 0; i < s.numTransitions; ++i) {
                    Transition t = s.transitionsArray[i];
                    ArrayList<ArrivingTransition> tl = (ArrayList<ArrivingTransition>)allArriving.get(t.to);
                    if (tl == null) {
                        tl = new ArrayList<ArrivingTransition>();
                        allArriving.put(t.to, tl);
                    }
                    tl.add(new ArrivingTransition(s, t));
                }
                if (!s.accept) continue;
                q.add(s);
                seen.add(s);
            }
            while (!q.isEmpty()) {
                State s = (State)q.removeFirst();
                List arriving = (List)allArriving.get(s);
                if (arriving == null) continue;
                for (ArrivingTransition at : arriving) {
                    State from = at.from;
                    if (seen.contains(from)) continue;
                    q.add(from);
                    seen.add(from);
                    this.leadsToAccept.put(at.t, Boolean.TRUE);
                }
            }
        }

        public int[] getRandomAcceptedString(Random r) {
            ArrayList<Integer> soFar = new ArrayList<Integer>();
            if (this.a.isSingleton()) {
                int cp;
                String s = this.a.singleton;
                for (int charUpto = 0; charUpto < s.length(); charUpto += Character.charCount(cp)) {
                    cp = s.codePointAt(charUpto);
                    soFar.add(cp);
                }
            } else {
                State s = this.a.initial;
                while (!s.accept || s.numTransitions != 0 && !r.nextBoolean()) {
                    Transition t;
                    if (s.numTransitions == 0) {
                        throw new RuntimeException("this automaton has dead states");
                    }
                    boolean cheat = r.nextBoolean();
                    if (cheat) {
                        ArrayList<Transition> toAccept = new ArrayList<Transition>();
                        for (int i = 0; i < s.numTransitions; ++i) {
                            Transition t0 = s.transitionsArray[i];
                            if (!this.leadsToAccept.containsKey(t0)) continue;
                            toAccept.add(t0);
                        }
                        t = toAccept.size() == 0 ? s.transitionsArray[r.nextInt(s.numTransitions)] : (Transition)toAccept.get(r.nextInt(toAccept.size()));
                    } else {
                        t = s.transitionsArray[r.nextInt(s.numTransitions)];
                    }
                    soFar.add(AutomatonTestUtil.getRandomCodePoint(r, t));
                    s = t.to;
                }
            }
            return ArrayUtil.toIntArray(soFar);
        }

        private static class ArrivingTransition {
            final State from;
            final Transition t;

            public ArrivingTransition(State from, Transition t) {
                this.from = from;
                this.t = t;
            }
        }
    }
}

