/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NullInfoStream;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.Version;

public class RandomIndexWriter
implements Closeable {
    public IndexWriter w;
    private final Random r;
    int docCount;
    int flushAt;
    private double flushAtFactor = 1.0;
    private boolean getReaderCalled;
    private final Codec codec;
    private boolean doRandomForceMerge = true;
    private boolean doRandomForceMergeAssert = true;

    public static IndexWriter mockIndexWriter(Directory dir, IndexWriterConfig conf, Random r) throws IOException {
        final Random random = new Random(r.nextLong());
        return RandomIndexWriter.mockIndexWriter(dir, conf, new TestPoint(){

            @Override
            public void apply(String message) {
                if (random.nextInt(4) == 2) {
                    Thread.yield();
                }
            }
        });
    }

    public static IndexWriter mockIndexWriter(Directory dir, IndexWriterConfig conf, TestPoint testPoint) throws IOException {
        conf.setInfoStream((InfoStream)new TestPointInfoStream(conf.getInfoStream(), testPoint));
        return new IndexWriter(dir, conf);
    }

    public RandomIndexWriter(Random r, Directory dir) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, LuceneTestCase.TEST_VERSION_CURRENT, new MockAnalyzer(r)));
    }

    public RandomIndexWriter(Random r, Directory dir, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, LuceneTestCase.TEST_VERSION_CURRENT, a));
    }

    public RandomIndexWriter(Random r, Directory dir, Version v, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, v, a));
    }

    public RandomIndexWriter(Random r, Directory dir, IndexWriterConfig c) throws IOException {
        this.r = new Random(r.nextLong());
        this.w = RandomIndexWriter.mockIndexWriter(dir, c, r);
        this.flushAt = TestUtil.nextInt(r, 10, 1000);
        this.codec = this.w.getConfig().getCodec();
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW dir=" + dir + " config=" + this.w.getConfig());
            System.out.println("codec default=" + this.codec.getName());
        }
        this.doRandomForceMerge = !(c.getMergePolicy() instanceof NoMergePolicy) && r.nextBoolean();
    }

    public <T extends IndexableField> void addDocument(Iterable<T> doc) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.addDocument(doc, this.w.getAnalyzer());
    }

    public <T extends IndexableField> void addDocument(final Iterable<T> doc, Analyzer a) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        if (this.r.nextInt(5) == 3) {
            this.w.addDocuments(new Iterable<Iterable<T>>(){

                @Override
                public Iterator<Iterable<T>> iterator() {
                    return new Iterator<Iterable<T>>(){
                        boolean done;

                        @Override
                        public boolean hasNext() {
                            return !this.done;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Iterable<T> next() {
                            if (this.done) {
                                throw new IllegalStateException();
                            }
                            this.done = true;
                            return doc;
                        }
                    };
                }
            }, a);
        } else {
            this.w.addDocument(doc, a);
        }
        this.maybeCommit();
    }

    private void maybeCommit() throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        if (this.docCount++ == this.flushAt) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("RIW.add/updateDocument: now doing a commit at docCount=" + this.docCount);
            }
            this.w.commit();
            this.flushAt += TestUtil.nextInt(this.r, (int)(this.flushAtFactor * 10.0), (int)(this.flushAtFactor * 1000.0));
            if (this.flushAtFactor < 2000000.0) {
                this.flushAtFactor *= 1.05;
            }
        }
    }

    public void addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.addDocuments(docs);
        this.maybeCommit();
    }

    public void updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.updateDocuments(delTerm, docs);
        this.maybeCommit();
    }

    public <T extends IndexableField> void updateDocument(Term t, final Iterable<T> doc) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        if (this.r.nextInt(5) == 3) {
            this.w.updateDocuments(t, new Iterable<Iterable<T>>(){

                @Override
                public Iterator<Iterable<T>> iterator() {
                    return new Iterator<Iterable<T>>(){
                        boolean done;

                        @Override
                        public boolean hasNext() {
                            return !this.done;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Iterable<T> next() {
                            if (this.done) {
                                throw new IllegalStateException();
                            }
                            this.done = true;
                            return doc;
                        }
                    };
                }
            });
        } else {
            this.w.updateDocument(t, doc);
        }
        this.maybeCommit();
    }

    public void addIndexes(Directory ... dirs) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.addIndexes(dirs);
    }

    public void addIndexes(IndexReader ... readers) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.addIndexes(readers);
    }

    public void updateNumericDocValue(Term term, String field, Long value) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.updateNumericDocValue(term, field, value);
    }

    public void updateBinaryDocValue(Term term, String field, BytesRef value) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.updateBinaryDocValue(term, field, value);
    }

    public void deleteDocuments(Term term) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.deleteDocuments(term);
    }

    public void deleteDocuments(Query q) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.deleteDocuments(q);
    }

    public void commit() throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.commit();
    }

    public int numDocs() {
        return this.w.numDocs();
    }

    public int maxDoc() {
        return this.w.maxDoc();
    }

    public void deleteAll() throws IOException {
        this.w.deleteAll();
    }

    public DirectoryReader getReader() throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        return this.getReader(true);
    }

    public void forceMergeDeletes(boolean doWait) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.forceMergeDeletes(doWait);
    }

    public void forceMergeDeletes() throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.forceMergeDeletes();
    }

    public void setDoRandomForceMerge(boolean v) {
        this.doRandomForceMerge = v;
    }

    public void setDoRandomForceMergeAssert(boolean v) {
        this.doRandomForceMergeAssert = v;
    }

    private void doRandomForceMerge() throws IOException {
        if (this.doRandomForceMerge) {
            int segCount = this.w.getSegmentCount();
            if (this.r.nextBoolean() || segCount == 0) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("RIW: doRandomForceMerge(1)");
                }
                this.w.forceMerge(1);
            } else {
                int limit = TestUtil.nextInt(this.r, 1, segCount);
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("RIW: doRandomForceMerge(" + limit + ")");
                }
                this.w.forceMerge(limit);
                assert (!this.doRandomForceMergeAssert || this.w.getSegmentCount() <= limit) : "limit=" + limit + " actual=" + this.w.getSegmentCount();
            }
        }
    }

    public DirectoryReader getReader(boolean applyDeletions) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.getReaderCalled = true;
        if (this.r.nextInt(20) == 2) {
            this.doRandomForceMerge();
        }
        if (!applyDeletions || !this.codec.getName().equals("Lucene3x") && this.r.nextBoolean()) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("RIW.getReader: use NRT reader");
            }
            if (this.r.nextInt(5) == 1) {
                this.w.commit();
            }
            return this.w.getReader(applyDeletions);
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW.getReader: open new reader");
        }
        this.w.commit();
        if (this.r.nextBoolean()) {
            return DirectoryReader.open((Directory)this.w.getDirectory(), (int)TestUtil.nextInt(this.r, 1, 10));
        }
        return this.w.getReader(applyDeletions);
    }

    @Override
    public void close() throws IOException {
        if (!this.w.isClosed()) {
            LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        }
        if (!this.getReaderCalled && this.r.nextInt(8) == 2) {
            this.doRandomForceMerge();
        }
        this.w.close();
    }

    public void forceMerge(int maxSegmentCount) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.forceMerge(maxSegmentCount);
    }

    public static interface TestPoint {
        public void apply(String var1);
    }

    static final class TestPointInfoStream
    extends InfoStream {
        private final InfoStream delegate;
        private final TestPoint testPoint;

        public TestPointInfoStream(InfoStream delegate, TestPoint testPoint) {
            this.delegate = delegate == null ? new NullInfoStream() : delegate;
            this.testPoint = testPoint;
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void message(String component, String message) {
            if ("TP".equals(component)) {
                this.testPoint.apply(message);
            }
            if (this.delegate.isEnabled(component)) {
                this.delegate.message(component, message);
            }
        }

        public boolean isEnabled(String component) {
            return "TP".equals(component) || this.delegate.isEnabled(component);
        }
    }
}

