/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.util.TestUtil;

public class MockRandomMergePolicy
extends MergePolicy {
    private final Random random;

    public MockRandomMergePolicy(Random random) {
        this.random = new Random(random.nextLong());
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos) {
        MergePolicy.MergeSpecification mergeSpec = null;
        int numSegments = segmentInfos.size();
        ArrayList<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
        Collection merging = ((IndexWriter)this.writer.get()).getMergingSegments();
        for (SegmentCommitInfo sipc : segmentInfos) {
            if (merging.contains(sipc)) continue;
            segments.add(sipc);
        }
        numSegments = segments.size();
        if (numSegments > 1 && (numSegments > 30 || this.random.nextInt(5) == 3)) {
            Collections.shuffle(segments, this.random);
            mergeSpec = new MergePolicy.MergeSpecification();
            int segsToMerge = TestUtil.nextInt(this.random, 1, numSegments);
            mergeSpec.add(new MergePolicy.OneMerge(segments.subList(0, segsToMerge)));
        }
        return mergeSpec;
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge) throws IOException {
        ArrayList<SegmentCommitInfo> eligibleSegments = new ArrayList<SegmentCommitInfo>();
        for (SegmentCommitInfo info : segmentInfos) {
            if (!segmentsToMerge.containsKey(info)) continue;
            eligibleSegments.add(info);
        }
        MergePolicy.MergeSpecification mergeSpec = null;
        if (eligibleSegments.size() > 1 || eligibleSegments.size() == 1 && ((SegmentCommitInfo)eligibleSegments.get(0)).hasDeletions()) {
            int inc;
            mergeSpec = new MergePolicy.MergeSpecification();
            Collections.shuffle(eligibleSegments, this.random);
            for (int upto = 0; upto < eligibleSegments.size(); upto += inc) {
                int max = Math.min(10, eligibleSegments.size() - upto);
                inc = max <= 2 ? max : TestUtil.nextInt(this.random, 2, max);
                mergeSpec.add(new MergePolicy.OneMerge(eligibleSegments.subList(upto, upto + inc)));
            }
        }
        if (mergeSpec != null) {
            for (MergePolicy.OneMerge merge : mergeSpec.merges) {
                for (SegmentCommitInfo info : merge.segments) {
                    assert (segmentsToMerge.containsKey(info));
                }
            }
        }
        return mergeSpec;
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos) throws IOException {
        return this.findMerges(null, segmentInfos);
    }

    public void close() {
    }

    public boolean useCompoundFile(SegmentInfos infos, SegmentCommitInfo mergedInfo) throws IOException {
        return this.random.nextInt(5) != 1;
    }
}

