/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockFixedLengthPayloadFilter;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.MockVariableLengthPayloadFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public final class MockAnalyzer
extends Analyzer {
    private final CharacterRunAutomaton runAutomaton;
    private final boolean lowerCase;
    private final CharacterRunAutomaton filter;
    private int positionIncrementGap;
    private final Random random;
    private Map<String, Integer> previousMappings = new HashMap<String, Integer>();
    private boolean enableChecks = true;
    private int maxTokenLength = Integer.MAX_VALUE;

    public MockAnalyzer(Random random, CharacterRunAutomaton runAutomaton, boolean lowerCase, CharacterRunAutomaton filter) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.random = new Random(random.nextLong());
        this.runAutomaton = runAutomaton;
        this.lowerCase = lowerCase;
        this.filter = filter;
    }

    public MockAnalyzer(Random random, CharacterRunAutomaton runAutomaton, boolean lowerCase) {
        this(random, runAutomaton, lowerCase, MockTokenFilter.EMPTY_STOPSET);
    }

    public MockAnalyzer(Random random) {
        this(random, MockTokenizer.WHITESPACE, true);
    }

    public Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        MockTokenizer tokenizer = new MockTokenizer(reader, this.runAutomaton, this.lowerCase, this.maxTokenLength);
        tokenizer.setEnableChecks(this.enableChecks);
        MockTokenFilter filt = new MockTokenFilter((TokenStream)tokenizer, this.filter);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)this.maybePayload(filt, fieldName));
    }

    private synchronized TokenFilter maybePayload(TokenFilter stream, String fieldName) {
        Integer val = this.previousMappings.get(fieldName);
        if (val == null) {
            val = -1;
            if (LuceneTestCase.rarely(this.random)) {
                switch (this.random.nextInt(3)) {
                    case 0: {
                        val = -1;
                        break;
                    }
                    case 1: {
                        val = Integer.MAX_VALUE;
                        break;
                    }
                    case 2: {
                        val = this.random.nextInt(12);
                    }
                }
            }
            if (LuceneTestCase.VERBOSE) {
                if (val == Integer.MAX_VALUE) {
                    System.out.println("MockAnalyzer: field=" + fieldName + " gets variable length payloads");
                } else if (val != -1) {
                    System.out.println("MockAnalyzer: field=" + fieldName + " gets fixed length=" + val + " payloads");
                }
            }
            this.previousMappings.put(fieldName, val);
        }
        if (val == -1) {
            return stream;
        }
        if (val == Integer.MAX_VALUE) {
            return new MockVariableLengthPayloadFilter(this.random, (TokenStream)stream);
        }
        return new MockFixedLengthPayloadFilter(this.random, (TokenStream)stream, val);
    }

    public void setPositionIncrementGap(int positionIncrementGap) {
        this.positionIncrementGap = positionIncrementGap;
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.positionIncrementGap;
    }

    public void setEnableChecks(boolean enableChecks) {
        this.enableChecks = enableChecks;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }
}

