/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoDeletionPolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MockIndexInputWrapper;
import org.apache.lucene.store.MockIndexOutputWrapper;
import org.apache.lucene.store.MockLockFactoryWrapper;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RateLimitedDirectoryWrapper;
import org.apache.lucene.store.SlowClosingMockIndexInputWrapper;
import org.apache.lucene.store.SlowOpeningMockIndexInputWrapper;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.ThrottledIndexOutput;
import org.apache.lucene.util._TestUtil;

public class MockDirectoryWrapper
extends BaseDirectoryWrapper {
    long maxSize;
    long maxUsedSize;
    double randomIOExceptionRate;
    double randomIOExceptionRateOnOpen;
    Random randomState;
    boolean noDeleteOpenFile = true;
    boolean preventDoubleWrite = true;
    boolean trackDiskUsage = false;
    boolean wrapLockFactory = true;
    private Set<String> unSyncedFiles;
    private Set<String> createdFiles;
    private Set<String> openFilesForWrite = new HashSet<String>();
    Set<String> openLocks = Collections.synchronizedSet(new HashSet());
    volatile boolean crashed;
    private ThrottledIndexOutput throttledOutput;
    private Throttling throttling = Throttling.SOMETIMES;
    final AtomicInteger inputCloneCount = new AtomicInteger();
    private Map<Closeable, Exception> openFileHandles = Collections.synchronizedMap(new IdentityHashMap());
    private Map<String, Integer> openFiles;
    private Set<String> openFilesDeleted;
    private boolean failOnCreateOutput = true;
    private boolean failOnOpenInput = true;
    private boolean assertNoUnreferencedFilesOnClose = true;
    ArrayList<Failure> failures;

    private synchronized void init() {
        if (this.openFiles == null) {
            this.openFiles = new HashMap<String, Integer>();
            this.openFilesDeleted = new HashSet<String>();
        }
        if (this.createdFiles == null) {
            this.createdFiles = new HashSet<String>();
        }
        if (this.unSyncedFiles == null) {
            this.unSyncedFiles = new HashSet<String>();
        }
    }

    public MockDirectoryWrapper(Random random, Directory delegate) {
        super(delegate);
        this.randomState = new Random(random.nextInt());
        this.throttledOutput = new ThrottledIndexOutput(ThrottledIndexOutput.mBitsToBytes(40 + this.randomState.nextInt(10)), 5 + this.randomState.nextInt(5), null);
        this.lockFactory = new MockLockFactoryWrapper(this, delegate.getLockFactory());
        this.init();
    }

    public Directory getDelegate() {
        return this.delegate;
    }

    public int getInputCloneCount() {
        return this.inputCloneCount.get();
    }

    public void setTrackDiskUsage(boolean v) {
        this.trackDiskUsage = v;
    }

    public void setPreventDoubleWrite(boolean value) {
        this.preventDoubleWrite = value;
    }

    public void setThrottling(Throttling throttling) {
        this.throttling = throttling;
    }

    private boolean mustSync() {
        Directory delegate = this.delegate;
        while (true) {
            if (delegate instanceof RateLimitedDirectoryWrapper) {
                delegate = ((RateLimitedDirectoryWrapper)delegate).getDelegate();
                continue;
            }
            if (!(delegate instanceof TrackingDirectoryWrapper)) break;
            delegate = ((TrackingDirectoryWrapper)delegate).getDelegate();
        }
        return delegate instanceof NRTCachingDirectory;
    }

    @Override
    public synchronized void sync(Collection<String> names) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed) {
            throw new IOException("cannot sync after crash");
        }
        if (LuceneTestCase.rarely(this.randomState) || this.mustSync()) {
            for (String name : names) {
                this.maybeThrowIOException(name);
                this.delegate.sync(Collections.singleton(name));
                this.unSyncedFiles.remove(name);
            }
        } else {
            this.unSyncedFiles.removeAll(names);
        }
    }

    @Override
    public String toString() {
        return "MockDirWrapper(" + this.delegate + ")";
    }

    public final synchronized long sizeInBytes() throws IOException {
        if (this.delegate instanceof RAMDirectory) {
            return ((RAMDirectory)this.delegate).sizeInBytes();
        }
        long size = 0L;
        for (String file : this.delegate.listAll()) {
            size += this.delegate.fileLength(file);
        }
        return size;
    }

    public synchronized void crash() throws IOException {
        this.crashed = true;
        this.openFiles = new HashMap<String, Integer>();
        this.openFilesForWrite = new HashSet<String>();
        this.openFilesDeleted = new HashSet<String>();
        Iterator<String> it = this.unSyncedFiles.iterator();
        this.unSyncedFiles = new HashSet<String>();
        IdentityHashMap<Closeable, Exception> m = new IdentityHashMap<Closeable, Exception>(this.openFileHandles);
        for (Closeable f : m.keySet()) {
            try {
                f.close();
            }
            catch (Exception ignored) {}
        }
        while (it.hasNext()) {
            String name = it.next();
            int damage = this.randomState.nextInt(5);
            String action = null;
            if (damage == 0) {
                action = "deleted";
                this.deleteFile(name, true);
            } else if (damage == 1) {
                int limit;
                action = "zeroed";
                long length = this.fileLength(name);
                byte[] zeroes = new byte[256];
                IndexOutput out = this.delegate.createOutput(name, LuceneTestCase.newIOContext(this.randomState));
                for (long upto = 0L; upto < length; upto += (long)limit) {
                    limit = (int)Math.min(length - upto, (long)zeroes.length);
                    out.writeBytes(zeroes, 0, limit);
                }
                out.close();
            } else if (damage == 2) {
                String tempFileName;
                action = "partially truncated";
                while (this.delegate.fileExists(tempFileName = "" + this.randomState.nextInt())) {
                }
                IndexOutput tempOut = this.delegate.createOutput(tempFileName, LuceneTestCase.newIOContext(this.randomState));
                IndexInput ii = this.delegate.openInput(name, LuceneTestCase.newIOContext(this.randomState));
                tempOut.copyBytes((DataInput)ii, ii.length() / 2L);
                tempOut.close();
                ii.close();
                this.deleteFile(name, true);
                IndexOutput out = this.delegate.createOutput(name, LuceneTestCase.newIOContext(this.randomState));
                ii = this.delegate.openInput(tempFileName, LuceneTestCase.newIOContext(this.randomState));
                out.copyBytes((DataInput)ii, ii.length());
                out.close();
                ii.close();
                this.deleteFile(tempFileName, true);
            } else if (damage == 3) {
                action = "didn't change";
            } else {
                action = "fully truncated";
                this.deleteFile(name, true);
                IndexOutput out = this.delegate.createOutput(name, LuceneTestCase.newIOContext(this.randomState));
                out.setLength(0L);
                out.close();
            }
            if (!LuceneTestCase.VERBOSE) continue;
            System.out.println("MockDirectoryWrapper: " + action + " unsynced file: " + name);
        }
    }

    public synchronized void clearCrash() {
        this.crashed = false;
        this.openLocks.clear();
    }

    public void setMaxSizeInBytes(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getMaxSizeInBytes() {
        return this.maxSize;
    }

    public long getMaxUsedSizeInBytes() {
        return this.maxUsedSize;
    }

    public void resetMaxUsedSizeInBytes() throws IOException {
        this.maxUsedSize = this.getRecomputedActualSizeInBytes();
    }

    public void setNoDeleteOpenFile(boolean value) {
        this.noDeleteOpenFile = value;
    }

    public boolean getNoDeleteOpenFile() {
        return this.noDeleteOpenFile;
    }

    public void setRandomIOExceptionRate(double rate) {
        this.randomIOExceptionRate = rate;
    }

    public double getRandomIOExceptionRate() {
        return this.randomIOExceptionRate;
    }

    public void setRandomIOExceptionRateOnOpen(double rate) {
        this.randomIOExceptionRateOnOpen = rate;
    }

    public double getRandomIOExceptionRateOnOpen() {
        return this.randomIOExceptionRateOnOpen;
    }

    void maybeThrowIOException(String message) throws IOException {
        if (this.randomState.nextDouble() < this.randomIOExceptionRate) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": MockDirectoryWrapper: now throw random exception" + (message == null ? "" : " (" + message + ")"));
                new Throwable().printStackTrace(System.out);
            }
            throw new IOException("a random IOException" + (message == null ? "" : " (" + message + ")"));
        }
    }

    void maybeThrowIOExceptionOnOpen(String name) throws IOException {
        if (this.randomState.nextDouble() < this.randomIOExceptionRateOnOpen) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": MockDirectoryWrapper: now throw random exception during open file=" + name);
                new Throwable().printStackTrace(System.out);
            }
            if (this.randomState.nextBoolean()) {
                throw new IOException("a random IOException (" + name + ")");
            }
            throw new FileNotFoundException("a random IOException (" + name + ")");
        }
    }

    @Override
    public synchronized void deleteFile(String name) throws IOException {
        this.maybeYield();
        this.deleteFile(name, false);
    }

    private synchronized IOException fillOpenTrace(IOException ioe, String name, boolean input) {
        for (Map.Entry<Closeable, Exception> ent : this.openFileHandles.entrySet()) {
            if (input && ent.getKey() instanceof MockIndexInputWrapper && ((MockIndexInputWrapper)((Object)ent.getKey())).name.equals(name)) {
                ioe.initCause(ent.getValue());
                break;
            }
            if (input || !(ent.getKey() instanceof MockIndexOutputWrapper) || !((MockIndexOutputWrapper)((Object)ent.getKey())).name.equals(name)) continue;
            ioe.initCause(ent.getValue());
            break;
        }
        return ioe;
    }

    private void maybeYield() {
        if (this.randomState.nextBoolean()) {
            Thread.yield();
        }
    }

    private synchronized void deleteFile(String name, boolean forced) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed && !forced) {
            throw new IOException("cannot delete after crash");
        }
        if (this.unSyncedFiles.contains(name)) {
            this.unSyncedFiles.remove(name);
        }
        if (!forced && this.noDeleteOpenFile) {
            if (this.openFiles.containsKey(name)) {
                this.openFilesDeleted.add(name);
                throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open: cannot delete"), name, true);
            }
            this.openFilesDeleted.remove(name);
        }
        this.delegate.deleteFile(name);
    }

    public synchronized Set<String> getOpenDeletedFiles() {
        return new HashSet<String>(this.openFilesDeleted);
    }

    public void setFailOnCreateOutput(boolean v) {
        this.failOnCreateOutput = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.maybeThrowDeterministicException();
        this.maybeThrowIOExceptionOnOpen(name);
        this.maybeYield();
        if (this.failOnCreateOutput) {
            this.maybeThrowDeterministicException();
        }
        if (this.crashed) {
            throw new IOException("cannot createOutput after crash");
        }
        this.init();
        MockDirectoryWrapper mockDirectoryWrapper = this;
        synchronized (mockDirectoryWrapper) {
            if (this.preventDoubleWrite && this.createdFiles.contains(name) && !name.equals("segments.gen")) {
                throw new IOException("file \"" + name + "\" was already written to");
            }
        }
        if (this.noDeleteOpenFile && this.openFiles.containsKey(name)) {
            throw new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open: cannot overwrite");
        }
        if (this.crashed) {
            throw new IOException("cannot createOutput after crash");
        }
        this.unSyncedFiles.add(name);
        this.createdFiles.add(name);
        if (this.delegate instanceof RAMDirectory) {
            RAMDirectory ramdir = (RAMDirectory)this.delegate;
            RAMFile file = new RAMFile(ramdir);
            RAMFile existing = (RAMFile)ramdir.fileMap.get(name);
            if (existing != null && !name.equals("segments.gen") && this.preventDoubleWrite) {
                throw new IOException("file " + name + " already exists");
            }
            if (existing != null) {
                ramdir.sizeInBytes.getAndAdd(-existing.sizeInBytes);
                existing.directory = null;
            }
            ramdir.fileMap.put(name, file);
        }
        Object delegateOutput = this.delegate.createOutput(name, LuceneTestCase.newIOContext(this.randomState, context));
        if (this.randomState.nextInt(10) == 0) {
            delegateOutput = new BufferedIndexOutputWrapper(1 + this.randomState.nextInt(16384), (IndexOutput)delegateOutput);
        }
        MockIndexOutputWrapper io = new MockIndexOutputWrapper(this, (IndexOutput)delegateOutput, name);
        this.addFileHandle((Closeable)((Object)io), name, Handle.Output);
        this.openFilesForWrite.add(name);
        if (this.throttling == Throttling.ALWAYS || this.throttling == Throttling.SOMETIMES && this.randomState.nextInt(50) == 0 && !(this.delegate instanceof RateLimitedDirectoryWrapper)) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockDirectoryWrapper: throttling indexOutput (" + name + ")");
            }
            return this.throttledOutput.newFromDelegate(io);
        }
        return io;
    }

    synchronized void addFileHandle(Closeable c, String name, Handle handle) {
        Integer v = this.openFiles.get(name);
        if (v != null) {
            v = v + 1;
            this.openFiles.put(name, v);
        } else {
            this.openFiles.put(name, 1);
        }
        this.openFileHandles.put(c, new RuntimeException("unclosed Index" + handle.name() + ": " + name));
    }

    public void setFailOnOpenInput(boolean v) {
        this.failOnOpenInput = v;
    }

    @Override
    public synchronized IndexInput openInput(String name, IOContext context) throws IOException {
        MockIndexInputWrapper ii;
        this.maybeThrowDeterministicException();
        this.maybeThrowIOExceptionOnOpen(name);
        this.maybeYield();
        if (this.failOnOpenInput) {
            this.maybeThrowDeterministicException();
        }
        if (!this.delegate.fileExists(name)) {
            throw new FileNotFoundException(name + " in dir=" + this.delegate);
        }
        if (this.openFilesForWrite.contains(name) && !name.startsWith("segments")) {
            throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open for writing"), name, false);
        }
        IndexInput delegateInput = this.delegate.openInput(name, LuceneTestCase.newIOContext(this.randomState, context));
        int randomInt = this.randomState.nextInt(500);
        if (randomInt == 0) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockDirectoryWrapper: using SlowClosingMockIndexInputWrapper for file " + name);
            }
            ii = new SlowClosingMockIndexInputWrapper(this, name, delegateInput);
        } else if (randomInt == 1) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockDirectoryWrapper: using SlowOpeningMockIndexInputWrapper for file " + name);
            }
            ii = new SlowOpeningMockIndexInputWrapper(this, name, delegateInput);
        } else {
            ii = new MockIndexInputWrapper(this, name, delegateInput);
        }
        this.addFileHandle((Closeable)((Object)ii), name, Handle.Input);
        return ii;
    }

    public final synchronized long getRecomputedSizeInBytes() throws IOException {
        if (!(this.delegate instanceof RAMDirectory)) {
            return this.sizeInBytes();
        }
        long size = 0L;
        for (RAMFile file : ((RAMDirectory)this.delegate).fileMap.values()) {
            size += file.getSizeInBytes();
        }
        return size;
    }

    public final synchronized long getRecomputedActualSizeInBytes() throws IOException {
        if (!(this.delegate instanceof RAMDirectory)) {
            return this.sizeInBytes();
        }
        long size = 0L;
        for (RAMFile file : ((RAMDirectory)this.delegate).fileMap.values()) {
            size += file.length;
        }
        return size;
    }

    public void setAssertNoUnrefencedFilesOnClose(boolean v) {
        this.assertNoUnreferencedFilesOnClose = v;
    }

    public void setWrapLockFactory(boolean v) {
        this.wrapLockFactory = v;
    }

    @Override
    public synchronized void close() throws IOException {
        HashSet<String> pendingDeletions = new HashSet<String>(this.openFilesDeleted);
        this.maybeYield();
        if (this.openFiles == null) {
            this.openFiles = new HashMap<String, Integer>();
            this.openFilesDeleted = new HashSet<String>();
        }
        if (this.noDeleteOpenFile && this.openFiles.size() > 0) {
            Exception cause = null;
            Iterator<Exception> stacktraces = this.openFileHandles.values().iterator();
            if (stacktraces.hasNext()) {
                cause = stacktraces.next();
            }
            throw new RuntimeException("MockDirectoryWrapper: cannot close: there are still open files: " + this.openFiles, cause);
        }
        if (this.noDeleteOpenFile && this.openLocks.size() > 0) {
            throw new RuntimeException("MockDirectoryWrapper: cannot close: there are still open locks: " + this.openLocks);
        }
        this.isOpen = false;
        if (this.getCheckIndexOnClose()) {
            this.randomIOExceptionRate = 0.0;
            this.randomIOExceptionRateOnOpen = 0.0;
            if (DirectoryReader.indexExists((Directory)this)) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("\nNOTE: MockDirectoryWrapper: now crash");
                }
                this.crash();
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("\nNOTE: MockDirectoryWrapper: now run CheckIndex");
                }
                _TestUtil.checkIndex(this, this.getCrossCheckTermVectorsOnClose());
                if (this.assertNoUnreferencedFilesOnClose) {
                    HashSet<String> allFiles = new HashSet<String>(Arrays.asList(this.listAll()));
                    allFiles.removeAll(pendingDeletions);
                    Object[] startFiles = allFiles.toArray(new String[0]);
                    IndexWriterConfig iwc = new IndexWriterConfig(LuceneTestCase.TEST_VERSION_CURRENT, null);
                    iwc.setIndexDeletionPolicy(NoDeletionPolicy.INSTANCE);
                    new IndexWriter(this.delegate, iwc).rollback();
                    Object[] endFiles = this.delegate.listAll();
                    TreeSet<String> startSet = new TreeSet<String>(Arrays.asList(startFiles));
                    TreeSet<String> endSet = new TreeSet<String>(Arrays.asList(endFiles));
                    if (pendingDeletions.contains("segments.gen") && endSet.contains("segments.gen")) {
                        startSet.add("segments.gen");
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("MDW: Unreferenced check: Ignoring segments.gen that we could not delete.");
                        }
                    }
                    for (String file : pendingDeletions) {
                        if (!file.startsWith("segments") || file.equals("segments.gen") || !endSet.contains(file)) continue;
                        startSet.add(file);
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("MDW: Unreferenced check: Ignoring segments file: " + file + " that we could not delete.");
                        }
                        SegmentInfos sis = new SegmentInfos();
                        try {
                            sis.read(this.delegate, file);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        try {
                            HashSet ghosts = new HashSet(sis.files(this.delegate, false));
                            for (String s : ghosts) {
                                if (!endSet.contains(s) || startSet.contains(s)) continue;
                                assert (pendingDeletions.contains(s));
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println("MDW: Unreferenced check: Ignoring referenced file: " + s + " " + "from " + file + " that we could not delete.");
                                }
                                startSet.add(s);
                            }
                        }
                        catch (Throwable t) {
                            System.err.println("ERROR processing leftover segments file " + file + ":");
                            t.printStackTrace();
                        }
                    }
                    startFiles = startSet.toArray(new String[0]);
                    if (!Arrays.equals(startFiles, endFiles = endSet.toArray(new String[0]))) {
                        ArrayList<Object> removed = new ArrayList<Object>();
                        for (Object fileName : startFiles) {
                            if (endSet.contains(fileName)) continue;
                            removed.add(fileName);
                        }
                        ArrayList<Object> added = new ArrayList<Object>();
                        for (Object fileName : endFiles) {
                            if (startSet.contains(fileName)) continue;
                            added.add(fileName);
                        }
                        String extras = removed.size() != 0 ? "\n\nThese files were removed: " + removed : "";
                        if (added.size() != 0) {
                            extras = extras + "\n\nThese files were added (waaaaaaaaaat!): " + added;
                        }
                        if (pendingDeletions.size() != 0) {
                            extras = extras + "\n\nThese files we had previously tried to delete, but couldn't: " + pendingDeletions;
                        }
                        assert (false) : "unreferenced files: before delete:\n    " + Arrays.toString(startFiles) + "\n  after delete:\n    " + Arrays.toString(endFiles) + extras;
                    }
                    DirectoryReader ir1 = DirectoryReader.open((Directory)this);
                    int numDocs1 = ir1.numDocs();
                    ir1.close();
                    new IndexWriter((Directory)this, new IndexWriterConfig(LuceneTestCase.TEST_VERSION_CURRENT, null)).close();
                    DirectoryReader ir2 = DirectoryReader.open((Directory)this);
                    int numDocs2 = ir2.numDocs();
                    ir2.close();
                    assert (numDocs1 == numDocs2) : "numDocs changed after opening/closing IW: before=" + numDocs1 + " after=" + numDocs2;
                }
            }
        }
        this.delegate.close();
    }

    synchronized void removeOpenFile(Closeable c, String name) {
        Integer v = this.openFiles.get(name);
        if (v != null) {
            if (v == 1) {
                this.openFiles.remove(name);
            } else {
                v = v - 1;
                this.openFiles.put(name, v);
            }
        }
        this.openFileHandles.remove(c);
    }

    public synchronized void removeIndexOutput(IndexOutput out, String name) {
        this.openFilesForWrite.remove(name);
        this.removeOpenFile((Closeable)out, name);
    }

    public synchronized void removeIndexInput(IndexInput in, String name) {
        this.removeOpenFile((Closeable)in, name);
    }

    public synchronized void failOn(Failure fail) {
        if (this.failures == null) {
            this.failures = new ArrayList();
        }
        this.failures.add(fail);
    }

    synchronized void maybeThrowDeterministicException() throws IOException {
        if (this.failures != null) {
            for (int i = 0; i < this.failures.size(); ++i) {
                this.failures.get(i).eval(this);
            }
        }
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        this.maybeYield();
        return this.delegate.listAll();
    }

    @Override
    public synchronized boolean fileExists(String name) throws IOException {
        this.maybeYield();
        return this.delegate.fileExists(name);
    }

    @Override
    public synchronized long fileLength(String name) throws IOException {
        this.maybeYield();
        return this.delegate.fileLength(name);
    }

    @Override
    public synchronized Lock makeLock(String name) {
        this.maybeYield();
        return this.getLockFactory().makeLock(name);
    }

    @Override
    public synchronized void clearLock(String name) throws IOException {
        this.maybeYield();
        this.getLockFactory().clearLock(name);
    }

    @Override
    public synchronized void setLockFactory(LockFactory lockFactory) throws IOException {
        this.maybeYield();
        this.delegate.setLockFactory(lockFactory);
        this.lockFactory = new MockLockFactoryWrapper(this, lockFactory);
    }

    @Override
    public synchronized LockFactory getLockFactory() {
        this.maybeYield();
        if (this.wrapLockFactory) {
            return this.lockFactory;
        }
        return this.delegate.getLockFactory();
    }

    @Override
    public synchronized String getLockID() {
        this.maybeYield();
        return this.delegate.getLockID();
    }

    @Override
    public synchronized void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        this.maybeYield();
        this.delegate.copy(to, src, dest, context);
    }

    @Override
    public Directory.IndexInputSlicer createSlicer(final String name, IOContext context) throws IOException {
        this.maybeYield();
        if (!this.delegate.fileExists(name)) {
            throw new FileNotFoundException(name);
        }
        if (this.openFilesForWrite.contains(name) && !name.startsWith("segments")) {
            throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open for writing"), name, false);
        }
        final Directory.IndexInputSlicer delegateHandle = this.delegate.createSlicer(name, context);
        Directory.IndexInputSlicer handle = new Directory.IndexInputSlicer(){
            private boolean isClosed;

            public void close() throws IOException {
                if (!this.isClosed) {
                    delegateHandle.close();
                    MockDirectoryWrapper.this.removeOpenFile((Closeable)((Object)this), name);
                    this.isClosed = true;
                }
            }

            public IndexInput openSlice(String sliceDescription, long offset, long length) throws IOException {
                MockDirectoryWrapper.this.maybeYield();
                MockIndexInputWrapper ii = new MockIndexInputWrapper(MockDirectoryWrapper.this, name, delegateHandle.openSlice(sliceDescription, offset, length));
                MockDirectoryWrapper.this.addFileHandle((Closeable)((Object)ii), name, Handle.Input);
                return ii;
            }

            public IndexInput openFullSlice() throws IOException {
                MockDirectoryWrapper.this.maybeYield();
                MockIndexInputWrapper ii = new MockIndexInputWrapper(MockDirectoryWrapper.this, name, delegateHandle.openFullSlice());
                MockDirectoryWrapper.this.addFileHandle((Closeable)((Object)ii), name, Handle.Input);
                return ii;
            }
        };
        this.addFileHandle((Closeable)handle, name, Handle.Slice);
        return handle;
    }

    public static class FakeIOException
    extends IOException {
    }

    final class BufferedIndexOutputWrapper
    extends BufferedIndexOutput {
        private final IndexOutput io;

        public BufferedIndexOutputWrapper(int bufferSize, IndexOutput io) {
            super(bufferSize);
            this.io = io;
        }

        public long length() throws IOException {
            return this.io.length();
        }

        protected void flushBuffer(byte[] b, int offset, int len) throws IOException {
            this.io.writeBytes(b, offset, len);
        }

        public void seek(long pos) throws IOException {
            this.flush();
            this.io.seek(pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            try {
                super.flush();
            }
            finally {
                this.io.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.io.close();
            }
        }
    }

    public static class Failure {
        protected boolean doFail;

        public void eval(MockDirectoryWrapper dir) throws IOException {
        }

        public Failure reset() {
            return this;
        }

        public void setDoFail() {
            this.doFail = true;
        }

        public void clearDoFail() {
            this.doFail = false;
        }
    }

    private static enum Handle {
        Input,
        Output,
        Slice;

    }

    public static enum Throttling {
        ALWAYS,
        SOMETIMES,
        NEVER;

    }
}

