/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.apache.lucene.util._TestUtil;

final class CloseableFile
implements Closeable {
    private final File file;
    private final TestRuleMarkFailure failureMarker;

    public CloseableFile(File file, TestRuleMarkFailure failureMarker) {
        this.file = file;
        this.failureMarker = failureMarker;
    }

    @Override
    public void close() throws IOException {
        if (this.failureMarker.wasSuccessful() && this.file.exists()) {
            try {
                _TestUtil.rmDir(this.file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.file.exists()) {
                throw new IOException("Could not remove: " + this.file.getAbsolutePath());
            }
        }
    }
}

