/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import com.carrotsearch.randomizedtesting.generators.RandomInts;
import java.util.Random;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsFormat;
import org.apache.lucene.codecs.compressing.CompressingTermVectorsFormat;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.FastCompressingCodec;
import org.apache.lucene.codecs.compressing.FastDecompressionCompressingCodec;
import org.apache.lucene.codecs.compressing.HighCompressionCompressingCodec;
import org.apache.lucene.codecs.compressing.dummy.DummyCompressingCodec;
import org.apache.lucene.codecs.lucene45.Lucene45Codec;

public abstract class CompressingCodec
extends FilterCodec {
    private final CompressingStoredFieldsFormat storedFieldsFormat;
    private final CompressingTermVectorsFormat termVectorsFormat;

    public static CompressingCodec randomInstance(Random random, int chunkSize, boolean withSegmentSuffix) {
        switch (random.nextInt(4)) {
            case 0: {
                return new FastCompressingCodec(chunkSize, withSegmentSuffix);
            }
            case 1: {
                return new FastDecompressionCompressingCodec(chunkSize, withSegmentSuffix);
            }
            case 2: {
                return new HighCompressionCompressingCodec(chunkSize, withSegmentSuffix);
            }
            case 3: {
                return new DummyCompressingCodec(chunkSize, withSegmentSuffix);
            }
        }
        throw new AssertionError();
    }

    public static CompressingCodec randomInstance(Random random) {
        return CompressingCodec.randomInstance(random, RandomInts.randomIntBetween((Random)random, (int)1, (int)500), false);
    }

    public static CompressingCodec randomInstance(Random random, boolean withSegmentSuffix) {
        return CompressingCodec.randomInstance(random, RandomInts.randomIntBetween((Random)random, (int)1, (int)500), withSegmentSuffix);
    }

    public CompressingCodec(String name, String segmentSuffix, CompressionMode compressionMode, int chunkSize) {
        super(name, (Codec)new Lucene45Codec());
        this.storedFieldsFormat = new CompressingStoredFieldsFormat(name, segmentSuffix, compressionMode, chunkSize);
        this.termVectorsFormat = new CompressingTermVectorsFormat(name, segmentSuffix, compressionMode, chunkSize);
    }

    public CompressingCodec(String name, CompressionMode compressionMode, int chunkSize) {
        this(name, "", compressionMode, chunkSize);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public TermVectorsFormat termVectorsFormat() {
        return this.termVectorsFormat;
    }

    public String toString() {
        return this.getName() + "(storedFieldsFormat=" + this.storedFieldsFormat + ", termVectorsFormat=" + this.termVectorsFormat + ")";
    }
}

