/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.codecs.lucene40.Lucene40TermVectorsFormat;
import org.apache.lucene.index.AssertingAtomicReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;

public class AssertingTermVectorsFormat
extends TermVectorsFormat {
    private final TermVectorsFormat in = new Lucene40TermVectorsFormat();

    public TermVectorsReader vectorsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext context) throws IOException {
        return new AssertingTermVectorsReader(this.in.vectorsReader(directory, segmentInfo, fieldInfos, context));
    }

    public TermVectorsWriter vectorsWriter(Directory directory, SegmentInfo segmentInfo, IOContext context) throws IOException {
        return new AssertingTermVectorsWriter(this.in.vectorsWriter(directory, segmentInfo, context));
    }

    static class AssertingTermVectorsWriter
    extends TermVectorsWriter {
        private final TermVectorsWriter in;
        private Status docStatus;
        private Status fieldStatus;
        private Status termStatus;
        private int docCount;
        private int fieldCount;
        private int termCount;
        private int positionCount;
        boolean hasPositions;

        AssertingTermVectorsWriter(TermVectorsWriter in) {
            this.in = in;
            this.docStatus = Status.UNDEFINED;
            this.fieldStatus = Status.UNDEFINED;
            this.termStatus = Status.UNDEFINED;
            this.positionCount = 0;
            this.termCount = 0;
            this.fieldCount = 0;
        }

        public void startDocument(int numVectorFields) throws IOException {
            assert (this.fieldCount == 0);
            assert (this.docStatus != Status.STARTED);
            this.in.startDocument(numVectorFields);
            this.docStatus = Status.STARTED;
            this.fieldCount = numVectorFields;
            ++this.docCount;
        }

        public void finishDocument() throws IOException {
            assert (this.fieldCount == 0);
            assert (this.docStatus == Status.STARTED);
            this.in.finishDocument();
            this.docStatus = Status.FINISHED;
        }

        public void startField(FieldInfo info, int numTerms, boolean positions, boolean offsets, boolean payloads) throws IOException {
            assert (this.termCount == 0);
            assert (this.docStatus == Status.STARTED);
            assert (this.fieldStatus != Status.STARTED);
            this.in.startField(info, numTerms, positions, offsets, payloads);
            this.fieldStatus = Status.STARTED;
            this.termCount = numTerms;
            this.hasPositions = positions || offsets || payloads;
        }

        public void finishField() throws IOException {
            assert (this.termCount == 0);
            assert (this.fieldStatus == Status.STARTED);
            this.in.finishField();
            this.fieldStatus = Status.FINISHED;
            --this.fieldCount;
        }

        public void startTerm(BytesRef term, int freq) throws IOException {
            assert (this.docStatus == Status.STARTED);
            assert (this.fieldStatus == Status.STARTED);
            assert (this.termStatus != Status.STARTED);
            this.in.startTerm(term, freq);
            this.termStatus = Status.STARTED;
            this.positionCount = this.hasPositions ? freq : 0;
        }

        public void finishTerm() throws IOException {
            assert (this.positionCount == 0);
            assert (this.docStatus == Status.STARTED);
            assert (this.fieldStatus == Status.STARTED);
            assert (this.termStatus == Status.STARTED);
            this.in.finishTerm();
            this.termStatus = Status.FINISHED;
            --this.termCount;
        }

        public void addPosition(int position, int startOffset, int endOffset, BytesRef payload) throws IOException {
            assert (this.docStatus == Status.STARTED);
            assert (this.fieldStatus == Status.STARTED);
            assert (this.termStatus == Status.STARTED);
            this.in.addPosition(position, startOffset, endOffset, payload);
            --this.positionCount;
        }

        public void abort() {
            this.in.abort();
        }

        public void finish(FieldInfos fis, int numDocs) throws IOException {
            assert (this.docCount == numDocs);
            assert (this.docStatus == (numDocs > 0 ? Status.FINISHED : Status.UNDEFINED));
            assert (this.fieldStatus != Status.STARTED);
            assert (this.termStatus != Status.STARTED);
            this.in.finish(fis, numDocs);
        }

        public Comparator<BytesRef> getComparator() throws IOException {
            return this.in.getComparator();
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    static enum Status {
        UNDEFINED,
        STARTED,
        FINISHED;

    }

    static class AssertingTermVectorsReader
    extends TermVectorsReader {
        private final TermVectorsReader in;

        AssertingTermVectorsReader(TermVectorsReader in) {
            this.in = in;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public Fields get(int doc) throws IOException {
            Fields fields = this.in.get(doc);
            return fields == null ? null : new AssertingAtomicReader.AssertingFields(fields);
        }

        public TermVectorsReader clone() {
            return new AssertingTermVectorsReader(this.in.clone());
        }

        public long ramBytesUsed() {
            return this.in.ramBytesUsed();
        }
    }
}

