/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;

public abstract class BaseDocValuesFormatTestCase
extends LuceneTestCase {
    private Codec savedCodec;

    protected abstract Codec getCodec();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.savedCodec = Codec.getDefault();
        Codec.setDefault((Codec)this.getCodec());
    }

    @Override
    public void tearDown() throws Exception {
        Codec.setDefault((Codec)this.savedCodec);
        super.tearDown();
    }

    public void testOneNumber() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv", 5L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, null, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.get(hits.scoreDocs[i].doc));
        }
        ireader.close();
        directory.close();
    }

    public void testOneFloat() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new FloatDocValuesField("dv", 5.7f));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, null, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
            BaseDocValuesFormatTestCase.assertEquals((long)Float.floatToRawIntBits(5.7f), (long)dv.get(hits.scoreDocs[i].doc));
        }
        ireader.close();
        directory.close();
    }

    public void testTwoNumbers() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        doc.add((IndexableField)new NumericDocValuesField("dv2", 17L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, null, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.get(hits.scoreDocs[i].doc));
            dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)17L, (long)dv.get(hits.scoreDocs[i].doc));
        }
        ireader.close();
        directory.close();
    }

    public void testTwoFieldsMixed() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        doc.add((IndexableField)new BinaryDocValuesField("dv2", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, null, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.get(hits.scoreDocs[i].doc));
            BinaryDocValues dv2 = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv2");
            dv2.get(hits.scoreDocs[i].doc, scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testThreeFieldsMixed() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField("dv1", new BytesRef((CharSequence)"hello hello")));
        doc.add((IndexableField)new NumericDocValuesField("dv2", 5L));
        doc.add((IndexableField)new BinaryDocValuesField("dv3", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, null, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv1");
            int ord = dv.getOrd(0);
            dv.lookupOrd(ord, scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello hello"), (Object)scratch);
            NumericDocValues dv2 = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv2.get(hits.scoreDocs[i].doc));
            BinaryDocValues dv3 = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv3");
            dv3.get(hits.scoreDocs[i].doc, scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testThreeFieldsMixed2() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef((CharSequence)"hello world")));
        doc.add((IndexableField)new SortedDocValuesField("dv2", new BytesRef((CharSequence)"hello hello")));
        doc.add((IndexableField)new NumericDocValuesField("dv3", 5L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, null, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv2");
            int ord = dv.getOrd(0);
            dv.lookupOrd(ord, scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello hello"), (Object)scratch);
            NumericDocValues dv2 = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv3");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv2.get(hits.scoreDocs[i].doc));
            BinaryDocValues dv3 = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv1");
            dv3.get(hits.scoreDocs[i].doc, scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testTwoDocumentsNumeric() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 1L));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 2L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.get(1));
        ireader.close();
        directory.close();
    }

    public void testTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new NumericDocValuesField("dv", -10L));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new NumericDocValuesField("dv", 99L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((AtomicReaderContext)ireader.leaves().get(0)).reader().document(i);
            long expected = doc2.get("id").equals("0") ? -10L : 99L;
            BaseDocValuesFormatTestCase.assertEquals((long)expected, (long)dv.get(i));
        }
        ireader.close();
        directory.close();
    }

    public void testBigNumericRange() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", Long.MIN_VALUE));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", Long.MAX_VALUE));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)Long.MIN_VALUE, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)Long.MAX_VALUE, (long)dv.get(1));
        ireader.close();
        directory.close();
    }

    public void testBigNumericRange2() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", -8841491950446638677L));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 9062230939892376225L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)-8841491950446638677L, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)9062230939892376225L, (long)dv.get(1));
        ireader.close();
        directory.close();
    }

    public void testBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, null, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            BinaryDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
            dv.get(hits.scoreDocs[i].doc, scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testBytesTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((AtomicReaderContext)ireader.leaves().get(0)).reader().document(i);
            String expected = doc2.get("id").equals("0") ? "hello world 1" : "hello 2";
            dv.get(i, scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)scratch.utf8ToString());
        }
        ireader.close();
        directory.close();
    }

    public void testSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, null, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
            dv.lookupOrd(dv.getOrd(hits.scoreDocs[i].doc), scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testSortedBytesTwoDocuments() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = new BytesRef();
        dv.lookupOrd(dv.getOrd(0), scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 1", (Object)scratch.utf8ToString());
        dv.lookupOrd(dv.getOrd(1), scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 2", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testSortedBytesThreeDocuments() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        BytesRef scratch = new BytesRef();
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(0));
        dv.lookupOrd(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 1", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getOrd(1));
        dv.lookupOrd(1, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 2", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(2));
        ireader.close();
        directory.close();
    }

    public void testSortedBytesTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        BytesRef scratch = new BytesRef();
        dv.lookupOrd(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 1"), (Object)scratch);
        dv.lookupOrd(1, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 2"), (Object)scratch);
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((AtomicReaderContext)ireader.leaves().get(0)).reader().document(i);
            String expected = doc2.get("id").equals("0") ? "hello world 1" : "hello world 2";
            dv.lookupOrd(dv.getOrd(i), scratch);
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)scratch.utf8ToString());
        }
        ireader.close();
        directory.close();
    }

    public void testBytesWithNewline() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello\nworld\r1")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = new BytesRef();
        dv.get(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello\nworld\r1"), (Object)scratch);
        ireader.close();
        directory.close();
    }

    public void testMissingSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.addDocument(new Document());
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = new BytesRef();
        dv.lookupOrd(dv.getOrd(0), scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 2"), (Object)scratch);
        dv.lookupOrd(dv.getOrd(1), scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)""), (Object)scratch);
        ireader.close();
        directory.close();
    }

    public void testSortedTermsEnum() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"ha!")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"zzz")));
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"beer"), true));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"hello"), true));
        BaseDocValuesFormatTestCase.assertEquals((String)Codec.getDefault().toString(), (Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"world"), true));
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"bogus"), true));
        termsEnum.seekExact(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        termsEnum.seekExact(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        termsEnum.seekExact(2L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        ireader.close();
        directory.close();
    }

    public void testEmptySortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = new BytesRef();
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(0));
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(1));
        dv.lookupOrd(dv.getOrd(0), scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testEmptyBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = new BytesRef();
        dv.get(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)scratch.utf8ToString());
        dv.get(1, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testVeryLargeButLegalBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        byte[] bytes = new byte[32766];
        BytesRef b = new BytesRef(bytes);
        BaseDocValuesFormatTestCase.random().nextBytes(bytes);
        doc.add((IndexableField)new BinaryDocValuesField("dv", b));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = new BytesRef();
        dv.get(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(bytes), (Object)scratch);
        ireader.close();
        directory.close();
    }

    public void testVeryLargeButLegalSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        byte[] bytes = new byte[32766];
        BytesRef b = new BytesRef(bytes);
        BaseDocValuesFormatTestCase.random().nextBytes(bytes);
        doc.add((IndexableField)new SortedDocValuesField("dv", b));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = new BytesRef();
        dv.get(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(bytes), (Object)scratch);
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"boo!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        byte[] mybytes = new byte[20];
        BytesRef scratch = new BytesRef(mybytes);
        dv.get(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"boo!", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertFalse((scratch.bytes == mybytes ? 1 : 0) != 0);
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"boo!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        byte[] mybytes = new byte[20];
        BytesRef scratch = new BytesRef(mybytes);
        dv.get(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"boo!", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertFalse((scratch.bytes == mybytes ? 1 : 0) != 0);
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnBytesEachTime() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"foo!")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"bar!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = new BytesRef();
        dv.get(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"foo!", (Object)scratch.utf8ToString());
        BytesRef scratch2 = new BytesRef();
        dv.get(1, scratch2);
        BaseDocValuesFormatTestCase.assertEquals((Object)"bar!", (Object)scratch2.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((Object)"foo!", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnSortedBytesEachTime() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"foo!")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"bar!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((AtomicReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = new BytesRef();
        dv.get(0, scratch);
        BaseDocValuesFormatTestCase.assertEquals((Object)"foo!", (Object)scratch.utf8ToString());
        BytesRef scratch2 = new BytesRef();
        dv.get(1, scratch2);
        BaseDocValuesFormatTestCase.assertEquals((Object)"bar!", (Object)scratch2.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((Object)"foo!", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testDocValuesSimple() throws IOException {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        IndexWriter writer = new IndexWriter((Directory)dir, conf);
        for (int i = 0; i < 5; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new NumericDocValuesField("docId", (long)i));
            doc.add((IndexableField)new TextField("docId", "" + i, Field.Store.NO));
            writer.addDocument((Iterable)doc);
        }
        writer.commit();
        writer.forceMerge(1, true);
        writer.close(true);
        DirectoryReader reader = DirectoryReader.open((Directory)dir, (int)1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)reader.leaves().size());
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("docId", "0")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "1")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "2")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "3")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "4")), BooleanClause.Occur.SHOULD);
        TopDocs search = searcher.search((Query)query, 10);
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)search.totalHits);
        ScoreDoc[] scoreDocs = search.scoreDocs;
        NumericDocValues docValues = BaseDocValuesFormatTestCase.getOnlySegmentReader(reader).getNumericDocValues("docId");
        for (int i = 0; i < scoreDocs.length; ++i) {
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.get(scoreDocs[i].doc));
        }
        reader.close();
        dir.close();
    }

    public void testRandomSortedBytes() throws IOException {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig cfg = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter w = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, cfg);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(100);
        BytesRefHash hash = new BytesRefHash();
        HashMap<String, String> docToString = new HashMap<String, String>();
        int maxLength = _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 50);
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", "" + i, Field.Store.YES));
            String string = _TestUtil.randomRealisticUnicodeString(BaseDocValuesFormatTestCase.random(), 1, maxLength);
            BytesRef br = new BytesRef((CharSequence)string);
            doc.add((IndexableField)new SortedDocValuesField("field", br));
            hash.add(br);
            docToString.put("" + i, string);
            w.addDocument(doc);
        }
        if (BaseDocValuesFormatTestCase.rarely()) {
            w.commit();
        }
        int numDocsNoValue = BaseDocValuesFormatTestCase.atLeast(10);
        for (int i = 0; i < numDocsNoValue; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", "noValue", Field.Store.YES));
            w.addDocument(doc);
        }
        BytesRef bytesRef = new BytesRef();
        hash.add(bytesRef);
        if (BaseDocValuesFormatTestCase.rarely()) {
            w.commit();
        }
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            String id = "" + i + numDocs;
            doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", id, Field.Store.YES));
            String string = _TestUtil.randomRealisticUnicodeString(BaseDocValuesFormatTestCase.random(), 1, maxLength);
            BytesRef br = new BytesRef((CharSequence)string);
            hash.add(br);
            docToString.put(id, string);
            doc.add((IndexableField)new SortedDocValuesField("field", br));
            w.addDocument(doc);
        }
        w.commit();
        DirectoryReader reader = w.getReader();
        SortedDocValues docValues = MultiDocValues.getSortedValues((IndexReader)reader, (String)"field");
        int[] sort = hash.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        BytesRef expected = new BytesRef();
        BytesRef actual = new BytesRef();
        BaseDocValuesFormatTestCase.assertEquals((long)hash.size(), (long)docValues.getValueCount());
        for (int i = 0; i < hash.size(); ++i) {
            hash.get(sort[i], expected);
            docValues.lookupOrd(i, actual);
            BaseDocValuesFormatTestCase.assertEquals((Object)expected.utf8ToString(), (Object)actual.utf8ToString());
            int ord = docValues.lookupTerm(expected);
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)ord);
        }
        AtomicReader slowR = SlowCompositeReaderWrapper.wrap((IndexReader)reader);
        Set entrySet = docToString.entrySet();
        for (Map.Entry entry : entrySet) {
            DocsEnum termDocsEnum = slowR.termDocsEnum(new Term("id", (String)entry.getKey()));
            int docId = termDocsEnum.nextDoc();
            expected = new BytesRef((CharSequence)entry.getValue());
            docValues.get(docId, actual);
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)actual);
        }
        reader.close();
        w.close();
        dir.close();
    }

    private void doTestNumericsVsStoredFields(long minValue, long maxValue) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        Field storedField = BaseDocValuesFormatTestCase.newStringField("stored", "", Field.Store.YES);
        NumericDocValuesField dvField = new NumericDocValuesField("dv", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            long value = _TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), minValue, maxValue);
            storedField.setStringValue(Long.toString(value));
            dvField.setLongValue(value);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        for (AtomicReaderContext context : ir.leaves()) {
            AtomicReader r = context.reader();
            NumericDocValues docValues = r.getNumericDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                long storedValue = Long.parseLong(r.document(i).get("stored"));
                BaseDocValuesFormatTestCase.assertEquals((long)storedValue, (long)docValues.get(i));
            }
        }
        ir.close();
        dir.close();
    }

    public void testBooleanNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(0L, 1L);
        }
    }

    public void testByteNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(-128L, 127L);
        }
    }

    public void testShortNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(-32768L, 32767L);
        }
    }

    public void testIntNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    public void testLongNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(Long.MIN_VALUE, Long.MAX_VALUE);
        }
    }

    private void doTestBinaryVsStoredFields(int minLength, int maxLength) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        BinaryDocValuesField dvField = new BinaryDocValuesField("dv", new BytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            int length = minLength == maxLength ? minLength : _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        for (AtomicReaderContext context : ir.leaves()) {
            AtomicReader r = context.reader();
            BinaryDocValues docValues = r.getBinaryDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                BytesRef binaryValue = r.document(i).getBinaryValue("stored");
                BytesRef scratch = new BytesRef();
                docValues.get(i, scratch);
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)scratch);
            }
        }
        ir.close();
        dir.close();
    }

    public void testBinaryFixedLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestBinaryVsStoredFields(fixedLength, fixedLength);
        }
    }

    public void testBinaryVariableLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestBinaryVsStoredFields(1, 10);
        }
    }

    private void doTestSortedVsStoredFields(int minLength, int maxLength) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        SortedDocValuesField dvField = new SortedDocValuesField("dv", new BytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            int length = minLength == maxLength ? minLength : _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        for (AtomicReaderContext context : ir.leaves()) {
            AtomicReader r = context.reader();
            SortedDocValues docValues = r.getSortedDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                BytesRef binaryValue = r.document(i).getBinaryValue("stored");
                BytesRef scratch = new BytesRef();
                docValues.get(i, scratch);
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)scratch);
            }
        }
        ir.close();
        dir.close();
    }

    public void testSortedFixedLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedVsStoredFields(fixedLength, fixedLength);
        }
    }

    public void testSortedVariableLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedVsStoredFields(1, 10);
        }
    }

    public void testSortedSetOneValue() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoFields() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field2", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field2");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsMerged() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        dv.lookupOrd(1L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoValues() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        dv.lookupOrd(1L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoValuesUnordered() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        dv.lookupOrd(1L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetThreeValuesTwoDocs() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"beer"), (Object)bytes);
        dv.lookupOrd(1L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        dv.lookupOrd(2L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsLastMissing() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        doc = new Document();
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsLastMissingMerge() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsFirstMissing() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsFirstMissingMerge() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = new BytesRef();
        dv.lookupOrd(0L, bytes);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValues() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getValueCount());
        ireader.close();
        directory.close();
    }

    public void testSortedSetTermsEnum() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"ha!")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"zzz")));
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"beer"), true));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"hello"), true));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"world"), true));
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"bogus"), true));
        termsEnum.seekExact(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        termsEnum.seekExact(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        termsEnum.seekExact(2L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        ireader.close();
        directory.close();
    }

    private void doTestSortedSetVsStoredFields(int minLength, int maxLength) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = new IndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            StringField idField = new StringField("id", Integer.toString(i), Field.Store.NO);
            doc.add((IndexableField)idField);
            int length = minLength == maxLength ? minLength : _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            int numValues = BaseDocValuesFormatTestCase.random().nextInt(17);
            TreeSet<String> values = new TreeSet<String>();
            for (int v = 0; v < numValues; ++v) {
                values.add(_TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random(), length));
            }
            for (String v : values) {
                doc.add((IndexableField)new StoredField("stored", v));
            }
            ArrayList unordered = new ArrayList(values);
            Collections.shuffle(unordered, BaseDocValuesFormatTestCase.random());
            for (String v : unordered) {
                doc.add((IndexableField)new SortedSetDocValuesField("dv", new BytesRef((CharSequence)v)));
            }
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        for (AtomicReaderContext context : ir.leaves()) {
            AtomicReader r = context.reader();
            SortedSetDocValues docValues = r.getSortedSetDocValues("dv");
            BytesRef scratch = new BytesRef();
            for (int i = 0; i < r.maxDoc(); ++i) {
                String[] stringValues = r.document(i).getValues("stored");
                if (docValues != null) {
                    docValues.setDocument(i);
                }
                for (int j = 0; j < stringValues.length; ++j) {
                    assert (docValues != null);
                    long ord = docValues.nextOrd();
                    assert (ord != -1L);
                    docValues.lookupOrd(ord, scratch);
                    BaseDocValuesFormatTestCase.assertEquals((Object)stringValues[j], (Object)scratch.utf8ToString());
                }
                assert (docValues == null || docValues.nextOrd() == -1L);
            }
        }
        ir.close();
        dir.close();
    }

    public void testSortedSetFixedLengthVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedSetVsStoredFields(fixedLength, fixedLength);
        }
    }

    public void testSortedSetVariableLengthVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(1, 10);
        }
    }

    private void assertEquals(int maxDoc, SortedSetDocValues expected, SortedSetDocValues actual) throws Exception {
        if (actual == null) {
            BaseDocValuesFormatTestCase.assertEquals((Object)SortedSetDocValues.EMPTY, (Object)expected);
            return;
        }
        BaseDocValuesFormatTestCase.assertEquals((long)expected.getValueCount(), (long)actual.getValueCount());
        for (int i = 0; i < maxDoc; ++i) {
            long expectedOrd;
            expected.setDocument(i);
            actual.setDocument(i);
            while ((expectedOrd = expected.nextOrd()) != -1L) {
                BaseDocValuesFormatTestCase.assertEquals((long)expectedOrd, (long)actual.nextOrd());
            }
            BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)actual.nextOrd());
        }
        BytesRef expectedBytes = new BytesRef();
        BytesRef actualBytes = new BytesRef();
        for (long i = 0L; i < expected.getValueCount(); ++i) {
            expected.lookupTerm(expectedBytes);
            actual.lookupTerm(actualBytes);
            BaseDocValuesFormatTestCase.assertEquals((Object)expectedBytes, (Object)actualBytes);
        }
    }

    private void doTestSortedSetVsUninvertedField(int minLength, int maxLength) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = new IndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            StringField idField = new StringField("id", Integer.toString(i), Field.Store.NO);
            doc.add((IndexableField)idField);
            int length = minLength == maxLength ? minLength : _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            int numValues = BaseDocValuesFormatTestCase.random().nextInt(17);
            ArrayList<String> values = new ArrayList<String>();
            for (int v = 0; v < numValues; ++v) {
                values.add(_TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random(), length));
            }
            ArrayList unordered = new ArrayList(values);
            Collections.shuffle(unordered, BaseDocValuesFormatTestCase.random());
            for (String v : values) {
                doc.add((IndexableField)BaseDocValuesFormatTestCase.newStringField("indexed", v, Field.Store.NO));
            }
            ArrayList unordered2 = new ArrayList(values);
            Collections.shuffle(unordered2, BaseDocValuesFormatTestCase.random());
            for (String v : unordered2) {
                doc.add((IndexableField)new SortedSetDocValuesField("dv", new BytesRef((CharSequence)v)));
            }
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        for (AtomicReaderContext context : ir.leaves()) {
            AtomicReader r = context.reader();
            SortedSetDocValues expected = FieldCache.DEFAULT.getDocTermOrds(r, "indexed");
            SortedSetDocValues actual = r.getSortedSetDocValues("dv");
            this.assertEquals(r.maxDoc(), expected, actual);
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        SegmentReader ar = BaseDocValuesFormatTestCase.getOnlySegmentReader(ir);
        SortedSetDocValues expected = FieldCache.DEFAULT.getDocTermOrds((AtomicReader)ar, "indexed");
        SortedSetDocValues actual = ar.getSortedSetDocValues("dv");
        this.assertEquals(ir.maxDoc(), expected, actual);
        ir.close();
        writer.close();
        dir.close();
    }

    public void testSortedSetFixedLengthVsUninvertedField() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = _TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedSetVsUninvertedField(fixedLength, fixedLength);
        }
    }

    public void testSortedSetVariableLengthVsUninvertedField() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", BaseDocValuesFormatTestCase.defaultCodecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsUninvertedField(1, 10);
        }
    }
}

