/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherLifetimeManager;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LineFileDocs;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.PrintStreamInfoStream;
import org.apache.lucene.util.TestUtil;

public abstract class ShardSearchingTestBase
extends LuceneTestCase {
    private final String[] fieldsToShare = new String[]{"body", "title"};
    protected NodeState[] nodes;
    int maxSearcherAgeSeconds;
    long endTimeNanos;
    private Thread changeIndicesThread;

    void broadcastNodeReopen(int nodeID, long version, IndexSearcher newSearcher) throws IOException {
        if (VERBOSE) {
            System.out.println("REOPEN: nodeID=" + nodeID + " version=" + version + " maxDoc=" + newSearcher.getIndexReader().maxDoc());
        }
        for (String field : this.fieldsToShare) {
            CollectionStatistics stats = newSearcher.collectionStatistics(field);
            for (NodeState node : this.nodes) {
                if (node.myNodeID == nodeID) continue;
                node.collectionStatsCache.put(new FieldAndShardVersion(nodeID, version, field), stats);
            }
        }
        for (NodeState node : this.nodes) {
            node.updateNodeVersion(nodeID, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TopDocs searchNode(int nodeID, long[] nodeVersions, Query q, Sort sort, int numHits, ScoreDoc searchAfter) throws IOException {
        NodeState.ShardIndexSearcher s = this.nodes[nodeID].acquire(nodeVersions);
        try {
            if (sort == null) {
                if (searchAfter != null) {
                    TopDocs topDocs = s.localSearchAfter(searchAfter, q, numHits);
                    return topDocs;
                }
                TopDocs topDocs = s.localSearch(q, numHits);
                return topDocs;
            }
            assert (searchAfter == null);
            TopFieldDocs topFieldDocs = s.localSearch(q, numHits, sort);
            return topFieldDocs;
        }
        finally {
            this.nodes[nodeID].release(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Term, TermStatistics> getNodeTermStats(Set<Term> terms, int nodeID, long version) throws IOException {
        NodeState node = this.nodes[nodeID];
        HashMap<Term, TermStatistics> stats = new HashMap<Term, TermStatistics>();
        IndexSearcher s = node.searchers.acquire(version);
        if (s == null) {
            throw new SearcherExpiredException("node=" + nodeID + " version=" + version);
        }
        try {
            for (Term term : terms) {
                TermContext termContext = TermContext.build((IndexReaderContext)s.getIndexReader().getContext(), (Term)term);
                stats.put(term, s.termStatistics(term, termContext));
            }
        }
        finally {
            node.searchers.release(s);
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(int numNodes, double runTimeSec, int maxSearcherAgeSeconds) throws IOException {
        IndexSearcher s;
        int nodeID;
        this.endTimeNanos = System.nanoTime() + (long)(runTimeSec * 1.0E9);
        this.maxSearcherAgeSeconds = maxSearcherAgeSeconds;
        this.nodes = new NodeState[numNodes];
        for (int nodeID2 = 0; nodeID2 < numNodes; ++nodeID2) {
            this.nodes[nodeID2] = new NodeState(ShardSearchingTestBase.random(), nodeID2, numNodes);
        }
        long[] nodeVersions = new long[this.nodes.length];
        for (nodeID = 0; nodeID < numNodes; ++nodeID) {
            s = (IndexSearcher)this.nodes[nodeID].mgr.acquire();
            try {
                nodeVersions[nodeID] = this.nodes[nodeID].searchers.record(s);
                continue;
            }
            finally {
                this.nodes[nodeID].mgr.release((Object)s);
            }
        }
        for (nodeID = 0; nodeID < numNodes; ++nodeID) {
            s = (IndexSearcher)this.nodes[nodeID].mgr.acquire();
            assert (nodeVersions[nodeID] == this.nodes[nodeID].searchers.record(s));
            assert (s != null);
            try {
                this.broadcastNodeReopen(nodeID, nodeVersions[nodeID], s);
                continue;
            }
            finally {
                this.nodes[nodeID].mgr.release((Object)s);
            }
        }
        this.changeIndicesThread = new ChangeIndices();
        this.changeIndicesThread.start();
    }

    protected void finish() throws InterruptedException, IOException {
        this.changeIndicesThread.join();
        for (NodeState node : this.nodes) {
            node.close();
        }
    }

    protected static class SearcherAndVersion {
        public final IndexSearcher searcher;
        public final long version;

        public SearcherAndVersion(IndexSearcher searcher, long version) {
            this.searcher = searcher;
            this.version = version;
        }
    }

    private final class ChangeIndices
    extends Thread {
        private ChangeIndices() {
        }

        @Override
        public void run() {
            try {
                LineFileDocs docs = new LineFileDocs(LuceneTestCase.random(), LuceneTestCase.defaultCodecSupportsDocValues());
                int numDocs = 0;
                while (System.nanoTime() < ShardSearchingTestBase.this.endTimeNanos) {
                    int what = LuceneTestCase.random().nextInt(3);
                    NodeState node = ShardSearchingTestBase.this.nodes[LuceneTestCase.random().nextInt(ShardSearchingTestBase.this.nodes.length)];
                    if (numDocs == 0 || what == 0) {
                        node.writer.addDocument((Iterable)docs.nextDoc());
                        ++numDocs;
                    } else if (what == 1) {
                        node.writer.updateDocument(new Term("docid", "" + LuceneTestCase.random().nextInt(numDocs)), (Iterable)docs.nextDoc());
                        ++numDocs;
                    } else {
                        node.writer.deleteDocuments(new Term[]{new Term("docid", "" + LuceneTestCase.random().nextInt(numDocs))});
                    }
                    if (LuceneTestCase.random().nextInt(17) == 12) {
                        node.writer.commit();
                    }
                    if (LuceneTestCase.random().nextInt(17) != 12) continue;
                    ShardSearchingTestBase.this.nodes[LuceneTestCase.random().nextInt(ShardSearchingTestBase.this.nodes.length)].reopen();
                }
            }
            catch (Throwable t) {
                System.out.println("FAILED:");
                t.printStackTrace(System.out);
                throw new RuntimeException(t);
            }
        }
    }

    protected final class NodeState
    implements Closeable {
        public final Directory dir;
        public final IndexWriter writer;
        public final SearcherLifetimeManager searchers;
        public final SearcherManager mgr;
        public final int myNodeID;
        public final long[] currentNodeVersions;
        private final Map<FieldAndShardVersion, CollectionStatistics> collectionStatsCache = new ConcurrentHashMap<FieldAndShardVersion, CollectionStatistics>();
        private final Map<TermAndShardVersion, TermStatistics> termStatsCache = new ConcurrentHashMap<TermAndShardVersion, TermStatistics>();
        private volatile ShardIndexSearcher currentShardSearcher;

        public NodeState(Random random, int nodeID, int numNodes) throws IOException {
            this.myNodeID = nodeID;
            this.dir = LuceneTestCase.newFSDirectory(LuceneTestCase.createTempDir("ShardSearchingTestBase"));
            MockAnalyzer analyzer = new MockAnalyzer(LuceneTestCase.random());
            analyzer.setMaxTokenLength(TestUtil.nextInt(LuceneTestCase.random(), 1, 32766));
            IndexWriterConfig iwc = new IndexWriterConfig(LuceneTestCase.TEST_VERSION_CURRENT, (Analyzer)analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            if (LuceneTestCase.VERBOSE) {
                iwc.setInfoStream((InfoStream)new PrintStreamInfoStream(System.out));
            }
            this.writer = new IndexWriter(this.dir, iwc);
            this.mgr = new SearcherManager(this.writer, true, null);
            this.searchers = new SearcherLifetimeManager();
            this.currentNodeVersions = new long[numNodes];
        }

        public void initSearcher(long[] nodeVersions) throws IOException {
            assert (this.currentShardSearcher == null);
            System.arraycopy(nodeVersions, 0, this.currentNodeVersions, 0, this.currentNodeVersions.length);
            this.currentShardSearcher = new ShardIndexSearcher((long[])this.currentNodeVersions.clone(), ((IndexSearcher)this.mgr.acquire()).getIndexReader(), this.myNodeID);
        }

        public void updateNodeVersion(int nodeID, long version) throws IOException {
            this.currentNodeVersions[nodeID] = version;
            if (this.currentShardSearcher != null) {
                this.currentShardSearcher.getIndexReader().decRef();
            }
            this.currentShardSearcher = new ShardIndexSearcher((long[])this.currentNodeVersions.clone(), ((IndexSearcher)this.mgr.acquire()).getIndexReader(), this.myNodeID);
        }

        public ShardIndexSearcher acquire() {
            ShardIndexSearcher s;
            while (!(s = this.currentShardSearcher).getIndexReader().tryIncRef()) {
            }
            return s;
        }

        public void release(ShardIndexSearcher s) throws IOException {
            s.getIndexReader().decRef();
        }

        public ShardIndexSearcher acquire(long[] nodeVersions) {
            IndexSearcher s = this.searchers.acquire(nodeVersions[this.myNodeID]);
            if (s == null) {
                throw new SearcherExpiredException("nodeID=" + this.myNodeID + " version=" + nodeVersions[this.myNodeID]);
            }
            return new ShardIndexSearcher(nodeVersions, s.getIndexReader(), this.myNodeID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reopen() throws IOException {
            IndexSearcher before = (IndexSearcher)this.mgr.acquire();
            this.mgr.release((Object)before);
            this.mgr.maybeRefresh();
            IndexSearcher after = (IndexSearcher)this.mgr.acquire();
            try {
                if (after != before) {
                    long version = this.searchers.record(after);
                    this.searchers.prune((SearcherLifetimeManager.Pruner)new SearcherLifetimeManager.PruneByAge((double)ShardSearchingTestBase.this.maxSearcherAgeSeconds));
                    ShardSearchingTestBase.this.broadcastNodeReopen(this.myNodeID, version, after);
                }
            }
            finally {
                this.mgr.release((Object)after);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.currentShardSearcher != null) {
                this.currentShardSearcher.getIndexReader().decRef();
            }
            this.searchers.close();
            this.mgr.close();
            this.writer.close();
            this.dir.close();
        }

        public class ShardIndexSearcher
        extends IndexSearcher {
            public final long[] nodeVersions;
            public final int myNodeID;

            public ShardIndexSearcher(long[] nodeVersions, IndexReader localReader, int nodeID) {
                super(localReader);
                this.nodeVersions = nodeVersions;
                this.myNodeID = nodeID;
                assert (this.myNodeID == NodeState.this.myNodeID) : "myNodeID=" + nodeID + " NodeState.this.myNodeID=" + nodeState.myNodeID;
            }

            public Query rewrite(Query original) throws IOException {
                Query rewritten = super.rewrite(original);
                HashSet terms = new HashSet();
                rewritten.extractTerms(terms);
                for (int nodeID = 0; nodeID < this.nodeVersions.length; ++nodeID) {
                    TermAndShardVersion key;
                    if (nodeID == this.myNodeID) continue;
                    HashSet<Term> missing = new HashSet<Term>();
                    for (Term term : terms) {
                        key = new TermAndShardVersion(nodeID, this.nodeVersions[nodeID], term);
                        if (NodeState.this.termStatsCache.containsKey(key)) continue;
                        missing.add(term);
                    }
                    if (missing.size() == 0) continue;
                    for (Map.Entry entry : ShardSearchingTestBase.this.getNodeTermStats(missing, nodeID, this.nodeVersions[nodeID]).entrySet()) {
                        key = new TermAndShardVersion(nodeID, this.nodeVersions[nodeID], (Term)entry.getKey());
                        NodeState.this.termStatsCache.put(key, entry.getValue());
                    }
                }
                return rewritten;
            }

            public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
                assert (term != null);
                long docFreq = 0L;
                long totalTermFreq = 0L;
                for (int nodeID = 0; nodeID < this.nodeVersions.length; ++nodeID) {
                    TermStatistics subStats;
                    if (nodeID == this.myNodeID) {
                        subStats = super.termStatistics(term, context);
                    } else {
                        TermAndShardVersion key = new TermAndShardVersion(nodeID, this.nodeVersions[nodeID], term);
                        subStats = (TermStatistics)NodeState.this.termStatsCache.get(key);
                        assert (subStats != null);
                    }
                    long nodeDocFreq = subStats.docFreq();
                    docFreq = docFreq >= 0L && nodeDocFreq >= 0L ? (docFreq += nodeDocFreq) : -1L;
                    long nodeTotalTermFreq = subStats.totalTermFreq();
                    if (totalTermFreq >= 0L && nodeTotalTermFreq >= 0L) {
                        totalTermFreq += nodeTotalTermFreq;
                        continue;
                    }
                    totalTermFreq = -1L;
                }
                return new TermStatistics(term.bytes(), docFreq, totalTermFreq);
            }

            public CollectionStatistics collectionStatistics(String field) throws IOException {
                long docCount = 0L;
                long sumTotalTermFreq = 0L;
                long sumDocFreq = 0L;
                long maxDoc = 0L;
                for (int nodeID = 0; nodeID < this.nodeVersions.length; ++nodeID) {
                    FieldAndShardVersion key = new FieldAndShardVersion(nodeID, this.nodeVersions[nodeID], field);
                    CollectionStatistics nodeStats = nodeID == this.myNodeID ? super.collectionStatistics(field) : (CollectionStatistics)NodeState.this.collectionStatsCache.get(key);
                    if (nodeStats == null) {
                        System.out.println("coll stats myNodeID=" + this.myNodeID + ": " + NodeState.this.collectionStatsCache.keySet());
                    }
                    assert (nodeStats != null) : "myNodeID=" + this.myNodeID + " nodeID=" + nodeID + " version=" + this.nodeVersions[nodeID] + " field=" + field;
                    long nodeDocCount = nodeStats.docCount();
                    docCount = docCount >= 0L && nodeDocCount >= 0L ? (docCount += nodeDocCount) : -1L;
                    long nodeSumTotalTermFreq = nodeStats.sumTotalTermFreq();
                    sumTotalTermFreq = sumTotalTermFreq >= 0L && nodeSumTotalTermFreq >= 0L ? (sumTotalTermFreq += nodeSumTotalTermFreq) : -1L;
                    long nodeSumDocFreq = nodeStats.sumDocFreq();
                    sumDocFreq = sumDocFreq >= 0L && nodeSumDocFreq >= 0L ? (sumDocFreq += nodeSumDocFreq) : -1L;
                    assert (nodeStats.maxDoc() >= 0L);
                    maxDoc += nodeStats.maxDoc();
                }
                return new CollectionStatistics(field, maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
            }

            public TopDocs search(Query query, int numHits) throws IOException {
                TopDocs[] shardHits = new TopDocs[this.nodeVersions.length];
                for (int nodeID = 0; nodeID < this.nodeVersions.length; ++nodeID) {
                    shardHits[nodeID] = nodeID == this.myNodeID ? this.localSearch(query, numHits) : ShardSearchingTestBase.this.searchNode(nodeID, this.nodeVersions, query, null, numHits, null);
                }
                return TopDocs.merge(null, (int)numHits, (TopDocs[])shardHits);
            }

            public TopDocs localSearch(Query query, int numHits) throws IOException {
                return super.search(query, numHits);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TopDocs searchAfter(ScoreDoc after, Query query, int numHits) throws IOException {
                TopDocs[] shardHits = new TopDocs[this.nodeVersions.length];
                ScoreDoc shardAfter = new ScoreDoc(after.doc, after.score);
                for (int nodeID = 0; nodeID < this.nodeVersions.length; ++nodeID) {
                    if (nodeID < after.shardIndex) {
                        ShardIndexSearcher s = ShardSearchingTestBase.this.nodes[nodeID].acquire(this.nodeVersions);
                        try {
                            shardAfter.doc = s.getIndexReader().maxDoc() - 1;
                        }
                        finally {
                            ShardSearchingTestBase.this.nodes[nodeID].release(s);
                        }
                    } else {
                        shardAfter.doc = nodeID == after.shardIndex ? after.doc : -1;
                    }
                    shardHits[nodeID] = nodeID == this.myNodeID ? this.localSearchAfter(shardAfter, query, numHits) : ShardSearchingTestBase.this.searchNode(nodeID, this.nodeVersions, query, null, numHits, shardAfter);
                }
                return TopDocs.merge(null, (int)numHits, (TopDocs[])shardHits);
            }

            public TopDocs localSearchAfter(ScoreDoc after, Query query, int numHits) throws IOException {
                return super.searchAfter(after, query, numHits);
            }

            public TopFieldDocs search(Query query, int numHits, Sort sort) throws IOException {
                assert (sort != null);
                TopDocs[] shardHits = new TopDocs[this.nodeVersions.length];
                for (int nodeID = 0; nodeID < this.nodeVersions.length; ++nodeID) {
                    shardHits[nodeID] = nodeID == this.myNodeID ? this.localSearch(query, numHits, sort) : ShardSearchingTestBase.this.searchNode(nodeID, this.nodeVersions, query, sort, numHits, null);
                }
                return (TopFieldDocs)TopDocs.merge((Sort)sort, (int)numHits, (TopDocs[])shardHits);
            }

            public TopFieldDocs localSearch(Query query, int numHits, Sort sort) throws IOException {
                return super.search(query, numHits, sort);
            }
        }
    }

    private static class TermAndShardVersion {
        private final long version;
        private final int nodeID;
        private final Term term;

        public TermAndShardVersion(int nodeID, long version, Term term) {
            this.nodeID = nodeID;
            this.version = version;
            this.term = term;
        }

        public int hashCode() {
            return (int)(this.version * (long)this.nodeID + (long)this.term.hashCode());
        }

        public boolean equals(Object _other) {
            if (!(_other instanceof TermAndShardVersion)) {
                return false;
            }
            TermAndShardVersion other = (TermAndShardVersion)_other;
            return this.term.equals((Object)other.term) && this.version == other.version && this.nodeID == other.nodeID;
        }
    }

    private static class FieldAndShardVersion {
        private final long version;
        private final int nodeID;
        private final String field;

        public FieldAndShardVersion(int nodeID, long version, String field) {
            this.nodeID = nodeID;
            this.version = version;
            this.field = field;
        }

        public int hashCode() {
            return (int)(this.version * (long)this.nodeID + (long)this.field.hashCode());
        }

        public boolean equals(Object _other) {
            if (!(_other instanceof FieldAndShardVersion)) {
                return false;
            }
            FieldAndShardVersion other = (FieldAndShardVersion)_other;
            return this.field.equals(other.field) && this.version == other.version && this.nodeID == other.nodeID;
        }

        public String toString() {
            return "FieldAndShardVersion(field=" + this.field + " nodeID=" + this.nodeID + " version=" + this.version + ")";
        }
    }

    public static class SearcherExpiredException
    extends RuntimeException {
        public SearcherExpiredException(String message) {
            super(message);
        }
    }
}

