/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.AssertingBulkOutOfOrderScorer;
import org.apache.lucene.search.AssertingBulkScorer;
import org.apache.lucene.search.AssertingScorer;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

class AssertingWeight
extends Weight {
    final boolean scoresDocsOutOfOrder;
    final Random random;
    final Weight in;

    static Weight wrap(Random random, Weight other) {
        return other instanceof AssertingWeight ? other : new AssertingWeight(random, other);
    }

    AssertingWeight(Random random, Weight in) {
        this.random = random;
        this.in = in;
        this.scoresDocsOutOfOrder = in.scoresDocsOutOfOrder() || random.nextBoolean();
    }

    public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
        return this.in.explain(context, doc);
    }

    public Query getQuery() {
        return this.in.getQuery();
    }

    public float getValueForNormalization() throws IOException {
        return this.in.getValueForNormalization();
    }

    public void normalize(float norm, float topLevelBoost) {
        this.in.normalize(norm, topLevelBoost);
    }

    public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        Scorer inScorer = this.in.scorer(context, acceptDocs);
        return AssertingScorer.wrap(new Random(this.random.nextLong()), inScorer);
    }

    public BulkScorer bulkScorer(AtomicReaderContext context, boolean scoreDocsInOrder, Bits acceptDocs) throws IOException {
        BulkScorer inScorer = this.in.bulkScorer(context, scoreDocsInOrder, acceptDocs);
        if (inScorer == null) {
            return null;
        }
        if (AssertingBulkScorer.shouldWrap(inScorer)) {
            inScorer = AssertingBulkScorer.wrap(new Random(this.random.nextLong()), inScorer);
        } else if (this.random.nextBoolean()) {
            inScorer = super.bulkScorer(context, scoreDocsInOrder, acceptDocs);
        }
        if (!scoreDocsInOrder && this.random.nextBoolean()) {
            inScorer = new AssertingBulkOutOfOrderScorer(new Random(this.random.nextLong()), inScorer);
        }
        return inScorer;
    }

    public boolean scoresDocsOutOfOrder() {
        return this.scoresDocsOutOfOrder;
    }
}

