/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.NoLockFactory;

public class MockLockFactoryWrapper
extends LockFactory {
    MockDirectoryWrapper dir;
    LockFactory delegate;

    public MockLockFactoryWrapper(MockDirectoryWrapper dir, LockFactory delegate) {
        this.dir = dir;
        this.delegate = delegate;
    }

    public void setLockPrefix(String lockPrefix) {
        this.delegate.setLockPrefix(lockPrefix);
    }

    public String getLockPrefix() {
        return this.delegate.getLockPrefix();
    }

    public Lock makeLock(String lockName) {
        return new MockLock(this.delegate.makeLock(lockName), lockName);
    }

    public void clearLock(String lockName) throws IOException {
        this.delegate.clearLock(lockName);
        this.dir.openLocks.remove(lockName);
    }

    public String toString() {
        return "MockLockFactoryWrapper(" + this.delegate.toString() + ")";
    }

    private class MockLock
    extends Lock {
        private Lock delegateLock;
        private String name;

        MockLock(Lock delegate, String name) {
            this.delegateLock = delegate;
            this.name = name;
        }

        public boolean obtain() throws IOException {
            if (this.delegateLock.obtain()) {
                assert (MockLockFactoryWrapper.this.delegate instanceof NoLockFactory || !MockLockFactoryWrapper.this.dir.openLocks.containsKey(this.name));
                MockLockFactoryWrapper.this.dir.openLocks.put(this.name, new RuntimeException("lock \"" + this.name + "\" was not released"));
                return true;
            }
            return false;
        }

        public void close() throws IOException {
            this.delegateLock.close();
            MockLockFactoryWrapper.this.dir.openLocks.remove(this.name);
        }

        public boolean isLocked() throws IOException {
            return this.delegateLock.isLocked();
        }
    }
}

