/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.MissingOrdRemapper;
import org.apache.lucene.codecs.lucene40.Lucene40FieldInfosReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

class Lucene40DocValuesWriter
extends DocValuesConsumer {
    private final Directory dir;
    private final SegmentWriteState state;
    private final String legacyKey;
    private static final String segmentSuffix = "dv";

    Lucene40DocValuesWriter(SegmentWriteState state, String filename, String legacyKey) throws IOException {
        this.state = state;
        this.legacyKey = legacyKey;
        this.dir = new CompoundFileDirectory(state.directory, filename, state.context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        block12: {
            IndexOutput data;
            block11: {
                long minValue = Long.MAX_VALUE;
                long maxValue = Long.MIN_VALUE;
                for (Number n : values) {
                    long v = n == null ? 0L : n.longValue();
                    minValue = Math.min(minValue, v);
                    maxValue = Math.max(maxValue, v);
                }
                String fileName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                data = this.dir.createOutput(fileName, this.state.context);
                boolean success = false;
                try {
                    if (minValue >= -128L && maxValue <= 127L && PackedInts.bitsRequired((long)(maxValue - minValue)) > 4) {
                        this.addBytesField(field, data, values);
                    } else if (minValue >= -32768L && maxValue <= 32767L && PackedInts.bitsRequired((long)(maxValue - minValue)) > 8) {
                        this.addShortsField(field, data, values);
                    } else if (minValue >= Integer.MIN_VALUE && maxValue <= Integer.MAX_VALUE && PackedInts.bitsRequired((long)(maxValue - minValue)) > 16) {
                        this.addIntsField(field, data, values);
                    } else {
                        this.addVarIntsField(field, data, values, minValue, maxValue);
                    }
                    success = true;
                    if (!success) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{data});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{data});
                break block12;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data});
        }
    }

    private void addBytesField(FieldInfo field, IndexOutput output, Iterable<Number> values) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.FIXED_INTS_8.name());
        CodecUtil.writeHeader((DataOutput)output, (String)"Ints", (int)0);
        output.writeInt(1);
        for (Number n : values) {
            output.writeByte(n == null ? (byte)0 : n.byteValue());
        }
    }

    private void addShortsField(FieldInfo field, IndexOutput output, Iterable<Number> values) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.FIXED_INTS_16.name());
        CodecUtil.writeHeader((DataOutput)output, (String)"Ints", (int)0);
        output.writeInt(2);
        for (Number n : values) {
            output.writeShort(n == null ? (short)0 : n.shortValue());
        }
    }

    private void addIntsField(FieldInfo field, IndexOutput output, Iterable<Number> values) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.FIXED_INTS_32.name());
        CodecUtil.writeHeader((DataOutput)output, (String)"Ints", (int)0);
        output.writeInt(4);
        for (Number n : values) {
            output.writeInt(n == null ? 0 : n.intValue());
        }
    }

    private void addVarIntsField(FieldInfo field, IndexOutput output, Iterable<Number> values, long minValue, long maxValue) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.VAR_INTS.name());
        CodecUtil.writeHeader((DataOutput)output, (String)"PackedInts", (int)0);
        long delta = maxValue - minValue;
        if (delta < 0L) {
            output.writeByte((byte)1);
            for (Number n : values) {
                output.writeLong(n == null ? 0L : n.longValue());
            }
        } else {
            output.writeByte((byte)0);
            output.writeLong(minValue);
            output.writeLong(0L - minValue);
            PackedInts.Writer writer = PackedInts.getWriter((DataOutput)output, (int)this.state.segmentInfo.getDocCount(), (int)PackedInts.bitsRequired((long)delta), (float)0.25f);
            for (Number n : values) {
                long v = n == null ? 0L : n.longValue();
                writer.add(v - minValue);
            }
            writer.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        block21: {
            IndexOutput index;
            IndexOutput data;
            block19: {
                block22: {
                    IndexOutput data2;
                    block18: {
                        boolean fixed;
                        int minLength;
                        block20: {
                            IndexOutput index2;
                            IndexOutput data3;
                            block17: {
                                boolean dedup;
                                HashSet<BytesRef> uniqueValues = new HashSet<BytesRef>();
                                minLength = Integer.MAX_VALUE;
                                int maxLength = Integer.MIN_VALUE;
                                for (BytesRef b : values) {
                                    if (b == null) {
                                        b = new BytesRef();
                                    }
                                    if (b.length > 32766) {
                                        throw new IllegalArgumentException("DocValuesField \"" + field.name + "\" is too large, must be <= " + 32766);
                                    }
                                    minLength = Math.min(minLength, b.length);
                                    maxLength = Math.max(maxLength, b.length);
                                    if (uniqueValues == null || !uniqueValues.add(BytesRef.deepCopyOf((BytesRef)b)) || uniqueValues.size() <= 256) continue;
                                    uniqueValues = null;
                                }
                                int maxDoc = this.state.segmentInfo.getDocCount();
                                fixed = minLength == maxLength;
                                boolean bl = dedup = uniqueValues != null && uniqueValues.size() * 2 < maxDoc;
                                if (!dedup) break block20;
                                boolean success = false;
                                data3 = null;
                                index2 = null;
                                String dataName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                                String indexName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"idx");
                                try {
                                    data3 = this.dir.createOutput(dataName, this.state.context);
                                    index2 = this.dir.createOutput(indexName, this.state.context);
                                    if (fixed) {
                                        this.addFixedDerefBytesField(field, data3, index2, values, minLength);
                                    } else {
                                        this.addVarDerefBytesField(field, data3, index2, values);
                                    }
                                    success = true;
                                    if (!success) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (success) {
                                        IOUtils.close((Closeable[])new Closeable[]{data3, index2});
                                    } else {
                                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data3, index2});
                                    }
                                    throw throwable;
                                }
                                IOUtils.close((Closeable[])new Closeable[]{data3, index2});
                                break block21;
                            }
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data3, index2});
                            break block21;
                        }
                        if (!fixed) break block22;
                        String fileName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                        data2 = this.dir.createOutput(fileName, this.state.context);
                        boolean success = false;
                        try {
                            this.addFixedStraightBytesField(field, data2, values, minLength);
                            success = true;
                            if (!success) break block18;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close((Closeable[])new Closeable[]{data2});
                            } else {
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data2});
                            }
                            throw throwable;
                        }
                        IOUtils.close((Closeable[])new Closeable[]{data2});
                        break block21;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data2});
                    break block21;
                }
                boolean success = false;
                data = null;
                index = null;
                String dataName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                String indexName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"idx");
                try {
                    data = this.dir.createOutput(dataName, this.state.context);
                    index = this.dir.createOutput(indexName, this.state.context);
                    this.addVarStraightBytesField(field, data, index, values);
                    success = true;
                    if (!success) break block19;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{data, index});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{data, index});
                break block21;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
        }
    }

    private void addFixedStraightBytesField(FieldInfo field, IndexOutput output, Iterable<BytesRef> values, int length) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.BYTES_FIXED_STRAIGHT.name());
        CodecUtil.writeHeader((DataOutput)output, (String)"FixedStraightBytes", (int)0);
        output.writeInt(length);
        for (BytesRef v : values) {
            if (v == null) continue;
            output.writeBytes(v.bytes, v.offset, v.length);
        }
    }

    private void addVarStraightBytesField(FieldInfo field, IndexOutput data, IndexOutput index, Iterable<BytesRef> values) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.BYTES_VAR_STRAIGHT.name());
        CodecUtil.writeHeader((DataOutput)data, (String)"VarStraightBytesDat", (int)0);
        CodecUtil.writeHeader((DataOutput)index, (String)"VarStraightBytesIdx", (int)0);
        long startPos = data.getFilePointer();
        for (BytesRef v : values) {
            if (v == null) continue;
            data.writeBytes(v.bytes, v.offset, v.length);
        }
        long maxAddress = data.getFilePointer() - startPos;
        index.writeVLong(maxAddress);
        int maxDoc = this.state.segmentInfo.getDocCount();
        assert (maxDoc != Integer.MAX_VALUE);
        PackedInts.Writer w = PackedInts.getWriter((DataOutput)index, (int)(maxDoc + 1), (int)PackedInts.bitsRequired((long)maxAddress), (float)0.25f);
        long currentPosition = 0L;
        for (BytesRef v : values) {
            w.add(currentPosition);
            if (v == null) continue;
            currentPosition += (long)v.length;
        }
        assert (currentPosition == maxAddress);
        w.add(currentPosition);
        w.finish();
    }

    private void addFixedDerefBytesField(FieldInfo field, IndexOutput data, IndexOutput index, Iterable<BytesRef> values, int length) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.BYTES_FIXED_DEREF.name());
        CodecUtil.writeHeader((DataOutput)data, (String)"FixedDerefBytesDat", (int)0);
        CodecUtil.writeHeader((DataOutput)index, (String)"FixedDerefBytesIdx", (int)0);
        TreeSet<BytesRef> dictionary = new TreeSet<BytesRef>();
        for (BytesRef v : values) {
            dictionary.add(v == null ? new BytesRef() : BytesRef.deepCopyOf((BytesRef)v));
        }
        data.writeInt(length);
        for (BytesRef v : dictionary) {
            data.writeBytes(v.bytes, v.offset, v.length);
        }
        int valueCount = dictionary.size();
        assert (valueCount > 0);
        index.writeInt(valueCount);
        int maxDoc = this.state.segmentInfo.getDocCount();
        PackedInts.Writer w = PackedInts.getWriter((DataOutput)index, (int)maxDoc, (int)PackedInts.bitsRequired((long)(valueCount - 1)), (float)0.25f);
        for (BytesRef v : values) {
            if (v == null) {
                v = new BytesRef();
            }
            int ord = dictionary.headSet(v).size();
            w.add((long)ord);
        }
        w.finish();
    }

    private void addVarDerefBytesField(FieldInfo field, IndexOutput data, IndexOutput index, Iterable<BytesRef> values) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.BYTES_VAR_DEREF.name());
        CodecUtil.writeHeader((DataOutput)data, (String)"VarDerefBytesDat", (int)0);
        CodecUtil.writeHeader((DataOutput)index, (String)"VarDerefBytesIdx", (int)0);
        TreeSet<BytesRef> dictionary = new TreeSet<BytesRef>();
        for (BytesRef v : values) {
            dictionary.add(v == null ? new BytesRef() : BytesRef.deepCopyOf((BytesRef)v));
        }
        long startPosition = data.getFilePointer();
        long currentAddress = 0L;
        HashMap<BytesRef, Long> valueToAddress = new HashMap<BytesRef, Long>();
        for (BytesRef v : dictionary) {
            currentAddress = data.getFilePointer() - startPosition;
            valueToAddress.put(v, currentAddress);
            Lucene40DocValuesWriter.writeVShort(data, v.length);
            data.writeBytes(v.bytes, v.offset, v.length);
        }
        long totalBytes = data.getFilePointer() - startPosition;
        index.writeLong(totalBytes);
        int maxDoc = this.state.segmentInfo.getDocCount();
        PackedInts.Writer w = PackedInts.getWriter((DataOutput)index, (int)maxDoc, (int)PackedInts.bitsRequired((long)currentAddress), (float)0.25f);
        for (BytesRef v : values) {
            w.add(((Long)valueToAddress.get(v == null ? new BytesRef() : v)).longValue());
        }
        w.finish();
    }

    private static void writeVShort(IndexOutput o, int i) throws IOException {
        assert (i >= 0 && i <= Short.MAX_VALUE);
        if (i < 128) {
            o.writeByte((byte)i);
        } else {
            o.writeByte((byte)(0x80 | i >> 8));
            o.writeByte((byte)(i & 0xFF));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        block13: {
            IndexOutput index;
            IndexOutput data;
            block12: {
                int minLength = Integer.MAX_VALUE;
                int maxLength = Integer.MIN_VALUE;
                for (BytesRef b : values) {
                    minLength = Math.min(minLength, b.length);
                    maxLength = Math.max(maxLength, b.length);
                }
                boolean anyMissing = false;
                for (Number n : docToOrd) {
                    if (n.longValue() != -1L) continue;
                    anyMissing = true;
                    break;
                }
                boolean success = false;
                data = null;
                index = null;
                String dataName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                String indexName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"idx");
                try {
                    data = this.dir.createOutput(dataName, this.state.context);
                    index = this.dir.createOutput(indexName, this.state.context);
                    if (minLength == maxLength && !anyMissing) {
                        this.addFixedSortedBytesField(field, data, index, values, docToOrd, minLength);
                    } else if (!anyMissing) {
                        this.addVarSortedBytesField(field, data, index, values, docToOrd);
                    } else if (minLength == 0) {
                        this.addVarSortedBytesField(field, data, index, values, MissingOrdRemapper.mapMissingToOrd0(docToOrd));
                    } else {
                        this.addVarSortedBytesField(field, data, index, MissingOrdRemapper.insertEmptyValue(values), MissingOrdRemapper.mapAllOrds(docToOrd));
                    }
                    success = true;
                    if (!success) break block12;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{data, index});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{data, index});
                break block13;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
        }
    }

    private void addFixedSortedBytesField(FieldInfo field, IndexOutput data, IndexOutput index, Iterable<BytesRef> values, Iterable<Number> docToOrd, int length) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.BYTES_FIXED_SORTED.name());
        CodecUtil.writeHeader((DataOutput)data, (String)"FixedSortedBytesDat", (int)0);
        CodecUtil.writeHeader((DataOutput)index, (String)"FixedSortedBytesIdx", (int)0);
        data.writeInt(length);
        int valueCount = 0;
        for (BytesRef v : values) {
            data.writeBytes(v.bytes, v.offset, v.length);
            ++valueCount;
        }
        index.writeInt(valueCount);
        int maxDoc = this.state.segmentInfo.getDocCount();
        assert (valueCount > 0);
        PackedInts.Writer w = PackedInts.getWriter((DataOutput)index, (int)maxDoc, (int)PackedInts.bitsRequired((long)(valueCount - 1)), (float)0.25f);
        for (Number n : docToOrd) {
            w.add(n.longValue());
        }
        w.finish();
    }

    private void addVarSortedBytesField(FieldInfo field, IndexOutput data, IndexOutput index, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        field.putAttribute(this.legacyKey, Lucene40FieldInfosReader.LegacyDocValuesType.BYTES_VAR_SORTED.name());
        CodecUtil.writeHeader((DataOutput)data, (String)"VarDerefBytesDat", (int)0);
        CodecUtil.writeHeader((DataOutput)index, (String)"VarDerefBytesIdx", (int)0);
        long startPos = data.getFilePointer();
        int valueCount = 0;
        for (BytesRef v : values) {
            data.writeBytes(v.bytes, v.offset, v.length);
            ++valueCount;
        }
        long maxAddress = data.getFilePointer() - startPos;
        index.writeLong(maxAddress);
        assert (valueCount != Integer.MAX_VALUE);
        PackedInts.Writer w = PackedInts.getWriter((DataOutput)index, (int)(valueCount + 1), (int)PackedInts.bitsRequired((long)maxAddress), (float)0.25f);
        long currentPosition = 0L;
        for (BytesRef v : values) {
            w.add(currentPosition);
            currentPosition += (long)v.length;
        }
        assert (currentPosition == maxAddress);
        w.add(currentPosition);
        w.finish();
        int maxDoc = this.state.segmentInfo.getDocCount();
        assert (valueCount > 0);
        PackedInts.Writer ords = PackedInts.getWriter((DataOutput)index, (int)maxDoc, (int)PackedInts.bitsRequired((long)(valueCount - 1)), (float)0.25f);
        for (Number n : docToOrd) {
            ords.add(n.longValue());
        }
        ords.finish();
    }

    public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException("Lucene 4.0 does not support SortedNumeric docvalues");
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        throw new UnsupportedOperationException("Lucene 4.0 does not support SortedSet docvalues");
    }

    public void close() throws IOException {
        this.dir.close();
    }
}

