/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.codecs.lucene41.Lucene41PostingsFormat;
import org.apache.lucene.index.AssertingAtomicReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.OpenBitSet;

public final class AssertingPostingsFormat
extends PostingsFormat {
    private final PostingsFormat in = new Lucene41PostingsFormat();

    public AssertingPostingsFormat() {
        super("Asserting");
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new AssertingFieldsConsumer(this.in.fieldsConsumer(state));
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new AssertingFieldsProducer(this.in.fieldsProducer(state));
    }

    static class AssertingPostingsConsumer
    extends PostingsConsumer {
        private final PostingsConsumer in;
        private final FieldInfo fieldInfo;
        private final OpenBitSet visitedDocs;
        private PostingsConsumerState state = PostingsConsumerState.INITIAL;
        private int freq;
        private int positionCount;
        private int lastPosition = 0;
        private int lastStartOffset = 0;
        int docFreq = 0;
        long totalTermFreq = 0L;

        AssertingPostingsConsumer(PostingsConsumer in, FieldInfo fieldInfo, OpenBitSet visitedDocs) {
            this.in = in;
            this.fieldInfo = fieldInfo;
            this.visitedDocs = visitedDocs;
        }

        public void startDoc(int docID, int freq) throws IOException {
            assert (this.state == PostingsConsumerState.INITIAL);
            this.state = PostingsConsumerState.START;
            assert (docID >= 0);
            if (this.fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) {
                assert (freq == -1);
                this.freq = 0;
            } else {
                assert (freq > 0);
                this.freq = freq;
                this.totalTermFreq += (long)freq;
            }
            this.positionCount = 0;
            this.lastPosition = 0;
            this.lastStartOffset = 0;
            ++this.docFreq;
            this.visitedDocs.set((long)docID);
            this.in.startDoc(docID, freq);
        }

        public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
            assert (this.state == PostingsConsumerState.START);
            assert (this.positionCount < this.freq);
            ++this.positionCount;
            assert (position >= this.lastPosition || position == -1);
            this.lastPosition = position;
            if (this.fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
                assert (startOffset >= 0);
                assert (startOffset >= this.lastStartOffset);
                this.lastStartOffset = startOffset;
                assert (endOffset >= startOffset);
            } else {
                assert (startOffset == -1);
                assert (endOffset == -1);
            }
            if (payload != null) assert (this.fieldInfo.hasPayloads());
            this.in.addPosition(position, payload, startOffset, endOffset);
        }

        public void finishDoc() throws IOException {
            assert (this.state == PostingsConsumerState.START);
            this.state = PostingsConsumerState.INITIAL;
            if (this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0 ? !$assertionsDisabled && this.positionCount != 0 : !$assertionsDisabled && this.positionCount != this.freq) {
                throw new AssertionError();
            }
            this.in.finishDoc();
        }
    }

    static enum PostingsConsumerState {
        INITIAL,
        START;

    }

    static class AssertingTermsConsumer
    extends TermsConsumer {
        private final TermsConsumer in;
        private final FieldInfo fieldInfo;
        private BytesRef lastTerm = null;
        private TermsConsumerState state = TermsConsumerState.INITIAL;
        private AssertingPostingsConsumer lastPostingsConsumer = null;
        private long sumTotalTermFreq = 0L;
        private long sumDocFreq = 0L;
        private OpenBitSet visitedDocs = new OpenBitSet();

        AssertingTermsConsumer(TermsConsumer in, FieldInfo fieldInfo) {
            this.in = in;
            this.fieldInfo = fieldInfo;
        }

        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            assert (this.state == TermsConsumerState.INITIAL || this.state == TermsConsumerState.START && this.lastPostingsConsumer.docFreq == 0);
            this.state = TermsConsumerState.START;
            assert (this.lastTerm == null || this.in.getComparator().compare(text, this.lastTerm) > 0);
            this.lastTerm = BytesRef.deepCopyOf((BytesRef)text);
            this.lastPostingsConsumer = new AssertingPostingsConsumer(this.in.startTerm(text), this.fieldInfo, this.visitedDocs);
            return this.lastPostingsConsumer;
        }

        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            assert (this.state == TermsConsumerState.START);
            this.state = TermsConsumerState.INITIAL;
            assert (text.equals((Object)this.lastTerm));
            assert (stats.docFreq > 0);
            assert (stats.docFreq == this.lastPostingsConsumer.docFreq);
            this.sumDocFreq += (long)stats.docFreq;
            if (this.fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) {
                assert (stats.totalTermFreq == -1L);
            } else {
                assert (stats.totalTermFreq == this.lastPostingsConsumer.totalTermFreq);
                this.sumTotalTermFreq += stats.totalTermFreq;
            }
            this.in.finishTerm(text, stats);
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            assert (this.state == TermsConsumerState.INITIAL || this.state == TermsConsumerState.START && this.lastPostingsConsumer.docFreq == 0);
            this.state = TermsConsumerState.FINISHED;
            assert (docCount >= 0);
            assert ((long)docCount == this.visitedDocs.cardinality());
            assert (sumDocFreq >= (long)docCount);
            assert (sumDocFreq == this.sumDocFreq);
            if (this.fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) {
                assert (sumTotalTermFreq == -1L);
            } else {
                assert (sumTotalTermFreq >= sumDocFreq);
                assert (sumTotalTermFreq == this.sumTotalTermFreq);
            }
            this.in.finish(sumTotalTermFreq, sumDocFreq, docCount);
        }

        public Comparator<BytesRef> getComparator() throws IOException {
            return this.in.getComparator();
        }
    }

    static enum TermsConsumerState {
        INITIAL,
        START,
        FINISHED;

    }

    static class AssertingFieldsConsumer
    extends FieldsConsumer {
        private final FieldsConsumer in;

        AssertingFieldsConsumer(FieldsConsumer in) {
            this.in = in;
        }

        public TermsConsumer addField(FieldInfo field) throws IOException {
            TermsConsumer consumer = this.in.addField(field);
            assert (consumer != null);
            return new AssertingTermsConsumer(consumer, field);
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    static class AssertingFieldsProducer
    extends FieldsProducer {
        private final FieldsProducer in;

        AssertingFieldsProducer(FieldsProducer in) {
            this.in = in;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public Iterator<String> iterator() {
            Iterator iterator = this.in.iterator();
            assert (iterator != null);
            return iterator;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            return terms == null ? null : new AssertingAtomicReader.AssertingTerms(terms);
        }

        public int size() {
            return this.in.size();
        }

        public long getUniqueTermCount() throws IOException {
            return this.in.getUniqueTermCount();
        }

        public long ramBytesUsed() {
            return this.in.ramBytesUsed();
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }
    }
}

