/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.RollingBuffer;

public abstract class LookaheadTokenFilter<T extends Position>
extends TokenFilter {
    private static final boolean DEBUG = false;
    protected final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    protected final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    protected final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    protected int inputPos;
    protected int outputPos;
    protected boolean end;
    private boolean tokenPending;
    private boolean insertPending;
    protected final RollingBuffer<T> positions = new RollingBuffer<T>(){

        @Override
        protected T newInstance() {
            return LookaheadTokenFilter.this.newPosition();
        }
    };

    protected LookaheadTokenFilter(TokenStream input) {
        super(input);
    }

    protected void insertToken() throws IOException {
        if (this.tokenPending) {
            ((Position)this.positions.get(this.inputPos)).add(this.captureState());
            this.tokenPending = false;
        }
        assert (!this.insertPending);
        this.insertPending = true;
    }

    protected void afterPosition() throws IOException {
    }

    protected abstract T newPosition();

    protected boolean peekToken() throws IOException {
        boolean gotToken;
        assert (!this.end);
        assert (this.inputPos == -1 || this.outputPos <= this.inputPos);
        if (this.tokenPending) {
            ((Position)this.positions.get(this.inputPos)).add(this.captureState());
            this.tokenPending = false;
        }
        if (gotToken = this.input.incrementToken()) {
            this.inputPos += this.posIncAtt.getPositionIncrement();
            assert (this.inputPos >= 0);
            Position startPosData = (Position)this.positions.get(this.inputPos);
            Position endPosData = (Position)this.positions.get(this.inputPos + this.posLenAtt.getPositionLength());
            int startOffset = this.offsetAtt.startOffset();
            if (startPosData.startOffset == -1) {
                startPosData.startOffset = startOffset;
            } else assert (startPosData.startOffset == startOffset) : "prev startOffset=" + startPosData.startOffset + " vs new startOffset=" + startOffset + " inputPos=" + this.inputPos;
            int endOffset = this.offsetAtt.endOffset();
            if (endPosData.endOffset == -1) {
                endPosData.endOffset = endOffset;
            } else assert (endPosData.endOffset == endOffset) : "prev endOffset=" + endPosData.endOffset + " vs new endOffset=" + endOffset + " inputPos=" + this.inputPos;
            this.tokenPending = true;
        } else {
            this.end = true;
        }
        return gotToken;
    }

    protected boolean nextToken() throws IOException {
        Position posData = (Position)this.positions.get(this.outputPos);
        while (true) {
            if (posData.nextRead < posData.inputTokens.size()) {
                if (this.tokenPending) {
                    ((Position)this.positions.get(this.inputPos)).add(this.captureState());
                    this.tokenPending = false;
                }
                this.restoreState(((Position)this.positions.get(this.outputPos)).nextState());
                return true;
            }
            if (this.inputPos == -1 || this.outputPos == this.inputPos) {
                if (this.tokenPending) {
                    this.tokenPending = false;
                    return true;
                }
                if (!this.end && this.peekToken()) continue;
                return false;
            }
            if (posData.startOffset != -1) {
                this.afterPosition();
                if (this.insertPending) {
                    assert (this.insertedTokenConsistent());
                    this.insertPending = false;
                    return true;
                }
            }
            ++this.outputPos;
            this.positions.freeBefore(this.outputPos);
            posData = (Position)this.positions.get(this.outputPos);
        }
    }

    private boolean insertedTokenConsistent() {
        int posLen = this.posLenAtt.getPositionLength();
        Position endPosData = (Position)this.positions.get(this.outputPos + posLen);
        assert (endPosData.endOffset != -1);
        assert (this.offsetAtt.endOffset() == endPosData.endOffset);
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.positions.reset();
        this.inputPos = -1;
        this.outputPos = 0;
        this.tokenPending = false;
        this.end = false;
    }

    protected static class Position
    implements RollingBuffer.Resettable {
        public final List<AttributeSource.State> inputTokens = new ArrayList<AttributeSource.State>();
        public int nextRead;
        public int startOffset = -1;
        public int endOffset = -1;

        protected Position() {
        }

        @Override
        public void reset() {
            this.inputTokens.clear();
            this.nextRead = 0;
            this.startOffset = -1;
            this.endOffset = -1;
        }

        public void add(AttributeSource.State state) {
            this.inputTokens.add(state);
        }

        public AttributeSource.State nextState() {
            assert (this.nextRead < this.inputTokens.size());
            return this.inputTokens.get(this.nextRead++);
        }
    }
}

