/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;

public final class CannedTokenStream
extends TokenStream {
    private final Token[] tokens;
    private int upto = 0;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);

    public CannedTokenStream(Token ... tokens) {
        this.tokens = tokens;
    }

    public boolean incrementToken() throws IOException {
        if (this.upto < this.tokens.length) {
            Token token = this.tokens[this.upto++];
            this.clearAttributes();
            this.termAtt.setEmpty();
            this.termAtt.append(token.toString());
            this.posIncrAtt.setPositionIncrement(token.getPositionIncrement());
            this.posLengthAtt.setPositionLength(token.getPositionLength());
            this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
            this.payloadAtt.setPayload(token.getPayload());
            return true;
        }
        return false;
    }
}

