/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocHelper {
    public static final String FIELD_1_TEXT = "field one text";
    public static final String TEXT_FIELD_1_KEY = "textField1";
    public static Field textField1 = new Field("textField1", "field one text", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO);
    public static final String FIELD_2_TEXT = "field field field two text";
    public static final int[] FIELD_2_FREQS = new int[]{3, 1, 1};
    public static final String TEXT_FIELD_2_KEY = "textField2";
    public static Field textField2 = new Field("textField2", "field field field two text", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS);
    public static final String FIELD_3_TEXT = "aaaNoNorms aaaNoNorms bbbNoNorms";
    public static final String TEXT_FIELD_3_KEY = "textField3";
    public static Field textField3 = new Field("textField3", "aaaNoNorms aaaNoNorms bbbNoNorms", Field.Store.YES, Field.Index.ANALYZED);
    public static final String KEYWORD_TEXT = "Keyword";
    public static final String KEYWORD_FIELD_KEY = "keyField";
    public static Field keyField;
    public static final String NO_NORMS_TEXT = "omitNormsText";
    public static final String NO_NORMS_KEY = "omitNorms";
    public static Field noNormsField;
    public static final String NO_TF_TEXT = "analyzed with no tf and positions";
    public static final String NO_TF_KEY = "omitTermFreqAndPositions";
    public static Field noTFField;
    public static final String UNINDEXED_FIELD_TEXT = "unindexed field text";
    public static final String UNINDEXED_FIELD_KEY = "unIndField";
    public static Field unIndField;
    public static final String UNSTORED_1_FIELD_TEXT = "unstored field text";
    public static final String UNSTORED_FIELD_1_KEY = "unStoredField1";
    public static Field unStoredField1;
    public static final String UNSTORED_2_FIELD_TEXT = "unstored field text";
    public static final String UNSTORED_FIELD_2_KEY = "unStoredField2";
    public static Field unStoredField2;
    public static final String LAZY_FIELD_BINARY_KEY = "lazyFieldBinary";
    public static byte[] LAZY_FIELD_BINARY_BYTES;
    public static Field lazyFieldBinary;
    public static final String LAZY_FIELD_KEY = "lazyField";
    public static final String LAZY_FIELD_TEXT = "These are some field bytes";
    public static Field lazyField;
    public static final String LARGE_LAZY_FIELD_KEY = "largeLazyField";
    public static String LARGE_LAZY_FIELD_TEXT;
    public static Field largeLazyField;
    public static final String FIELD_UTF1_TEXT = "field one \u4e00text";
    public static final String TEXT_FIELD_UTF1_KEY = "textField1Utf8";
    public static Field textUtfField1;
    public static final String FIELD_UTF2_TEXT = "field field field \u4e00two text";
    public static final int[] FIELD_UTF2_FREQS;
    public static final String TEXT_FIELD_UTF2_KEY = "textField2Utf8";
    public static Field textUtfField2;
    public static Map<String, Object> nameValues;
    public static Field[] fields;
    public static Map<String, Fieldable> all;
    public static Map<String, Fieldable> indexed;
    public static Map<String, Fieldable> stored;
    public static Map<String, Fieldable> unstored;
    public static Map<String, Fieldable> unindexed;
    public static Map<String, Fieldable> termvector;
    public static Map<String, Fieldable> notermvector;
    public static Map<String, Fieldable> lazy;
    public static Map<String, Fieldable> noNorms;
    public static Map<String, Fieldable> noTf;

    DocHelper() {
    }

    private static void add(Map<String, Fieldable> map, Fieldable field) {
        map.put(field.name(), field);
    }

    public static void setupDoc(Document doc) {
        for (int i = 0; i < fields.length; ++i) {
            doc.add((Fieldable)fields[i]);
        }
    }

    public static SegmentInfo writeDoc(Random random, Directory dir, Document doc) throws IOException {
        return DocHelper.writeDoc(random, dir, new MockAnalyzer(random, 0, false), null, doc);
    }

    public static SegmentInfo writeDoc(Random random, Directory dir, Analyzer analyzer, Similarity similarity, Document doc) throws IOException {
        IndexWriter writer = new IndexWriter(dir, new IndexWriterConfig(LuceneTestCase.TEST_VERSION_CURRENT, analyzer).setSimilarity(similarity));
        writer.addDocument(doc);
        writer.commit();
        SegmentInfo info = writer.newestSegment();
        writer.close();
        return info;
    }

    public static int numFields(Document doc) {
        return doc.getFields().size();
    }

    public static Document createDocument(int n, String indexName, int numFields) {
        StringBuilder sb = new StringBuilder();
        Document doc = new Document();
        doc.add((Fieldable)new Field("id", Integer.toString(n), Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        doc.add((Fieldable)new Field("indexname", indexName, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        sb.append("a");
        sb.append(n);
        doc.add((Fieldable)new Field("field1", sb.toString(), Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        sb.append(" b");
        sb.append(n);
        for (int i = 1; i < numFields; ++i) {
            doc.add((Fieldable)new Field("field" + (i + 1), sb.toString(), Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        }
        return doc;
    }

    static {
        textField3.setOmitNorms(true);
        keyField = new Field(KEYWORD_FIELD_KEY, KEYWORD_TEXT, Field.Store.YES, Field.Index.NOT_ANALYZED);
        noNormsField = new Field(NO_NORMS_KEY, NO_NORMS_TEXT, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        noTFField = new Field(NO_TF_KEY, NO_TF_TEXT, Field.Store.YES, Field.Index.ANALYZED);
        noTFField.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        unIndField = new Field(UNINDEXED_FIELD_KEY, UNINDEXED_FIELD_TEXT, Field.Store.YES, Field.Index.NO);
        unStoredField1 = new Field(UNSTORED_FIELD_1_KEY, "unstored field text", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
        unStoredField2 = new Field(UNSTORED_FIELD_2_KEY, "unstored field text", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES);
        lazyField = new Field(LAZY_FIELD_KEY, LAZY_FIELD_TEXT, Field.Store.YES, Field.Index.ANALYZED);
        textUtfField1 = new Field(TEXT_FIELD_UTF1_KEY, FIELD_UTF1_TEXT, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO);
        FIELD_UTF2_FREQS = new int[]{3, 1, 1};
        textUtfField2 = new Field(TEXT_FIELD_UTF2_KEY, FIELD_UTF2_TEXT, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS);
        nameValues = null;
        fields = new Field[]{textField1, textField2, textField3, keyField, noNormsField, noTFField, unIndField, unStoredField1, unStoredField2, textUtfField1, textUtfField2, lazyField, lazyFieldBinary, largeLazyField};
        all = new HashMap<String, Fieldable>();
        indexed = new HashMap<String, Fieldable>();
        stored = new HashMap<String, Fieldable>();
        unstored = new HashMap<String, Fieldable>();
        unindexed = new HashMap<String, Fieldable>();
        termvector = new HashMap<String, Fieldable>();
        notermvector = new HashMap<String, Fieldable>();
        lazy = new HashMap<String, Fieldable>();
        noNorms = new HashMap<String, Fieldable>();
        noTf = new HashMap<String, Fieldable>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            buffer.append("Lazily loading lengths of language in lieu of laughing ");
        }
        try {
            LAZY_FIELD_BINARY_BYTES = "These are some binary field bytes".getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        DocHelper.fields[DocHelper.fields.length - 2] = lazyFieldBinary = new Field(LAZY_FIELD_BINARY_KEY, LAZY_FIELD_BINARY_BYTES);
        LARGE_LAZY_FIELD_TEXT = buffer.toString();
        DocHelper.fields[DocHelper.fields.length - 1] = largeLazyField = new Field(LARGE_LAZY_FIELD_KEY, LARGE_LAZY_FIELD_TEXT, Field.Store.YES, Field.Index.ANALYZED);
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            DocHelper.add(all, (Fieldable)f);
            if (f.isIndexed()) {
                DocHelper.add(indexed, (Fieldable)f);
            } else {
                DocHelper.add(unindexed, (Fieldable)f);
            }
            if (f.isTermVectorStored()) {
                DocHelper.add(termvector, (Fieldable)f);
            }
            if (f.isIndexed() && !f.isTermVectorStored()) {
                DocHelper.add(notermvector, (Fieldable)f);
            }
            if (f.isStored()) {
                DocHelper.add(stored, (Fieldable)f);
            } else {
                DocHelper.add(unstored, (Fieldable)f);
            }
            if (f.getOmitNorms()) {
                DocHelper.add(noNorms, (Fieldable)f);
            }
            if (f.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) {
                DocHelper.add(noTf, (Fieldable)f);
            }
            if (!f.isLazy()) continue;
            DocHelper.add(lazy, (Fieldable)f);
        }
        nameValues = new HashMap<String, Object>();
        nameValues.put(TEXT_FIELD_1_KEY, FIELD_1_TEXT);
        nameValues.put(TEXT_FIELD_2_KEY, FIELD_2_TEXT);
        nameValues.put(TEXT_FIELD_3_KEY, FIELD_3_TEXT);
        nameValues.put(KEYWORD_FIELD_KEY, KEYWORD_TEXT);
        nameValues.put(NO_NORMS_KEY, NO_NORMS_TEXT);
        nameValues.put(NO_TF_KEY, NO_TF_TEXT);
        nameValues.put(UNINDEXED_FIELD_KEY, UNINDEXED_FIELD_TEXT);
        nameValues.put(UNSTORED_FIELD_1_KEY, "unstored field text");
        nameValues.put(UNSTORED_FIELD_2_KEY, "unstored field text");
        nameValues.put(LAZY_FIELD_KEY, LAZY_FIELD_TEXT);
        nameValues.put(LAZY_FIELD_BINARY_KEY, LAZY_FIELD_BINARY_BYTES);
        nameValues.put(LARGE_LAZY_FIELD_KEY, LARGE_LAZY_FIELD_TEXT);
        nameValues.put(TEXT_FIELD_UTF1_KEY, FIELD_UTF1_TEXT);
        nameValues.put(TEXT_FIELD_UTF2_KEY, FIELD_UTF2_TEXT);
    }
}

