/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ThreadInterruptedException;

public class ThrottledIndexOutput
extends IndexOutput {
    public static final int DEFAULT_MIN_WRITTEN_BYTES = 1024;
    private final int bytesPerSecond;
    private IndexOutput delegate;
    private long flushDelayMillis;
    private long closeDelayMillis;
    private long seekDelayMillis;
    private long pendingBytes;
    private long minBytesWritten;
    private long timeElapsed;
    private final byte[] bytes = new byte[1];

    public ThrottledIndexOutput newFromDelegate(IndexOutput output) {
        return new ThrottledIndexOutput(this.bytesPerSecond, this.flushDelayMillis, this.closeDelayMillis, this.seekDelayMillis, this.minBytesWritten, output);
    }

    public ThrottledIndexOutput(int bytesPerSecond, long delayInMillis, IndexOutput delegate) {
        this(bytesPerSecond, delayInMillis, delayInMillis, delayInMillis, 1024L, delegate);
    }

    public ThrottledIndexOutput(int bytesPerSecond, long delays, int minBytesWritten, IndexOutput delegate) {
        this(bytesPerSecond, delays, delays, delays, minBytesWritten, delegate);
    }

    public static final int mBitsToBytes(int mbits) {
        return mbits * 125000;
    }

    public ThrottledIndexOutput(int bytesPerSecond, long flushDelayMillis, long closeDelayMillis, long seekDelayMillis, long minBytesWritten, IndexOutput delegate) {
        assert (bytesPerSecond > 0);
        this.delegate = delegate;
        this.bytesPerSecond = bytesPerSecond;
        this.flushDelayMillis = flushDelayMillis;
        this.closeDelayMillis = closeDelayMillis;
        this.seekDelayMillis = seekDelayMillis;
        this.minBytesWritten = minBytesWritten;
    }

    public void flush() throws IOException {
        ThrottledIndexOutput.sleep(this.flushDelayMillis);
        this.delegate.flush();
    }

    public void close() throws IOException {
        ThrottledIndexOutput.sleep(this.closeDelayMillis + this.getDelay(true));
        this.delegate.close();
    }

    public long getFilePointer() {
        return this.delegate.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        ThrottledIndexOutput.sleep(this.seekDelayMillis);
        this.delegate.seek(pos);
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public void writeByte(byte b) throws IOException {
        this.bytes[0] = b;
        this.writeBytes(this.bytes, 0, 1);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        long before = System.nanoTime();
        this.delegate.writeBytes(b, offset, length);
        this.timeElapsed += System.nanoTime() - before;
        this.pendingBytes += (long)length;
        ThrottledIndexOutput.sleep(this.getDelay(false));
    }

    protected long getDelay(boolean closing) {
        long actualBps;
        if (this.pendingBytes > 0L && (closing || this.pendingBytes > this.minBytesWritten) && (actualBps = this.timeElapsed / this.pendingBytes * 1000000000L) > (long)this.bytesPerSecond) {
            long expected = this.pendingBytes * 1000L / (long)this.bytesPerSecond;
            long delay = expected - this.timeElapsed / 1000000L;
            this.pendingBytes = 0L;
            this.timeElapsed = 0L;
            return delay;
        }
        return 0L;
    }

    private static final void sleep(long ms) {
        if (ms <= 0L) {
            return;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(e);
        }
    }

    public void setLength(long length) throws IOException {
        this.delegate.setLength(length);
    }

    public void copyBytes(IndexInput input, long numBytes) throws IOException {
        this.delegate.copyBytes(input, numBytes);
    }
}

