/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.util._TestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockRandomMergePolicy
extends MergePolicy {
    private final Random random;

    public MockRandomMergePolicy(Random random) {
        this.random = new Random(random.nextLong());
    }

    public MergePolicy.MergeSpecification findMerges(SegmentInfos segmentInfos) {
        MergePolicy.MergeSpecification mergeSpec = null;
        if (segmentInfos.size() > 1 && this.random.nextInt(5) == 3) {
            ArrayList segments = new ArrayList(segmentInfos.asList());
            Collections.shuffle(segments, this.random);
            mergeSpec = new MergePolicy.MergeSpecification();
            int segsToMerge = _TestUtil.nextInt(this.random, 1, segmentInfos.size());
            mergeSpec.add(new MergePolicy.OneMerge(segments.subList(0, segsToMerge)));
        }
        return mergeSpec;
    }

    public MergePolicy.MergeSpecification findMergesForOptimize(SegmentInfos segmentInfos, int maxSegmentCount, Set<SegmentInfo> segmentsToOptimize) throws CorruptIndexException, IOException {
        ArrayList<SegmentInfo> eligibleSegments = new ArrayList<SegmentInfo>();
        for (SegmentInfo info : segmentInfos) {
            if (!segmentsToOptimize.contains(info)) continue;
            eligibleSegments.add(info);
        }
        MergePolicy.MergeSpecification mergeSpec = null;
        if (eligibleSegments.size() > 1 || eligibleSegments.size() == 1 && ((SegmentInfo)eligibleSegments.get(0)).hasDeletions()) {
            int inc;
            mergeSpec = new MergePolicy.MergeSpecification();
            Collections.shuffle(eligibleSegments, this.random);
            for (int upto = 0; upto < eligibleSegments.size(); upto += inc) {
                int max = Math.min(10, eligibleSegments.size() - upto);
                inc = max <= 2 ? max : _TestUtil.nextInt(this.random, 2, max);
                mergeSpec.add(new MergePolicy.OneMerge(eligibleSegments.subList(upto, upto + inc)));
            }
        }
        if (mergeSpec != null) {
            for (MergePolicy.OneMerge merge : mergeSpec.merges) {
                for (SegmentInfo info : merge.segments) {
                    assert (segmentsToOptimize.contains(info));
                }
            }
        }
        return mergeSpec;
    }

    public MergePolicy.MergeSpecification findMergesToExpungeDeletes(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
        return this.findMerges(segmentInfos);
    }

    public void close() {
    }

    public boolean useCompoundFile(SegmentInfos infos, SegmentInfo mergedInfo) throws IOException {
        return this.random.nextInt(5) != 1;
    }
}

