/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockFixedLengthPayloadFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.MockVariableLengthPayloadFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.LuceneTestCase;

public final class MockAnalyzer
extends Analyzer {
    private final int pattern;
    private final boolean lowerCase;
    private final CharArraySet filter;
    private final boolean enablePositionIncrements;
    private int positionIncrementGap;
    private final Random random;
    private Map<String, Integer> previousMappings = new HashMap<String, Integer>();
    private boolean enableChecks = true;

    public MockAnalyzer(Random random, int pattern, boolean lowerCase, CharArraySet filter, boolean enablePositionIncrements) {
        this.random = random;
        this.pattern = pattern;
        this.lowerCase = lowerCase;
        this.filter = filter;
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public MockAnalyzer(Random random, int pattern, boolean lowerCase) {
        this(random, pattern, lowerCase, CharArraySet.EMPTY_SET, false);
    }

    public MockAnalyzer(Random random) {
        this(random, 0, true);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        MockTokenizer tokenizer = new MockTokenizer(reader, this.pattern, this.lowerCase);
        tokenizer.setEnableChecks(this.enableChecks);
        StopFilter filt = new StopFilter(LuceneTestCase.TEST_VERSION_CURRENT, (TokenStream)tokenizer, (Set)this.filter);
        filt.setEnablePositionIncrements(this.enablePositionIncrements);
        return this.maybePayload((TokenFilter)filt, fieldName);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams saved;
        HashMap<String, SavedStreams> map = (HashMap<String, SavedStreams>)this.getPreviousTokenStream();
        if (map == null) {
            map = new HashMap<String, SavedStreams>();
            this.setPreviousTokenStream(map);
        }
        if ((saved = (SavedStreams)map.get(fieldName)) == null) {
            saved = new SavedStreams();
            saved.tokenizer = new MockTokenizer(reader, this.pattern, this.lowerCase);
            saved.tokenizer.setEnableChecks(this.enableChecks);
            StopFilter filt = new StopFilter(LuceneTestCase.TEST_VERSION_CURRENT, (TokenStream)saved.tokenizer, (Set)this.filter);
            filt.setEnablePositionIncrements(this.enablePositionIncrements);
            saved.filter = filt;
            saved.filter = this.maybePayload(saved.filter, fieldName);
            map.put(fieldName, saved);
            return saved.filter;
        }
        saved.tokenizer.reset(reader);
        return saved.filter;
    }

    private synchronized TokenFilter maybePayload(TokenFilter stream, String fieldName) {
        Integer val = this.previousMappings.get(fieldName);
        if (val == null) {
            switch (this.random.nextInt(3)) {
                case 0: {
                    val = -1;
                    break;
                }
                case 1: {
                    val = Integer.MAX_VALUE;
                    break;
                }
                case 2: {
                    val = this.random.nextInt(12);
                }
            }
            this.previousMappings.put(fieldName, val);
        }
        if (val == -1) {
            return stream;
        }
        if (val == Integer.MAX_VALUE) {
            return new MockVariableLengthPayloadFilter(this.random, (TokenStream)stream);
        }
        return new MockFixedLengthPayloadFilter(this.random, (TokenStream)stream, val);
    }

    public void setPositionIncrementGap(int positionIncrementGap) {
        this.positionIncrementGap = positionIncrementGap;
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.positionIncrementGap;
    }

    public void setEnableChecks(boolean enableChecks) {
        this.enableChecks = enableChecks;
    }

    private class SavedStreams {
        MockTokenizer tokenizer;
        TokenFilter filter;

        private SavedStreams() {
        }
    }
}

