/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.FieldCacheSanityChecker;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.Version;
import org.apache.lucene.util._TestUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatchman;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=LuceneTestCaseRunner.class)
public abstract class LuceneTestCase
extends Assert {
    public static final boolean VERBOSE = Boolean.getBoolean("tests.verbose");
    public static final Version TEST_VERSION_CURRENT = Version.LUCENE_31;
    static final String TEST_METHOD;
    public static final File TEMP_DIR;
    public static final String TEST_LOCALE;
    public static final String TEST_TIMEZONE;
    public static final String TEST_DIRECTORY;
    public static final int TEST_ITER;
    public static final String TEST_SEED;
    public static final boolean TEST_NIGHTLY;
    public static final String TEST_LINE_DOCS_FILE;
    public static final String TEST_CLEAN_THREADS;
    public static final int RANDOM_MULTIPLIER;
    private int savedBoolMaxClauseCount;
    private volatile Thread.UncaughtExceptionHandler savedUncaughtExceptionHandler = null;
    private boolean setup;
    private List<UncaughtExceptionEntry> uncaughtExceptions = Collections.synchronizedList(new ArrayList());
    private static Locale locale;
    private static Locale savedLocale;
    private static TimeZone timeZone;
    private static TimeZone savedTimeZone;
    private static Map<MockDirectoryWrapper, StackTraceElement[]> stores;
    @Deprecated
    private static List<String> testClassesRun;
    private static boolean testsFailed;
    @Rule
    public final TestWatchman intercept = new TestWatchman(){

        public void failed(Throwable e, FrameworkMethod method) {
            if (e.getClass().getName().endsWith("AssumptionViolatedException")) {
                if (e.getCause() instanceof TestIgnoredException) {
                    e = e.getCause();
                }
                System.err.print("NOTE: Assume failed in '" + method.getName() + "' (ignored):");
                if (VERBOSE) {
                    System.err.println();
                    e.printStackTrace(System.err);
                } else {
                    System.err.print(" ");
                    System.err.println(e.getMessage());
                }
            } else {
                testsFailed = true;
                LuceneTestCase.this.reportAdditionalFailureInfo();
            }
            super.failed(e, method);
        }

        public void starting(FrameworkMethod method) {
            LuceneTestCase.this.name = method.getName();
            super.starting(method);
        }
    };
    private static final int THREAD_STOP_GRACE_MSEC = 50;
    private static final IdentityHashMap<Thread, Boolean> rogueThreads;
    static final Field.TermVector[] tvSettings;
    private static final String[] FS_DIRECTORIES;
    private static final String[] CORE_DIRECTORIES;
    private static long staticSeed;
    private long seed;
    private static final Random seedRand;
    protected static final Random random;
    private String name = "<unknown>";

    @BeforeClass
    public static void beforeClassLuceneTestCaseJ4() {
        staticSeed = "random".equals(TEST_SEED) ? seedRand.nextLong() : TwoLongs.fromString((String)LuceneTestCase.TEST_SEED).l1;
        random.setSeed(staticSeed);
        stores = Collections.synchronizedMap(new IdentityHashMap());
        if (random.nextInt(4) != 0) {
            random.nextInt();
        }
        savedLocale = Locale.getDefault();
        locale = TEST_LOCALE.equals("random") ? LuceneTestCase.randomLocale(random) : LuceneTestCase.localeForName(TEST_LOCALE);
        Locale.setDefault(locale);
        savedTimeZone = TimeZone.getDefault();
        timeZone = TEST_TIMEZONE.equals("random") ? LuceneTestCase.randomTimeZone(random) : TimeZone.getTimeZone(TEST_TIMEZONE);
        TimeZone.setDefault(timeZone);
        testsFailed = false;
    }

    @AfterClass
    public static void afterClassLuceneTestCaseJ4() {
        int rogueThreads;
        if (!"false".equals(TEST_CLEAN_THREADS) && (rogueThreads = LuceneTestCase.threadCleanup("test class")) > 0) {
            System.err.println("RESOURCE LEAK: test class left " + rogueThreads + " thread(s) running");
        }
        Locale.setDefault(savedLocale);
        TimeZone.setDefault(savedTimeZone);
        System.clearProperty("solr.solr.home");
        System.clearProperty("solr.data.dir");
        if (!testsFailed) {
            for (MockDirectoryWrapper d : stores.keySet()) {
                if (!d.isOpen()) continue;
                StackTraceElement[] elements = stores.get((Object)d);
                StackTraceElement element = null;
                for (int i = 2; i < elements.length; ++i) {
                    StackTraceElement ste = elements[i];
                    if (ste.getClassName().indexOf("LuceneTestCase") != -1) continue;
                    element = ste;
                    break;
                }
                LuceneTestCase.fail((String)("directory of test was not closed, opened from: " + element));
            }
        }
        stores = null;
        if (VERBOSE || testsFailed) {
            System.err.println("NOTE: test params are: locale=" + locale + ", timezone=" + (timeZone == null ? "(null)" : timeZone.getID()));
        }
        if (testsFailed) {
            System.err.println("NOTE: all tests run in this JVM:");
            System.err.println(Arrays.toString(testClassesRun.toArray()));
            System.err.println("NOTE: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "/" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + (Constants.JRE_IS_64BIT ? "(64-bit)" : "(32-bit)") + "/" + "cpus=" + Runtime.getRuntime().availableProcessors() + "," + "threads=" + Thread.activeCount() + "," + "free=" + Runtime.getRuntime().freeMemory() + "," + "total=" + Runtime.getRuntime().totalMemory());
        }
    }

    @Before
    public void setUp() throws Exception {
        this.seed = "random".equals(TEST_SEED) ? seedRand.nextLong() : TwoLongs.fromString((String)LuceneTestCase.TEST_SEED).l2;
        random.setSeed(this.seed);
        LuceneTestCase.assertFalse((String)"ensure your tearDown() calls super.tearDown()!!!", (boolean)this.setup);
        this.setup = true;
        this.savedUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                testsFailed = true;
                LuceneTestCase.this.uncaughtExceptions.add(new UncaughtExceptionEntry(t, e));
                if (LuceneTestCase.this.savedUncaughtExceptionHandler != null) {
                    LuceneTestCase.this.savedUncaughtExceptionHandler.uncaughtException(t, e);
                }
            }
        });
        this.savedBoolMaxClauseCount = BooleanQuery.getMaxClauseCount();
    }

    protected void purgeFieldCache(FieldCache fc) {
        fc.purgeAllCaches();
    }

    protected String getTestLabel() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        int rogueThreads;
        LuceneTestCase.assertTrue((String)"ensure your setUp() calls super.setUp()!!!", (boolean)this.setup);
        this.setup = false;
        BooleanQuery.setMaxClauseCount((int)this.savedBoolMaxClauseCount);
        if ("perMethod".equals(TEST_CLEAN_THREADS) && (rogueThreads = LuceneTestCase.threadCleanup("test method: '" + this.getName() + "'")) > 0) {
            System.err.println("RESOURCE LEAK: test method: '" + this.getName() + "' left " + rogueThreads + " thread(s) running");
            if (!testsFailed && this.uncaughtExceptions.isEmpty()) {
                this.reportAdditionalFailureInfo();
            }
        }
        Thread.setDefaultUncaughtExceptionHandler(this.savedUncaughtExceptionHandler);
        try {
            if (!this.uncaughtExceptions.isEmpty()) {
                testsFailed = true;
                this.reportAdditionalFailureInfo();
                System.err.println("The following exceptions were thrown by threads:");
                for (UncaughtExceptionEntry entry : this.uncaughtExceptions) {
                    System.err.println("*** Thread: " + entry.thread.getName() + " ***");
                    entry.exception.printStackTrace(System.err);
                }
                LuceneTestCase.fail((String)"Some threads threw uncaught exceptions!");
            }
            this.assertSaneFieldCaches(this.getTestLabel());
        }
        finally {
            this.purgeFieldCache(FieldCache.DEFAULT);
        }
    }

    private static int threadCleanup(String context) {
        Thread[] stillRunning = new Thread[Thread.activeCount() + 1];
        int threadCount = 0;
        int rogueCount = 0;
        threadCount = Thread.enumerate(stillRunning);
        if (threadCount > 1) {
            while (threadCount == stillRunning.length) {
                stillRunning = new Thread[stillRunning.length * 2];
                threadCount = Thread.enumerate(stillRunning);
            }
            for (int i = 0; i < threadCount; ++i) {
                Thread t = stillRunning[i];
                if (!t.isAlive() || rogueThreads.containsKey(t) || t == Thread.currentThread() || t.getName().equals("TimeLimitedCollector timer thread") || t.getName().startsWith("LuceneTestCase") && context.startsWith("test method")) continue;
                System.err.println("WARNING: " + context + " left thread running: " + t);
                rogueThreads.put(t, true);
                ++rogueCount;
                if (t.getName().startsWith("LuceneTestCase")) {
                    System.err.println("PLEASE CLOSE YOUR INDEXSEARCHERS IN YOUR TEST!!!!");
                    continue;
                }
                try {
                    t.join(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                t.setUncaughtExceptionHandler(null);
                Thread.setDefaultUncaughtExceptionHandler(null);
                t.interrupt();
            }
        }
        return rogueCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSaneFieldCaches(String msg) {
        Object[] entries = FieldCache.DEFAULT.getCacheEntries();
        Object[] insanity = null;
        try {
            try {
                insanity = FieldCacheSanityChecker.checkSanity((FieldCache.CacheEntry[])entries);
            }
            catch (RuntimeException e) {
                LuceneTestCase.dumpArray(msg + ": FieldCache", entries, System.err);
                throw e;
            }
            LuceneTestCase.assertEquals((String)(msg + ": Insane FieldCache usage(s) found"), (long)0L, (long)insanity.length);
            insanity = null;
        }
        finally {
            if (null != insanity) {
                LuceneTestCase.dumpArray(msg + ": Insane FieldCache usage(s)", insanity, System.err);
            }
        }
    }

    @Deprecated
    public static void assertEquals(double expected, double actual) {
        LuceneTestCase.assertEquals(null, expected, actual);
    }

    @Deprecated
    public static void assertEquals(String message, double expected, double actual) {
        LuceneTestCase.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    @Deprecated
    public static void assertEquals(float expected, float actual) {
        LuceneTestCase.assertEquals(null, expected, actual);
    }

    @Deprecated
    public static void assertEquals(String message, float expected, float actual) {
        LuceneTestCase.assertEquals((String)message, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual));
    }

    public static void assumeTrue(String msg, boolean b) {
        Assume.assumeNoException((Throwable)(b ? null : new TestIgnoredException(msg)));
    }

    public static void assumeFalse(String msg, boolean b) {
        LuceneTestCase.assumeTrue(msg, !b);
    }

    public static void assumeNoException(String msg, Exception e) {
        Assume.assumeNoException((Throwable)(e == null ? null : new TestIgnoredException(msg, e)));
    }

    public static void dumpIterator(String label, Iterator<?> iter, PrintStream stream) {
        stream.println("*** BEGIN " + label + " ***");
        if (null == iter) {
            stream.println(" ... NULL ...");
        } else {
            while (iter.hasNext()) {
                stream.println(iter.next().toString());
            }
        }
        stream.println("*** END " + label + " ***");
    }

    public static void dumpArray(String label, Object[] objs, PrintStream stream) {
        Iterator<Object> iter = null == objs ? null : Arrays.asList(objs).iterator();
        LuceneTestCase.dumpIterator(label, iter, stream);
    }

    public static IndexWriterConfig newIndexWriterConfig(Version v, Analyzer a) {
        return LuceneTestCase.newIndexWriterConfig(random, v, a);
    }

    public static IndexWriterConfig newIndexWriterConfig(Random r, Version v, Analyzer a) {
        IndexWriterConfig c = new IndexWriterConfig(v, a);
        if (r.nextBoolean()) {
            c.setMergePolicy((MergePolicy)new LogDocMergePolicy());
        }
        if (r.nextBoolean()) {
            c.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        }
        if (r.nextBoolean()) {
            if (r.nextInt(20) == 17) {
                c.setMaxBufferedDocs(2);
            } else {
                c.setMaxBufferedDocs(_TestUtil.nextInt(r, 2, 1000));
            }
        }
        if (r.nextBoolean()) {
            c.setTermIndexInterval(_TestUtil.nextInt(r, 1, 1000));
        }
        if (r.nextBoolean()) {
            c.setMaxThreadStates(_TestUtil.nextInt(r, 1, 20));
        }
        if (c.getMergePolicy() instanceof LogMergePolicy) {
            LogMergePolicy logmp = (LogMergePolicy)c.getMergePolicy();
            logmp.setUseCompoundFile(r.nextBoolean());
            logmp.setCalibrateSizeByDeletes(r.nextBoolean());
            if (r.nextInt(3) == 2) {
                logmp.setMergeFactor(2);
            } else {
                logmp.setMergeFactor(_TestUtil.nextInt(r, 2, 20));
            }
        }
        c.setReaderPooling(r.nextBoolean());
        c.setReaderTermsIndexDivisor(_TestUtil.nextInt(r, 1, 4));
        return c;
    }

    public static LogMergePolicy newLogMergePolicy() {
        return LuceneTestCase.newLogMergePolicy(random);
    }

    public static LogMergePolicy newLogMergePolicy(Random r) {
        LogDocMergePolicy logmp = r.nextBoolean() ? new LogDocMergePolicy() : new LogByteSizeMergePolicy();
        logmp.setUseCompoundFile(r.nextBoolean());
        logmp.setCalibrateSizeByDeletes(r.nextBoolean());
        if (r.nextInt(3) == 2) {
            logmp.setMergeFactor(2);
        } else {
            logmp.setMergeFactor(_TestUtil.nextInt(r, 2, 20));
        }
        return logmp;
    }

    public static LogMergePolicy newLogMergePolicy(boolean useCFS) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setUseCompoundFile(useCFS);
        return logmp;
    }

    public static LogMergePolicy newLogMergePolicy(boolean useCFS, int mergeFactor) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setUseCompoundFile(useCFS);
        logmp.setMergeFactor(mergeFactor);
        return logmp;
    }

    public static LogMergePolicy newLogMergePolicy(int mergeFactor) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setMergeFactor(mergeFactor);
        return logmp;
    }

    public static MockDirectoryWrapper newDirectory() throws IOException {
        return LuceneTestCase.newDirectory(random);
    }

    public static MockDirectoryWrapper newDirectory(Random r) throws IOException {
        Directory impl = LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY);
        MockDirectoryWrapper dir = new MockDirectoryWrapper(r, impl);
        stores.put(dir, Thread.currentThread().getStackTrace());
        return dir;
    }

    public static MockDirectoryWrapper newDirectory(Directory d) throws IOException {
        return LuceneTestCase.newDirectory(random, d);
    }

    public static MockDirectoryWrapper newFSDirectory(File f) throws IOException {
        return LuceneTestCase.newFSDirectory(f, null);
    }

    public static MockDirectoryWrapper newFSDirectory(File f, LockFactory lf) throws IOException {
        String fsdirClass = TEST_DIRECTORY;
        if (fsdirClass.equals("random")) {
            fsdirClass = FS_DIRECTORIES[random.nextInt(FS_DIRECTORIES.length)];
        }
        if (fsdirClass.indexOf(".") == -1) {
            fsdirClass = "org.apache.lucene.store." + fsdirClass;
        }
        try {
            Class<FSDirectory> clazz;
            try {
                clazz = Class.forName(fsdirClass).asSubclass(FSDirectory.class);
            }
            catch (ClassCastException e) {
                fsdirClass = FS_DIRECTORIES[random.nextInt(FS_DIRECTORIES.length)];
                if (fsdirClass.indexOf(".") == -1) {
                    fsdirClass = "org.apache.lucene.store." + fsdirClass;
                }
                clazz = Class.forName(fsdirClass).asSubclass(FSDirectory.class);
            }
            MockDirectoryWrapper dir = new MockDirectoryWrapper(random, LuceneTestCase.newFSDirectoryImpl(clazz, f, lf));
            stores.put(dir, Thread.currentThread().getStackTrace());
            return dir;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MockDirectoryWrapper newDirectory(Random r, Directory d) throws IOException {
        Directory impl = LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY);
        for (String file : d.listAll()) {
            d.copy(impl, file, file);
        }
        MockDirectoryWrapper dir = new MockDirectoryWrapper(r, impl);
        stores.put(dir, Thread.currentThread().getStackTrace());
        return dir;
    }

    public static Field newField(String name, String value, Field.Index index) {
        return LuceneTestCase.newField(random, name, value, index);
    }

    public static Field newField(String name, String value, Field.Store store, Field.Index index) {
        return LuceneTestCase.newField(random, name, value, store, index);
    }

    public static Field newField(String name, String value, Field.Store store, Field.Index index, Field.TermVector tv) {
        return LuceneTestCase.newField(random, name, value, store, index, tv);
    }

    public static Field newField(Random random, String name, String value, Field.Index index) {
        return LuceneTestCase.newField(random, name, value, Field.Store.NO, index);
    }

    public static Field newField(Random random, String name, String value, Field.Store store, Field.Index index) {
        return LuceneTestCase.newField(random, name, value, store, index, Field.TermVector.NO);
    }

    public static Field newField(Random random, String name, String value, Field.Store store, Field.Index index, Field.TermVector tv) {
        if (!index.isIndexed()) {
            return new Field(name, value, store, index);
        }
        if (!store.isStored() && random.nextBoolean()) {
            store = Field.Store.YES;
        }
        tv = LuceneTestCase.randomTVSetting(random, tv);
        return new Field(name, value, store, index, tv);
    }

    private static Field.TermVector randomTVSetting(Random random, Field.TermVector minimum) {
        switch (minimum) {
            case NO: {
                return tvSettings[_TestUtil.nextInt(random, 0, tvSettings.length - 1)];
            }
            case YES: {
                return tvSettings[_TestUtil.nextInt(random, 1, tvSettings.length - 1)];
            }
            case WITH_OFFSETS: {
                return random.nextBoolean() ? Field.TermVector.WITH_OFFSETS : Field.TermVector.WITH_POSITIONS_OFFSETS;
            }
            case WITH_POSITIONS: {
                return random.nextBoolean() ? Field.TermVector.WITH_POSITIONS : Field.TermVector.WITH_POSITIONS_OFFSETS;
            }
        }
        return Field.TermVector.WITH_POSITIONS_OFFSETS;
    }

    public static Locale randomLocale(Random random) {
        Locale[] locales = Locale.getAvailableLocales();
        return locales[random.nextInt(locales.length)];
    }

    public static TimeZone randomTimeZone(Random random) {
        String[] tzIds = TimeZone.getAvailableIDs();
        return TimeZone.getTimeZone(tzIds[random.nextInt(tzIds.length)]);
    }

    public static Locale localeForName(String localeName) {
        String[] elements = localeName.split("\\_");
        switch (elements.length) {
            case 3: {
                return new Locale(elements[0], elements[1], elements[2]);
            }
            case 2: {
                return new Locale(elements[0], elements[1]);
            }
            case 1: {
                return new Locale(elements[0]);
            }
        }
        throw new IllegalArgumentException("Invalid Locale: " + localeName);
    }

    public static String randomDirectory(Random random) {
        if (random.nextInt(10) == 0) {
            return CORE_DIRECTORIES[random.nextInt(CORE_DIRECTORIES.length)];
        }
        return "RAMDirectory";
    }

    private static Directory newFSDirectoryImpl(Class<? extends FSDirectory> clazz, File file, LockFactory lockFactory) throws IOException {
        try {
            Constructor<? extends FSDirectory> ctor = clazz.getConstructor(File.class);
            FSDirectory d = ctor.newInstance(file);
            if (lockFactory != null) {
                d.setLockFactory(lockFactory);
            }
            return d;
        }
        catch (Exception e) {
            return FSDirectory.open((File)file);
        }
    }

    static Directory newDirectoryImpl(Random random, String clazzName) {
        if (clazzName.equals("random")) {
            clazzName = LuceneTestCase.randomDirectory(random);
        }
        if (clazzName.indexOf(".") == -1) {
            clazzName = "org.apache.lucene.store." + clazzName;
        }
        try {
            Class<Directory> clazz = Class.forName(clazzName).asSubclass(Directory.class);
            if (FSDirectory.class.isAssignableFrom(clazz)) {
                File tmpFile = File.createTempFile("test", "tmp", TEMP_DIR);
                tmpFile.delete();
                tmpFile.mkdir();
                return LuceneTestCase.newFSDirectoryImpl(clazz.asSubclass(FSDirectory.class), tmpFile, null);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSearcher newSearcher(IndexReader r) throws IOException {
        ExecutorService ex;
        ExecutorService executorService;
        if (random.nextBoolean()) {
            return new IndexSearcher(r);
        }
        int threads = 0;
        if (random.nextBoolean()) {
            executorService = null;
        } else {
            threads = _TestUtil.nextInt(random, 1, 8);
            executorService = ex = Executors.newFixedThreadPool(threads, (ThreadFactory)new NamedThreadFactory("LuceneTestCase"));
        }
        if (ex != null && VERBOSE) {
            System.out.println("NOTE: newSearcher using ExecutorService with " + threads + " threads");
        }
        return new IndexSearcher(r, ex){

            public void close() throws IOException {
                super.close();
                if (ex != null) {
                    ex.shutdown();
                    try {
                        ex.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public String getName() {
        return this.name;
    }

    protected File getDataFile(String name) throws IOException {
        try {
            return new File(((Object)((Object)this)).getClass().getResource(name).toURI());
        }
        catch (Exception e) {
            throw new IOException("Cannot find resource: " + name);
        }
    }

    public void reportAdditionalFailureInfo() {
        System.err.println("NOTE: reproduce with: ant test -Dtestcase=" + ((Object)((Object)this)).getClass().getSimpleName() + " -Dtestmethod=" + this.getName() + " -Dtests.seed=" + new TwoLongs(staticSeed, this.seed) + this.reproduceWithExtraParams());
    }

    private String reproduceWithExtraParams() {
        StringBuilder sb = new StringBuilder();
        if (!TEST_LOCALE.equals("random")) {
            sb.append(" -Dtests.locale=").append(TEST_LOCALE);
        }
        if (!TEST_TIMEZONE.equals("random")) {
            sb.append(" -Dtests.timezone=").append(TEST_TIMEZONE);
        }
        if (!TEST_DIRECTORY.equals("random")) {
            sb.append(" -Dtests.directory=").append(TEST_DIRECTORY);
        }
        if (RANDOM_MULTIPLIER > 1) {
            sb.append(" -Dtests.multiplier=").append(RANDOM_MULTIPLIER);
        }
        return sb.toString();
    }

    @Ignore(value="just a hack")
    public final void alwaysIgnoredTestMethod() {
    }

    static {
        String method = System.getProperty("testmethod", "").trim();
        TEST_METHOD = method.length() == 0 ? null : method;
        String s = System.getProperty("tempDir", System.getProperty("java.io.tmpdir"));
        if (s == null) {
            throw new RuntimeException("To run tests, you need to define system property 'tempDir' or 'java.io.tmpdir'.");
        }
        TEMP_DIR = new File(s);
        TEMP_DIR.mkdirs();
        TEST_LOCALE = System.getProperty("tests.locale", "random");
        TEST_TIMEZONE = System.getProperty("tests.timezone", "random");
        TEST_DIRECTORY = System.getProperty("tests.directory", "random");
        TEST_ITER = Integer.parseInt(System.getProperty("tests.iter", "1"));
        TEST_SEED = System.getProperty("tests.seed", "random");
        TEST_NIGHTLY = Boolean.parseBoolean(System.getProperty("tests.nightly", "false"));
        TEST_LINE_DOCS_FILE = System.getProperty("tests.linedocsfile", "europarl.lines.txt.gz");
        TEST_CLEAN_THREADS = System.getProperty("tests.cleanthreads", "perClass");
        RANDOM_MULTIPLIER = Integer.parseInt(System.getProperty("tests.multiplier", "1"));
        testClassesRun = new ArrayList<String>();
        rogueThreads = new IdentityHashMap();
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            rogueThreads.put(t, true);
        }
        tvSettings = new Field.TermVector[]{Field.TermVector.NO, Field.TermVector.YES, Field.TermVector.WITH_OFFSETS, Field.TermVector.WITH_POSITIONS, Field.TermVector.WITH_POSITIONS_OFFSETS};
        FS_DIRECTORIES = new String[]{"SimpleFSDirectory", "NIOFSDirectory", "MMapDirectory"};
        CORE_DIRECTORIES = new String[]{"RAMDirectory", FS_DIRECTORIES[0], FS_DIRECTORIES[1], FS_DIRECTORIES[2]};
        seedRand = new Random();
        random = new Random(0L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LuceneTestCaseRunner
    extends BlockJUnit4ClassRunner {
        private List<FrameworkMethod> testMethods;

        protected List<FrameworkMethod> computeTestMethods() {
            if (this.testMethods != null) {
                return this.testMethods;
            }
            testClassesRun.add(this.getTestClass().getJavaClass().getSimpleName());
            this.testMethods = new ArrayList<FrameworkMethod>();
            for (Method m : this.getTestClass().getJavaClass().getMethods()) {
                Ignore ignored = m.getAnnotation(Ignore.class);
                if (ignored != null && !m.getName().equals("alwaysIgnoredTestMethod")) {
                    System.err.println("NOTE: Ignoring test method '" + m.getName() + "': " + ignored.value());
                }
                int mod = m.getModifiers();
                if (m.getAnnotation(Test.class) == null && (!m.getName().startsWith("test") || Modifier.isAbstract(mod) || m.getParameterTypes().length != 0 || m.getReturnType() != Void.TYPE)) continue;
                if (Modifier.isStatic(mod)) {
                    throw new RuntimeException("Test methods must not be static.");
                }
                this.testMethods.add(new FrameworkMethod(m));
            }
            if (this.testMethods.isEmpty()) {
                throw new RuntimeException("No runnable methods!");
            }
            if (!TEST_NIGHTLY) {
                if (this.getTestClass().getJavaClass().isAnnotationPresent(Nightly.class)) {
                    String className = this.getTestClass().getJavaClass().getSimpleName();
                    System.err.println("NOTE: Ignoring nightly-only test class '" + className + "'");
                    this.testMethods.clear();
                } else {
                    for (int i = 0; i < this.testMethods.size(); ++i) {
                        FrameworkMethod m = this.testMethods.get(i);
                        if (m.getAnnotation(Nightly.class) == null) continue;
                        System.err.println("NOTE: Ignoring nightly-only test method '" + m.getName() + "'");
                        this.testMethods.remove(i--);
                    }
                }
                if (this.testMethods.isEmpty()) {
                    try {
                        this.testMethods.add(new FrameworkMethod(LuceneTestCase.class.getMethod("alwaysIgnoredTestMethod", new Class[0])));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return this.testMethods;
        }

        protected void runChild(FrameworkMethod arg0, RunNotifier arg1) {
            if (VERBOSE) {
                System.out.println("\nNOTE: running test " + arg0.getName());
            }
            for (int i = 0; i < TEST_ITER; ++i) {
                if (VERBOSE && TEST_ITER > 1) {
                    System.out.println("\nNOTE: running iter=" + (1 + i) + " of " + TEST_ITER);
                }
                super.runChild(arg0, arg1);
            }
        }

        public LuceneTestCaseRunner(Class<?> clazz) throws InitializationError {
            super(clazz);
            Filter f = new Filter(){

                public String describe() {
                    return "filters according to TEST_METHOD";
                }

                public boolean shouldRun(Description d) {
                    return TEST_METHOD == null || d.getMethodName().equals(TEST_METHOD);
                }
            };
            try {
                f.apply((Object)this);
            }
            catch (NoTestsRemainException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Nightly {
    }

    private static final class TestIgnoredException
    extends RuntimeException {
        TestIgnoredException(String msg) {
            super(msg);
        }

        TestIgnoredException(String msg, Throwable t) {
            super(msg, t);
        }

        public String getMessage() {
            StringBuilder sb = new StringBuilder(super.getMessage());
            if (this.getCause() != null) {
                sb.append(" - ").append(this.getCause());
            }
            return sb.toString();
        }

        public void printStackTrace(PrintStream s) {
            if (this.getCause() != null) {
                s.println(super.toString() + " - Caused by:");
                this.getCause().printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }
    }

    private static class TwoLongs {
        public final long l1;
        public final long l2;

        public TwoLongs(long l1, long l2) {
            this.l1 = l1;
            this.l2 = l2;
        }

        public String toString() {
            return this.l1 + ":" + this.l2;
        }

        public static TwoLongs fromString(String s) {
            int i = s.indexOf(58);
            assert (i != -1);
            return new TwoLongs(Long.parseLong(s.substring(0, i)), Long.parseLong(s.substring(1 + i)));
        }
    }

    private static class UncaughtExceptionEntry {
        public final Thread thread;
        public final Throwable exception;

        public UncaughtExceptionEntry(Thread thread, Throwable exception) {
            this.thread = thread;
            this.exception = exception;
        }
    }
}

