/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MockIndexInputWrapper;
import org.apache.lucene.store.MockIndexOutputWrapper;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockDirectoryWrapper
extends Directory {
    final Directory delegate;
    long maxSize;
    long maxUsedSize;
    double randomIOExceptionRate;
    Random randomState;
    boolean noDeleteOpenFile = true;
    boolean preventDoubleWrite = true;
    boolean checkIndexOnClose = true;
    boolean trackDiskUsage = false;
    private Set<String> unSyncedFiles;
    private Set<String> createdFiles;
    Set<String> openFilesForWrite = new HashSet<String>();
    volatile boolean crashed;
    Map<Closeable, Exception> openFileHandles = Collections.synchronizedMap(new IdentityHashMap());
    Map<String, Integer> openFiles;
    Set<String> openFilesDeleted;
    boolean open = true;
    ArrayList<Failure> failures;

    private synchronized void init() {
        if (this.openFiles == null) {
            this.openFiles = new HashMap<String, Integer>();
            this.openFilesDeleted = new HashSet<String>();
        }
        if (this.createdFiles == null) {
            this.createdFiles = new HashSet<String>();
        }
        if (this.unSyncedFiles == null) {
            this.unSyncedFiles = new HashSet<String>();
        }
    }

    public MockDirectoryWrapper(Random random, Directory delegate) {
        this.delegate = delegate;
        this.randomState = new Random(random.nextInt());
        this.init();
    }

    public void setTrackDiskUsage(boolean v) {
        this.trackDiskUsage = v;
    }

    public void setPreventDoubleWrite(boolean value) {
        this.preventDoubleWrite = value;
    }

    @Deprecated
    public void sync(String name) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed) {
            throw new IOException("cannot sync after crash");
        }
        this.unSyncedFiles.remove(name);
        this.delegate.sync(name);
    }

    public synchronized void sync(Collection<String> names) throws IOException {
        this.maybeYield();
        for (String name : names) {
            this.maybeThrowDeterministicException();
        }
        if (this.crashed) {
            throw new IOException("cannot sync after crash");
        }
        this.unSyncedFiles.removeAll(names);
        this.delegate.sync(names);
    }

    public String toString() {
        this.maybeYield();
        return "MockDirWrapper(" + this.delegate + ")";
    }

    public final synchronized long sizeInBytes() throws IOException {
        if (this.delegate instanceof RAMDirectory) {
            return ((RAMDirectory)this.delegate).sizeInBytes();
        }
        long size = 0L;
        for (String file : this.delegate.listAll()) {
            size += this.delegate.fileLength(file);
        }
        return size;
    }

    public synchronized void crash() throws IOException {
        this.crashed = true;
        this.openFiles = new HashMap<String, Integer>();
        this.openFilesForWrite = new HashSet<String>();
        this.openFilesDeleted = new HashSet<String>();
        Iterator<String> it = this.unSyncedFiles.iterator();
        this.unSyncedFiles = new HashSet<String>();
        IdentityHashMap<Closeable, Exception> m = new IdentityHashMap<Closeable, Exception>(this.openFileHandles);
        for (Closeable f : m.keySet()) {
            try {
                f.close();
            }
            catch (Exception ignored) {}
        }
        int count = 0;
        while (it.hasNext()) {
            String name = it.next();
            if (count % 3 == 0) {
                this.deleteFile(name, true);
            } else if (count % 3 == 1) {
                int limit;
                long length = this.fileLength(name);
                byte[] zeroes = new byte[256];
                IndexOutput out = this.delegate.createOutput(name);
                for (long upto = 0L; upto < length; upto += (long)limit) {
                    limit = (int)Math.min(length - upto, (long)zeroes.length);
                    out.writeBytes(zeroes, 0, limit);
                }
                out.close();
            } else if (count % 3 == 2) {
                IndexOutput out = this.delegate.createOutput(name);
                out.setLength(this.fileLength(name) / 2L);
                out.close();
            }
            ++count;
        }
    }

    public synchronized void clearCrash() throws IOException {
        this.crashed = false;
    }

    public void setMaxSizeInBytes(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getMaxSizeInBytes() {
        return this.maxSize;
    }

    public long getMaxUsedSizeInBytes() {
        return this.maxUsedSize;
    }

    public void resetMaxUsedSizeInBytes() throws IOException {
        this.maxUsedSize = this.getRecomputedActualSizeInBytes();
    }

    public void setNoDeleteOpenFile(boolean value) {
        this.noDeleteOpenFile = value;
    }

    public boolean getNoDeleteOpenFile() {
        return this.noDeleteOpenFile;
    }

    public void setCheckIndexOnClose(boolean value) {
        this.checkIndexOnClose = value;
    }

    public boolean getCheckIndexOnClose() {
        return this.checkIndexOnClose;
    }

    public void setRandomIOExceptionRate(double rate) {
        this.randomIOExceptionRate = rate;
    }

    public double getRandomIOExceptionRate() {
        return this.randomIOExceptionRate;
    }

    void maybeThrowIOException() throws IOException {
        int number;
        if (this.randomIOExceptionRate > 0.0 && (double)(number = Math.abs(this.randomState.nextInt() % 1000)) < this.randomIOExceptionRate * 1000.0) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": MockDirectoryWrapper: now throw random exception");
                new Throwable().printStackTrace(System.out);
            }
            throw new IOException("a random IOException");
        }
    }

    public synchronized void deleteFile(String name) throws IOException {
        this.maybeYield();
        this.deleteFile(name, false);
    }

    private synchronized IOException fillOpenTrace(IOException ioe, String name, boolean input) {
        for (Map.Entry<Closeable, Exception> ent : this.openFileHandles.entrySet()) {
            if (input && ent.getKey() instanceof MockIndexInputWrapper && ((MockIndexInputWrapper)((Object)ent.getKey())).name.equals(name)) {
                ioe.initCause(ent.getValue());
                break;
            }
            if (input || !(ent.getKey() instanceof MockIndexOutputWrapper) || !((MockIndexOutputWrapper)((Object)ent.getKey())).name.equals(name)) continue;
            ioe.initCause(ent.getValue());
            break;
        }
        return ioe;
    }

    private void maybeYield() {
        if (this.randomState.nextBoolean()) {
            Thread.yield();
        }
    }

    private synchronized void deleteFile(String name, boolean forced) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed && !forced) {
            throw new IOException("cannot delete after crash");
        }
        if (this.unSyncedFiles.contains(name)) {
            this.unSyncedFiles.remove(name);
        }
        if (!forced && this.noDeleteOpenFile) {
            if (this.openFiles.containsKey(name)) {
                this.openFilesDeleted.add(name);
                throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open: cannot delete"), name, true);
            }
            this.openFilesDeleted.remove(name);
        }
        this.delegate.deleteFile(name);
    }

    public synchronized Set<String> getOpenDeletedFiles() {
        return new HashSet<String>(this.openFilesDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IndexOutput createOutput(String name) throws IOException {
        this.maybeYield();
        if (this.crashed) {
            throw new IOException("cannot createOutput after crash");
        }
        this.init();
        MockDirectoryWrapper mockDirectoryWrapper = this;
        synchronized (mockDirectoryWrapper) {
            if (this.preventDoubleWrite && this.createdFiles.contains(name) && !name.equals("segments.gen")) {
                throw new IOException("file \"" + name + "\" was already written to");
            }
        }
        if (this.noDeleteOpenFile && this.openFiles.containsKey(name)) {
            throw new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open: cannot overwrite");
        }
        if (this.crashed) {
            throw new IOException("cannot createOutput after crash");
        }
        this.unSyncedFiles.add(name);
        this.createdFiles.add(name);
        if (this.delegate instanceof RAMDirectory) {
            RAMDirectory ramdir = (RAMDirectory)this.delegate;
            RAMFile file = new RAMFile(ramdir);
            RAMFile existing = (RAMFile)ramdir.fileMap.get(name);
            if (existing != null && !name.equals("segments.gen") && this.preventDoubleWrite) {
                throw new IOException("file " + name + " already exists");
            }
            if (existing != null) {
                ramdir.sizeInBytes.getAndAdd(-existing.sizeInBytes);
                existing.directory = null;
            }
            ramdir.fileMap.put(name, file);
        }
        MockIndexOutputWrapper io = new MockIndexOutputWrapper(this, this.delegate.createOutput(name), name);
        this.openFileHandles.put((Closeable)((Object)io), new RuntimeException("unclosed IndexOutput"));
        this.openFilesForWrite.add(name);
        return io;
    }

    public synchronized IndexInput openInput(String name) throws IOException {
        this.maybeYield();
        if (!this.delegate.fileExists(name)) {
            throw new FileNotFoundException(name);
        }
        if (this.openFilesForWrite.contains(name) && !name.startsWith("segments")) {
            throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open for writing"), name, false);
        }
        if (this.openFiles.containsKey(name)) {
            Integer v = this.openFiles.get(name);
            v = v + 1;
            this.openFiles.put(name, v);
        } else {
            this.openFiles.put(name, 1);
        }
        MockIndexInputWrapper ii = new MockIndexInputWrapper(this, name, this.delegate.openInput(name));
        this.openFileHandles.put((Closeable)((Object)ii), new RuntimeException("unclosed IndexInput"));
        return ii;
    }

    public final synchronized long getRecomputedSizeInBytes() throws IOException {
        if (!(this.delegate instanceof RAMDirectory)) {
            return this.sizeInBytes();
        }
        long size = 0L;
        for (RAMFile file : ((RAMDirectory)this.delegate).fileMap.values()) {
            size += file.getSizeInBytes();
        }
        return size;
    }

    public final synchronized long getRecomputedActualSizeInBytes() throws IOException {
        if (!(this.delegate instanceof RAMDirectory)) {
            return this.sizeInBytes();
        }
        long size = 0L;
        for (RAMFile file : ((RAMDirectory)this.delegate).fileMap.values()) {
            size += file.length;
        }
        return size;
    }

    public synchronized void close() throws IOException {
        this.maybeYield();
        if (this.openFiles == null) {
            this.openFiles = new HashMap<String, Integer>();
            this.openFilesDeleted = new HashSet<String>();
        }
        if (this.noDeleteOpenFile && this.openFiles.size() > 0) {
            Exception cause = null;
            Iterator<Exception> stacktraces = this.openFileHandles.values().iterator();
            if (stacktraces.hasNext()) {
                cause = stacktraces.next();
            }
            throw new RuntimeException("MockDirectoryWrapper: cannot close: there are still open files: " + this.openFiles, cause);
        }
        this.open = false;
        if (this.checkIndexOnClose && IndexReader.indexExists((Directory)this)) {
            _TestUtil.checkIndex(this);
        }
        this.delegate.close();
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    public synchronized void failOn(Failure fail) {
        if (this.failures == null) {
            this.failures = new ArrayList();
        }
        this.failures.add(fail);
    }

    synchronized void maybeThrowDeterministicException() throws IOException {
        if (this.failures != null) {
            for (int i = 0; i < this.failures.size(); ++i) {
                this.failures.get(i).eval(this);
            }
        }
    }

    public synchronized String[] listAll() throws IOException {
        this.maybeYield();
        return this.delegate.listAll();
    }

    public synchronized boolean fileExists(String name) throws IOException {
        this.maybeYield();
        return this.delegate.fileExists(name);
    }

    public synchronized long fileModified(String name) throws IOException {
        this.maybeYield();
        return this.delegate.fileModified(name);
    }

    public synchronized void touchFile(String name) throws IOException {
        this.maybeYield();
        this.delegate.touchFile(name);
    }

    public synchronized long fileLength(String name) throws IOException {
        this.maybeYield();
        return this.delegate.fileLength(name);
    }

    public synchronized Lock makeLock(String name) {
        this.maybeYield();
        return this.delegate.makeLock(name);
    }

    public synchronized void clearLock(String name) throws IOException {
        this.maybeYield();
        this.delegate.clearLock(name);
    }

    public synchronized void setLockFactory(LockFactory lockFactory) throws IOException {
        this.maybeYield();
        this.delegate.setLockFactory(lockFactory);
    }

    public synchronized LockFactory getLockFactory() {
        this.maybeYield();
        return this.delegate.getLockFactory();
    }

    public synchronized String getLockID() {
        this.maybeYield();
        return this.delegate.getLockID();
    }

    public synchronized void copy(Directory to, String src, String dest) throws IOException {
        this.maybeYield();
        this.delegate.copy(to, src, dest);
    }

    public static class Failure {
        protected boolean doFail;

        public void eval(MockDirectoryWrapper dir) throws IOException {
        }

        public Failure reset() {
            return this;
        }

        public void setDoFail() {
            this.doFail = true;
        }

        public void clearDoFail() {
            this.doFail = false;
        }
    }
}

