/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.Version;
import org.apache.lucene.util._TestUtil;

public class RandomIndexWriter
implements Closeable {
    public IndexWriter w;
    private final Random r;
    int docCount;
    int flushAt;
    private boolean getReaderCalled;

    public RandomIndexWriter(Random r, Directory dir) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, LuceneTestCase.TEST_VERSION_CURRENT, (Analyzer)new ReusableAnalyzerBase(){

            protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
                WhitespaceTokenizer tokenizer = new WhitespaceTokenizer(LuceneTestCase.TEST_VERSION_CURRENT, reader);
                return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LowerCaseFilter(LuceneTestCase.TEST_VERSION_CURRENT, (TokenStream)tokenizer));
            }
        }));
    }

    public RandomIndexWriter(Random r, Directory dir, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, LuceneTestCase.TEST_VERSION_CURRENT, a));
    }

    public RandomIndexWriter(Random r, Directory dir, Version v, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, v, a));
    }

    public RandomIndexWriter(Random r, Directory dir, IndexWriterConfig c) throws IOException {
        this.r = r;
        this.w = new MockIndexWriter(r, dir, c);
        this.flushAt = _TestUtil.nextInt(r, 10, 1000);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW config=" + this.w.getConfig());
        }
    }

    public void addDocument(Document doc) throws IOException {
        this.w.addDocument(doc);
        if (this.docCount++ == this.flushAt) {
            this.w.commit();
            this.flushAt += _TestUtil.nextInt(this.r, 10, 1000);
        }
    }

    public void addIndexes(Directory ... dirs) throws CorruptIndexException, IOException {
        this.w.addIndexes(dirs);
    }

    public void deleteDocuments(Term term) throws CorruptIndexException, IOException {
        this.w.deleteDocuments(term);
    }

    public void commit() throws CorruptIndexException, IOException {
        this.w.commit();
    }

    public int numDocs() throws IOException {
        return this.w.numDocs();
    }

    public int maxDoc() {
        return this.w.maxDoc();
    }

    public void deleteAll() throws IOException {
        this.w.deleteAll();
    }

    public IndexReader getReader() throws IOException {
        this.getReaderCalled = true;
        if (this.r.nextInt(4) == 2) {
            this.w.optimize();
        }
        if (this.r.nextBoolean()) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("RIW.getReader: use NRT reader");
            }
            return this.w.getReader();
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW.getReader: open new reader");
        }
        this.w.commit();
        return IndexReader.open((Directory)this.w.getDirectory(), (IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy(), (boolean)this.r.nextBoolean(), (int)_TestUtil.nextInt(this.r, 1, 10));
    }

    public void close() throws IOException {
        if (!this.getReaderCalled && this.r.nextInt(4) == 2) {
            this.w.optimize();
        }
        this.w.close();
    }

    public void optimize() throws IOException {
        this.w.optimize();
    }

    private static final class MockIndexWriter
    extends IndexWriter {
        private final Random r;

        public MockIndexWriter(Random r, Directory dir, IndexWriterConfig conf) throws IOException {
            super(dir, conf);
            this.r = new Random(r.nextInt());
        }

        boolean testPoint(String name) {
            if (this.r.nextInt(4) == 2) {
                Thread.yield();
            }
            return true;
        }
    }
}

