/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.index.Payload;

final class SimplePayloadFilter
extends TokenFilter {
    String fieldName;
    int pos;
    final PayloadAttribute payloadAttr;
    final CharTermAttribute termAttr;

    public SimplePayloadFilter(TokenStream input, String fieldName) {
        super(input);
        this.fieldName = fieldName;
        this.pos = 0;
        this.payloadAttr = (PayloadAttribute)input.addAttribute(PayloadAttribute.class);
        this.termAttr = (CharTermAttribute)input.addAttribute(CharTermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.payloadAttr.setPayload(new Payload(("pos: " + this.pos).getBytes()));
            ++this.pos;
            return true;
        }
        return false;
    }
}

