/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.replicator.nrt.Node;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;

class SegmentInfosSearcherManager
extends ReferenceManager<IndexSearcher> {
    private volatile SegmentInfos currentInfos;
    private final Directory dir;
    private final Node node;
    private final AtomicInteger openReaderCount = new AtomicInteger();
    private final SearcherFactory searcherFactory;

    public SegmentInfosSearcherManager(Directory dir, Node node, SegmentInfos infosIn, SearcherFactory searcherFactory) throws IOException {
        this.dir = dir;
        this.node = node;
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.currentInfos = infosIn;
        node.message("SegmentInfosSearcherManager.init: use incoming infos=" + infosIn.toString());
        this.current = SearcherManager.getSearcher((SearcherFactory)searcherFactory, (IndexReader)StandardDirectoryReader.open((Directory)dir, (SegmentInfos)this.currentInfos, null, null), null);
        this.addReaderClosedListener(((IndexSearcher)this.current).getIndexReader());
    }

    protected int getRefCount(IndexSearcher s) {
        return s.getIndexReader().getRefCount();
    }

    protected boolean tryIncRef(IndexSearcher s) {
        return s.getIndexReader().tryIncRef();
    }

    protected void decRef(IndexSearcher s) throws IOException {
        s.getIndexReader().decRef();
    }

    public SegmentInfos getCurrentInfos() {
        return this.currentInfos;
    }

    public void setCurrentInfos(SegmentInfos infos) throws IOException {
        if (this.currentInfos != null) {
            infos.updateGeneration(this.currentInfos);
            this.node.message("mgr.setCurrentInfos: carry over infos gen=" + infos.getSegmentsFileName());
        }
        this.currentInfos = infos;
        this.maybeRefresh();
    }

    protected IndexSearcher refreshIfNeeded(IndexSearcher old) throws IOException {
        ArrayList<LeafReader> subs;
        if (old == null) {
            subs = null;
        } else {
            subs = new ArrayList<LeafReader>();
            for (LeafReaderContext ctx : old.getIndexReader().leaves()) {
                subs.add(ctx.reader());
            }
        }
        DirectoryReader r = StandardDirectoryReader.open((Directory)this.dir, (SegmentInfos)this.currentInfos, subs, null);
        this.addReaderClosedListener((IndexReader)r);
        this.node.message("refreshed to version=" + this.currentInfos.getVersion() + " r=" + r);
        return SearcherManager.getSearcher((SearcherFactory)this.searcherFactory, (IndexReader)r, (IndexReader)old.getIndexReader());
    }

    private void addReaderClosedListener(IndexReader r) {
        IndexReader.CacheHelper cacheHelper = r.getReaderCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalStateException("StandardDirectoryReader must support caching");
        }
        this.openReaderCount.incrementAndGet();
        cacheHelper.addClosedListener(new IndexReader.ClosedListener(){

            public void onClose(IndexReader.CacheKey cacheKey) {
                SegmentInfosSearcherManager.this.onReaderClosed();
            }
        });
    }

    synchronized void onReaderClosed() {
        if (this.openReaderCount.decrementAndGet() == 0) {
            ((Object)((Object)this)).notifyAll();
        }
    }
}

