/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;

public abstract class HttpClientBase
implements Closeable {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 1000;
    public static final int DEFAULT_SO_TIMEOUT = 60000;
    protected final String url;
    private volatile boolean closed = false;
    private final CloseableHttpClient httpc;
    private final RequestConfig defaultConfig;

    protected HttpClientBase(String host, int port, String path, HttpClientConnectionManager conMgr, RequestConfig defaultConfig) {
        this.url = HttpClientBase.normalizedURL(host, port, path);
        this.defaultConfig = defaultConfig == null ? RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(60000).build() : defaultConfig;
        this.httpc = HttpClientBuilder.create().setConnectionManager(conMgr).setDefaultRequestConfig(this.defaultConfig).build();
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("HttpClient already closed");
        }
    }

    private static String normalizedURL(String host, int port, String path) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        return "http://" + host + ":" + port + path;
    }

    protected void verifyStatus(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            try {
                this.throwKnownError(response, statusLine);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    protected void throwKnownError(HttpResponse response, StatusLine statusLine) throws IOException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(response.getEntity().getContent());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unknown error: " + statusLine, t);
        }
        try {
            t = (Throwable)in.readObject();
            assert (t != null);
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to read exception object: " + statusLine, th);
        }
        finally {
            in.close();
        }
        throw IOUtils.rethrowAlways((Throwable)t);
    }

    protected HttpResponse executePOST(String request, HttpEntity entity, String ... params) throws IOException {
        this.ensureOpen();
        HttpPost m = new HttpPost(this.queryString(request, params));
        m.setEntity(entity);
        CloseableHttpResponse response = this.httpc.execute((HttpUriRequest)m);
        this.verifyStatus((HttpResponse)response);
        return response;
    }

    protected HttpResponse executeGET(String request, String ... params) throws IOException {
        this.ensureOpen();
        HttpGet m = new HttpGet(this.queryString(request, params));
        CloseableHttpResponse response = this.httpc.execute((HttpUriRequest)m);
        this.verifyStatus((HttpResponse)response);
        return response;
    }

    private String queryString(String request, String ... params) throws UnsupportedEncodingException {
        StringBuilder query = new StringBuilder(this.url).append('/').append(request).append('?');
        if (params != null) {
            for (int i = 0; i < params.length; i += 2) {
                query.append(params[i]).append('=').append(URLEncoder.encode(params[i + 1], "UTF8")).append('&');
            }
        }
        return query.substring(0, query.length() - 1);
    }

    public InputStream responseInputStream(HttpResponse response) throws IOException {
        return this.responseInputStream(response, false);
    }

    public InputStream responseInputStream(HttpResponse response, boolean consume) throws IOException {
        final HttpEntity entity = response.getEntity();
        final InputStream in = entity.getContent();
        if (!consume) {
            return in;
        }
        return new InputStream(){
            private boolean consumed = false;

            @Override
            public int read() throws IOException {
                int res = in.read();
                this.consume(res);
                return res;
            }

            @Override
            public void close() throws IOException {
                in.close();
                this.consume(-1);
            }

            @Override
            public int read(byte[] b) throws IOException {
                int res = in.read(b);
                this.consume(res);
                return res;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int res = in.read(b, off, len);
                this.consume(res);
                return res;
            }

            private void consume(int minusOne) {
                if (!this.consumed && minusOne == -1) {
                    try {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.consumed = true;
                }
            }
        };
    }

    protected final boolean isClosed() {
        return this.closed;
    }

    protected <T> T doAction(HttpResponse response, Callable<T> call) throws IOException {
        return this.doAction(response, true, call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doAction(HttpResponse response, boolean consume, Callable<T> call) throws IOException {
        Throwable th = null;
        try {
            T t = call.call();
            return t;
        }
        catch (Throwable t) {
            th = t;
        }
        finally {
            try {
                this.verifyStatus(response);
            }
            finally {
                if (consume) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }
        throw IOUtils.rethrowAlways((Throwable)th);
    }

    @Override
    public void close() throws IOException {
        this.httpc.close();
        this.closed = true;
    }
}

