/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.store.IndexInput;

public final class IndexInputInputStream
extends InputStream {
    private final IndexInput in;
    private long remaining;

    public IndexInputInputStream(IndexInput in) {
        this.in = in;
        this.remaining = in.length();
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        --this.remaining;
        return this.in.readByte();
    }

    @Override
    public int available() throws IOException {
        return (int)this.in.length();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        if (this.remaining < (long)len) {
            len = (int)this.remaining;
        }
        this.in.readBytes(b, off, len);
        this.remaining -= (long)len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.remaining == 0L) {
            return -1L;
        }
        if (this.remaining < n) {
            n = this.remaining;
        }
        this.in.seek(this.in.getFilePointer() + n);
        this.remaining -= n;
        return n;
    }
}

