/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.processors;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import org.apache.lucene.messages.MessageImpl;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.QueryNodeParseException;
import org.apache.lucene.queryParser.core.config.FieldConfig;
import org.apache.lucene.queryParser.core.config.QueryConfigHandler;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.core.nodes.FieldQueryNode;
import org.apache.lucene.queryParser.core.nodes.ParametricQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryParser.standard.config.NumericConfig;
import org.apache.lucene.queryParser.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryParser.standard.nodes.NumericQueryNode;
import org.apache.lucene.queryParser.standard.nodes.NumericRangeQueryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        NumericConfig numericConfig;
        FieldQueryNode fieldNode;
        FieldConfig fieldConfig;
        QueryConfigHandler config;
        if (node instanceof FieldQueryNode && !(node instanceof ParametricQueryNode) && (config = this.getQueryConfigHandler()) != null && (fieldConfig = config.getFieldConfig((fieldNode = (FieldQueryNode)node).getFieldAsString())) != null && (numericConfig = fieldConfig.get(StandardQueryConfigHandler.ConfigurationKeys.NUMERIC_CONFIG)) != null) {
            Number number;
            NumberFormat numberFormat = numericConfig.getNumberFormat();
            try {
                number = numberFormat.parse(fieldNode.getTextAsString());
            }
            catch (ParseException e) {
                throw new QueryNodeParseException(new MessageImpl(QueryParserMessages.COULD_NOT_PARSE_NUMBER, fieldNode.getTextAsString(), numberFormat.getClass().getCanonicalName()), (Throwable)e);
            }
            switch (numericConfig.getType()) {
                case LONG: {
                    number = number.longValue();
                    break;
                }
                case INT: {
                    number = number.intValue();
                    break;
                }
                case DOUBLE: {
                    number = number.doubleValue();
                    break;
                }
                case FLOAT: {
                    number = Float.valueOf(number.floatValue());
                }
            }
            NumericQueryNode lowerNode = new NumericQueryNode(fieldNode.getField(), number, numberFormat);
            NumericQueryNode upperNode = new NumericQueryNode(fieldNode.getField(), number, numberFormat);
            return new NumericRangeQueryNode(lowerNode, upperNode, true, true, numericConfig);
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

