/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import java.util.List;
import org.apache.lucene.queryParser.core.nodes.AndQueryNode;
import org.apache.lucene.queryParser.core.nodes.FieldQueryNode;
import org.apache.lucene.queryParser.core.nodes.FieldableNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyQueryNode
extends AndQueryNode {
    private static final long serialVersionUID = 1000791433562954187L;
    private CharSequence field = null;
    private int minimumMatchingmElements = 0;

    public AnyQueryNode(List<QueryNode> clauses, CharSequence field, int minimumMatchingElements) {
        super(clauses);
        this.field = field;
        this.minimumMatchingmElements = minimumMatchingElements;
        if (clauses != null) {
            for (QueryNode clause : clauses) {
                if (!(clause instanceof FieldQueryNode)) continue;
                if (clause instanceof QueryNodeImpl) {
                    ((QueryNodeImpl)clause).toQueryStringIgnoreFields = true;
                }
                if (!(clause instanceof FieldableNode)) continue;
                ((FieldableNode)clause).setField(field);
            }
        }
    }

    public int getMinimumMatchingElements() {
        return this.minimumMatchingmElements;
    }

    public CharSequence getField() {
        return this.field;
    }

    public String getFieldAsString() {
        if (this.field == null) {
            return null;
        }
        return ((Object)this.field).toString();
    }

    public void setField(CharSequence field) {
        this.field = field;
    }

    @Override
    public QueryNode cloneTree() throws CloneNotSupportedException {
        AnyQueryNode clone = (AnyQueryNode)super.cloneTree();
        clone.field = this.field;
        clone.minimumMatchingmElements = this.minimumMatchingmElements;
        return clone;
    }

    @Override
    public String toString() {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return "<any field='" + this.field + "'  matchelements=" + this.minimumMatchingmElements + "/>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<any field='" + this.field + "'  matchelements=" + this.minimumMatchingmElements + ">");
        for (QueryNode clause : this.getChildren()) {
            sb.append("\n");
            sb.append(((Object)clause).toString());
        }
        sb.append("\n</any>");
        return sb.toString();
    }

    @Override
    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        String anySTR = "ANY " + this.minimumMatchingmElements;
        StringBuilder sb = new StringBuilder();
        if (this.getChildren() != null && this.getChildren().size() != 0) {
            String filler = "";
            for (QueryNode clause : this.getChildren()) {
                sb.append(filler).append(clause.toQueryString(escapeSyntaxParser));
                filler = " ";
            }
        }
        if (this.isDefaultField(this.field)) {
            return "( " + sb.toString() + " ) " + anySTR;
        }
        return this.field + ":(( " + sb.toString() + " ) " + anySTR + ")";
    }
}

