/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextFieldInfosFormat
extends FieldInfosFormat {
    static final String FIELD_INFOS_EXTENSION = "inf";
    static final BytesRef NUMFIELDS = new BytesRef((CharSequence)"number of fields ");
    static final BytesRef NAME = new BytesRef((CharSequence)"  name ");
    static final BytesRef NUMBER = new BytesRef((CharSequence)"  number ");
    static final BytesRef STORETV = new BytesRef((CharSequence)"  term vectors ");
    static final BytesRef STORETVPOS = new BytesRef((CharSequence)"  term vector positions ");
    static final BytesRef STORETVOFF = new BytesRef((CharSequence)"  term vector offsets ");
    static final BytesRef PAYLOADS = new BytesRef((CharSequence)"  payloads ");
    static final BytesRef NORMS = new BytesRef((CharSequence)"  norms ");
    static final BytesRef DOCVALUES = new BytesRef((CharSequence)"  doc values ");
    static final BytesRef DOCVALUES_GEN = new BytesRef((CharSequence)"  doc values gen ");
    static final BytesRef INDEXOPTIONS = new BytesRef((CharSequence)"  index options ");
    static final BytesRef NUM_ATTS = new BytesRef((CharSequence)"  attributes ");
    static final BytesRef ATT_KEY = new BytesRef((CharSequence)"    key ");
    static final BytesRef ATT_VALUE = new BytesRef((CharSequence)"    value ");
    static final BytesRef DATA_DIM_COUNT = new BytesRef((CharSequence)"  data dimensional count ");
    static final BytesRef INDEX_DIM_COUNT = new BytesRef((CharSequence)"  index dimensional count ");
    static final BytesRef DIM_NUM_BYTES = new BytesRef((CharSequence)"  dimensional num bytes ");
    static final BytesRef VECTOR_NUM_DIMS = new BytesRef((CharSequence)"  vector number of dimensions ");
    static final BytesRef VECTOR_ENCODING = new BytesRef((CharSequence)"  vector encoding ");
    static final BytesRef VECTOR_SIMILARITY = new BytesRef((CharSequence)"  vector similarity ");
    static final BytesRef SOFT_DELETES = new BytesRef((CharSequence)"  soft-deletes ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos;
        block26: {
            ChecksumIndexInput input;
            block25: {
                String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)FIELD_INFOS_EXTENSION);
                input = directory.openChecksumInput(fileName, iocontext);
                BytesRefBuilder scratch = new BytesRefBuilder();
                boolean success = false;
                try {
                    SimpleTextUtil.readLine((DataInput)input, scratch);
                    assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)NUMFIELDS));
                    int size = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUMFIELDS.length, scratch));
                    FieldInfo[] infos = new FieldInfo[size];
                    for (int i = 0; i < size; ++i) {
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)NAME));
                        String name = this.readString(SimpleTextFieldInfosFormat.NAME.length, scratch);
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)NUMBER));
                        int fieldNumber = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUMBER.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)INDEXOPTIONS));
                        String s = this.readString(SimpleTextFieldInfosFormat.INDEXOPTIONS.length, scratch);
                        IndexOptions indexOptions = IndexOptions.valueOf((String)s);
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)STORETV));
                        boolean storeTermVector = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.STORETV.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)PAYLOADS));
                        boolean storePayloads = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.PAYLOADS.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)NORMS));
                        boolean omitNorms = !Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.NORMS.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)DOCVALUES));
                        String dvType = this.readString(SimpleTextFieldInfosFormat.DOCVALUES.length, scratch);
                        DocValuesType docValuesType = this.docValuesType(dvType);
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)DOCVALUES_GEN));
                        long dvGen = Long.parseLong(this.readString(SimpleTextFieldInfosFormat.DOCVALUES_GEN.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)NUM_ATTS));
                        int numAtts = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUM_ATTS.length, scratch));
                        HashMap<String, String> atts = new HashMap<String, String>();
                        for (int j = 0; j < numAtts; ++j) {
                            SimpleTextUtil.readLine((DataInput)input, scratch);
                            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)ATT_KEY));
                            String key = this.readString(SimpleTextFieldInfosFormat.ATT_KEY.length, scratch);
                            SimpleTextUtil.readLine((DataInput)input, scratch);
                            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)ATT_VALUE));
                            String value = this.readString(SimpleTextFieldInfosFormat.ATT_VALUE.length, scratch);
                            atts.put(key, value);
                        }
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)DATA_DIM_COUNT));
                        int dimensionalCount = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.DATA_DIM_COUNT.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)INDEX_DIM_COUNT));
                        int indexDimensionalCount = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.INDEX_DIM_COUNT.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)DIM_NUM_BYTES));
                        int dimensionalNumBytes = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.DIM_NUM_BYTES.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)VECTOR_NUM_DIMS));
                        int vectorNumDimensions = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.VECTOR_NUM_DIMS.length, scratch));
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)VECTOR_ENCODING));
                        String encoding = this.readString(SimpleTextFieldInfosFormat.VECTOR_ENCODING.length, scratch);
                        VectorEncoding vectorEncoding = this.vectorEncoding(encoding);
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)VECTOR_SIMILARITY));
                        String scoreFunction = this.readString(SimpleTextFieldInfosFormat.VECTOR_SIMILARITY.length, scratch);
                        VectorSimilarityFunction vectorDistFunc = this.distanceFunction(scoreFunction);
                        SimpleTextUtil.readLine((DataInput)input, scratch);
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SOFT_DELETES));
                        boolean isSoftDeletesField = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.SOFT_DELETES.length, scratch));
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, dvGen, Collections.unmodifiableMap(atts), dimensionalCount, indexDimensionalCount, dimensionalNumBytes, vectorNumDimensions, vectorEncoding, vectorDistFunc, isSoftDeletesField);
                    }
                    SimpleTextUtil.checkFooter(input);
                    FieldInfos fieldInfos2 = new FieldInfos(infos);
                    success = true;
                    fieldInfos = fieldInfos2;
                    if (!success) break block25;
                }
                catch (Throwable throwable) {
                    if (success) {
                        input.close();
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
                    }
                    throw throwable;
                }
                input.close();
                break block26;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
        }
        return fieldInfos;
    }

    public DocValuesType docValuesType(String dvType) {
        return DocValuesType.valueOf((String)dvType);
    }

    public VectorEncoding vectorEncoding(String vectorEncoding) {
        return VectorEncoding.valueOf((String)vectorEncoding);
    }

    public VectorSimilarityFunction distanceFunction(String scoreFunction) {
        return VectorSimilarityFunction.valueOf((String)scoreFunction);
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        block9: {
            IndexOutput out;
            block8: {
                String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)FIELD_INFOS_EXTENSION);
                out = directory.createOutput(fileName, context);
                BytesRefBuilder scratch = new BytesRefBuilder();
                boolean success = false;
                try {
                    SimpleTextUtil.write((DataOutput)out, NUMFIELDS);
                    SimpleTextUtil.write((DataOutput)out, Integer.toString(infos.size()), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)out);
                    for (FieldInfo fi : infos) {
                        SimpleTextUtil.write((DataOutput)out, NAME);
                        SimpleTextUtil.write((DataOutput)out, fi.name, scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, NUMBER);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(fi.number), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, INDEXOPTIONS);
                        IndexOptions indexOptions = fi.getIndexOptions();
                        assert (indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !fi.hasPayloads());
                        SimpleTextUtil.write((DataOutput)out, indexOptions.toString(), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, STORETV);
                        SimpleTextUtil.write((DataOutput)out, Boolean.toString(fi.hasVectors()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, PAYLOADS);
                        SimpleTextUtil.write((DataOutput)out, Boolean.toString(fi.hasPayloads()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, NORMS);
                        SimpleTextUtil.write((DataOutput)out, Boolean.toString(!fi.omitsNorms()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, DOCVALUES);
                        SimpleTextUtil.write((DataOutput)out, SimpleTextFieldInfosFormat.getDocValuesType(fi.getDocValuesType()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, DOCVALUES_GEN);
                        SimpleTextUtil.write((DataOutput)out, Long.toString(fi.getDocValuesGen()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        Map atts = fi.attributes();
                        int numAtts = atts == null ? 0 : atts.size();
                        SimpleTextUtil.write((DataOutput)out, NUM_ATTS);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(numAtts), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        if (numAtts > 0) {
                            for (Map.Entry entry : atts.entrySet()) {
                                SimpleTextUtil.write((DataOutput)out, ATT_KEY);
                                SimpleTextUtil.write((DataOutput)out, (String)entry.getKey(), scratch);
                                SimpleTextUtil.writeNewline((DataOutput)out);
                                SimpleTextUtil.write((DataOutput)out, ATT_VALUE);
                                SimpleTextUtil.write((DataOutput)out, (String)entry.getValue(), scratch);
                                SimpleTextUtil.writeNewline((DataOutput)out);
                            }
                        }
                        SimpleTextUtil.write((DataOutput)out, DATA_DIM_COUNT);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(fi.getPointDimensionCount()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, INDEX_DIM_COUNT);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(fi.getPointIndexDimensionCount()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, DIM_NUM_BYTES);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(fi.getPointNumBytes()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, VECTOR_NUM_DIMS);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(fi.getVectorDimension()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, VECTOR_ENCODING);
                        SimpleTextUtil.write((DataOutput)out, fi.getVectorEncoding().name(), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, VECTOR_SIMILARITY);
                        SimpleTextUtil.write((DataOutput)out, fi.getVectorSimilarityFunction().name(), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                        SimpleTextUtil.write((DataOutput)out, SOFT_DELETES);
                        SimpleTextUtil.write((DataOutput)out, Boolean.toString(fi.isSoftDeletesField()), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                    }
                    SimpleTextUtil.writeChecksum(out, scratch);
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        out.close();
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
                    }
                    throw throwable;
                }
                out.close();
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
        }
    }

    private static String getDocValuesType(DocValuesType type) {
        return type.toString();
    }
}

