/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.FSTStore;
import org.apache.lucene.util.fst.OffHeapFSTStore;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class FSTDictionary
implements IndexDictionary {
    protected final FST<Long> fst;

    protected FSTDictionary(FST<Long> fst) {
        this.fst = fst;
    }

    @Override
    public void write(DataOutput output, BlockEncoder blockEncoder) throws IOException {
        if (blockEncoder == null) {
            this.fst.save(output, output);
        } else {
            ByteBuffersDataOutput bytesDataOutput = ByteBuffersDataOutput.newResettableInstance();
            this.fst.save((DataOutput)bytesDataOutput, (DataOutput)bytesDataOutput);
            BlockEncoder.WritableBytes encodedBytes = blockEncoder.encode((DataInput)bytesDataOutput.toDataInput(), bytesDataOutput.size());
            output.writeVLong(encodedBytes.size());
            encodedBytes.writeTo(output);
        }
    }

    protected static FSTDictionary read(DataInput input, BlockDecoder blockDecoder, boolean isFSTOnHeap) throws IOException {
        DataInput fstDataInput;
        if (blockDecoder == null) {
            fstDataInput = input;
        } else {
            long numBytes = input.readVLong();
            BytesRef decodedBytes = blockDecoder.decode(input, numBytes);
            fstDataInput = new ByteArrayDataInput(decodedBytes.bytes, 0, decodedBytes.length);
            isFSTOnHeap = true;
        }
        PositiveIntOutputs fstOutputs = PositiveIntOutputs.getSingleton();
        FST fst = isFSTOnHeap ? new FST(fstDataInput, fstDataInput, (Outputs)fstOutputs) : new FST(fstDataInput, fstDataInput, (Outputs)fstOutputs, (FSTStore)new OffHeapFSTStore());
        return new FSTDictionary((FST<Long>)fst);
    }

    @Override
    public Browser browser() {
        return new Browser();
    }

    public static class Builder
    implements IndexDictionary.Builder {
        protected final FSTCompiler<Long> fstCompiler;
        protected final IntsRefBuilder scratchInts;

        public Builder() {
            PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
            this.fstCompiler = new FSTCompiler(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
            this.scratchInts = new IntsRefBuilder();
        }

        @Override
        public void add(BytesRef blockKey, long blockFilePointer) throws IOException {
            this.fstCompiler.add(Util.toIntsRef((BytesRef)blockKey, (IntsRefBuilder)this.scratchInts), (Object)blockFilePointer);
        }

        @Override
        public FSTDictionary build() throws IOException {
            return new FSTDictionary((FST<Long>)this.fstCompiler.compile());
        }
    }

    public static class BrowserSupplier
    implements IndexDictionary.BrowserSupplier {
        protected final IndexInput dictionaryInput;
        protected final BlockDecoder blockDecoder;
        protected final boolean isFSTOnHeap;
        protected IndexDictionary dictionary;

        public BrowserSupplier(IndexInput dictionaryInput, long dictionaryStartFP, BlockDecoder blockDecoder, boolean isFSTOnHeap) throws IOException {
            this.dictionaryInput = dictionaryInput.clone();
            this.dictionaryInput.seek(dictionaryStartFP);
            this.blockDecoder = blockDecoder;
            this.isFSTOnHeap = isFSTOnHeap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexDictionary.Browser get() throws IOException {
            if (this.dictionary == null) {
                BrowserSupplier browserSupplier = this;
                synchronized (browserSupplier) {
                    if (this.dictionary == null) {
                        this.dictionary = FSTDictionary.read((DataInput)this.dictionaryInput, this.blockDecoder, this.isFSTOnHeap);
                    }
                }
            }
            return this.dictionary.browser();
        }
    }

    protected class Browser
    implements IndexDictionary.Browser {
        protected final BytesRefFSTEnum<Long> fstEnum;

        protected Browser() {
            this.fstEnum = new BytesRefFSTEnum(FSTDictionary.this.fst);
        }

        @Override
        public long seekBlock(BytesRef term) throws IOException {
            BytesRefFSTEnum.InputOutput seekFloor = this.fstEnum.seekFloor(term);
            return seekFloor == null ? -1L : (Long)seekFloor.output;
        }
    }
}

