/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.codecs.simpletext.SimpleTextPointsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;

final class SimpleTextBKDReader
extends PointValues
implements Accountable {
    private final byte[] splitPackedValues;
    final long[] leafBlockFPs;
    private final int leafNodeOffset;
    final int numDims;
    final int numIndexDims;
    final int bytesPerDim;
    final int bytesPerIndexEntry;
    final IndexInput in;
    final int maxPointsInLeafNode;
    final byte[] minPackedValue;
    final byte[] maxPackedValue;
    final long pointCount;
    final int docCount;
    final int version;
    protected final int packedBytesLength;
    protected final int packedIndexBytesLength;

    public SimpleTextBKDReader(IndexInput in, int numDims, int numIndexDims, int maxPointsInLeafNode, int bytesPerDim, long[] leafBlockFPs, byte[] splitPackedValues, byte[] minPackedValue, byte[] maxPackedValue, long pointCount, int docCount) throws IOException {
        this.in = in;
        this.numDims = numDims;
        this.numIndexDims = numIndexDims;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.bytesPerDim = bytesPerDim;
        this.bytesPerIndexEntry = numIndexDims == 1 ? bytesPerDim : bytesPerDim + 1;
        this.packedBytesLength = numDims * bytesPerDim;
        this.packedIndexBytesLength = numIndexDims * bytesPerDim;
        this.leafNodeOffset = leafBlockFPs.length;
        this.leafBlockFPs = leafBlockFPs;
        this.splitPackedValues = splitPackedValues;
        this.minPackedValue = minPackedValue;
        this.maxPackedValue = maxPackedValue;
        this.pointCount = pointCount;
        this.docCount = docCount;
        this.version = 3;
        assert (minPackedValue.length == this.packedIndexBytesLength);
        assert (maxPackedValue.length == this.packedIndexBytesLength);
    }

    public void intersect(PointValues.IntersectVisitor visitor) throws IOException {
        this.intersect(this.getIntersectState(visitor), 1, this.minPackedValue, this.maxPackedValue);
    }

    private void addAll(IntersectState state, int nodeID) throws IOException {
        if (nodeID >= this.leafNodeOffset) {
            this.visitDocIDs(state.in, this.leafBlockFPs[nodeID - this.leafNodeOffset], state.visitor);
        } else {
            this.addAll(state, 2 * nodeID);
            this.addAll(state, 2 * nodeID + 1);
        }
    }

    public IntersectState getIntersectState(PointValues.IntersectVisitor visitor) {
        return new IntersectState(this.in.clone(), this.numDims, this.packedBytesLength, this.maxPointsInLeafNode, visitor);
    }

    public void visitLeafBlockValues(int nodeID, IntersectState state) throws IOException {
        int leafID = nodeID - this.leafNodeOffset;
        int count = this.readDocIDs(state.in, this.leafBlockFPs[leafID], state.scratchDocIDs);
        this.visitDocValues(state.commonPrefixLengths, state.scratchPackedValue, state.in, state.scratchDocIDs, count, state.visitor);
    }

    void visitDocIDs(IndexInput in, long blockFP, PointValues.IntersectVisitor visitor) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        in.seek(blockFP);
        this.readLine(in, scratch);
        int count = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_COUNT);
        visitor.grow(count);
        for (int i = 0; i < count; ++i) {
            this.readLine(in, scratch);
            visitor.visit(this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_DOC_ID));
        }
    }

    int readDocIDs(IndexInput in, long blockFP, int[] docIDs) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        in.seek(blockFP);
        this.readLine(in, scratch);
        int count = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_COUNT);
        for (int i = 0; i < count; ++i) {
            this.readLine(in, scratch);
            docIDs[i] = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_DOC_ID);
        }
        return count;
    }

    void visitDocValues(int[] commonPrefixLengths, byte[] scratchPackedValue, IndexInput in, int[] docIDs, int count, PointValues.IntersectVisitor visitor) throws IOException {
        visitor.grow(count);
        assert (scratchPackedValue.length == this.packedBytesLength);
        BytesRefBuilder scratch = new BytesRefBuilder();
        for (int i = 0; i < count; ++i) {
            this.readLine(in, scratch);
            assert (this.startsWith(scratch, SimpleTextPointsWriter.BLOCK_VALUE));
            BytesRef br = SimpleTextUtil.fromBytesRefString(this.stripPrefix(scratch, SimpleTextPointsWriter.BLOCK_VALUE));
            assert (br.length == this.packedBytesLength);
            System.arraycopy(br.bytes, br.offset, scratchPackedValue, 0, this.packedBytesLength);
            visitor.visit(docIDs[i], scratchPackedValue);
        }
    }

    private void intersect(IntersectState state, int nodeID, byte[] cellMinPacked, byte[] cellMaxPacked) throws IOException {
        PointValues.Relation r = state.visitor.compare(cellMinPacked, cellMaxPacked);
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return;
        }
        if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
            this.addAll(state, nodeID);
            return;
        }
        if (nodeID >= this.leafNodeOffset) {
            int leafID = nodeID - this.leafNodeOffset;
            if (leafID < this.leafBlockFPs.length) {
                int count = this.readDocIDs(state.in, this.leafBlockFPs[leafID], state.scratchDocIDs);
                this.visitDocValues(state.commonPrefixLengths, state.scratchPackedValue, state.in, state.scratchDocIDs, count, state.visitor);
            }
        } else {
            int address = nodeID * this.bytesPerIndexEntry;
            int splitDim = this.numIndexDims == 1 ? 0 : this.splitPackedValues[address++] & 0xFF;
            assert (splitDim < this.numIndexDims);
            byte[] splitPackedValue = new byte[this.packedIndexBytesLength];
            System.arraycopy(cellMaxPacked, 0, splitPackedValue, 0, this.packedIndexBytesLength);
            System.arraycopy(this.splitPackedValues, address, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
            this.intersect(state, 2 * nodeID, cellMinPacked, splitPackedValue);
            System.arraycopy(cellMinPacked, 0, splitPackedValue, 0, this.packedIndexBytesLength);
            System.arraycopy(this.splitPackedValues, address, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
            this.intersect(state, 2 * nodeID + 1, splitPackedValue, cellMaxPacked);
        }
    }

    public long estimatePointCount(PointValues.IntersectVisitor visitor) {
        return this.estimatePointCount(this.getIntersectState(visitor), 1, this.minPackedValue, this.maxPackedValue);
    }

    private long estimatePointCount(IntersectState state, int nodeID, byte[] cellMinPacked, byte[] cellMaxPacked) {
        PointValues.Relation r = state.visitor.compare(cellMinPacked, cellMaxPacked);
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return 0L;
        }
        if (nodeID >= this.leafNodeOffset) {
            return this.maxPointsInLeafNode;
        }
        int address = nodeID * this.bytesPerIndexEntry;
        int splitDim = this.numIndexDims == 1 ? 0 : this.splitPackedValues[address++] & 0xFF;
        assert (splitDim < this.numIndexDims);
        byte[] splitPackedValue = new byte[this.packedIndexBytesLength];
        System.arraycopy(cellMaxPacked, 0, splitPackedValue, 0, this.packedIndexBytesLength);
        System.arraycopy(this.splitPackedValues, address, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
        long leftCost = this.estimatePointCount(state, 2 * nodeID, cellMinPacked, splitPackedValue);
        System.arraycopy(cellMinPacked, 0, splitPackedValue, 0, this.packedIndexBytesLength);
        System.arraycopy(this.splitPackedValues, address, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
        long rightCost = this.estimatePointCount(state, 2 * nodeID + 1, splitPackedValue, cellMaxPacked);
        return leftCost + rightCost;
    }

    public void copySplitValue(int nodeID, byte[] splitPackedValue) {
        int address = nodeID * this.bytesPerIndexEntry;
        int splitDim = this.numIndexDims == 1 ? 0 : this.splitPackedValues[address++] & 0xFF;
        assert (splitDim < this.numIndexDims);
        System.arraycopy(this.splitPackedValues, address, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf((byte[])this.splitPackedValues) + RamUsageEstimator.sizeOf((long[])this.leafBlockFPs);
    }

    public byte[] getMinPackedValue() {
        return (byte[])this.minPackedValue.clone();
    }

    public byte[] getMaxPackedValue() {
        return (byte[])this.maxPackedValue.clone();
    }

    public int getNumDimensions() {
        return this.numDims;
    }

    public int getNumIndexDimensions() {
        return this.numIndexDims;
    }

    public int getBytesPerDimension() {
        return this.bytesPerDim;
    }

    public long size() {
        return this.pointCount;
    }

    public int getDocCount() {
        return this.docCount;
    }

    public boolean isLeafNode(int nodeID) {
        return nodeID >= this.leafNodeOffset;
    }

    private int parseInt(BytesRefBuilder scratch, BytesRef prefix) {
        assert (this.startsWith(scratch, prefix));
        return Integer.parseInt(this.stripPrefix(scratch, prefix));
    }

    private String stripPrefix(BytesRefBuilder scratch, BytesRef prefix) {
        return new String(scratch.bytes(), prefix.length, scratch.length() - prefix.length, StandardCharsets.UTF_8);
    }

    private boolean startsWith(BytesRefBuilder scratch, BytesRef prefix) {
        return StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)prefix);
    }

    private void readLine(IndexInput in, BytesRefBuilder scratch) throws IOException {
        SimpleTextUtil.readLine((DataInput)in, scratch);
    }

    public static final class IntersectState {
        final IndexInput in;
        final int[] scratchDocIDs;
        final byte[] scratchPackedValue;
        final int[] commonPrefixLengths;
        final PointValues.IntersectVisitor visitor;

        public IntersectState(IndexInput in, int numDims, int packedBytesLength, int maxPointsInLeafNode, PointValues.IntersectVisitor visitor) {
            this.in = in;
            this.visitor = visitor;
            this.commonPrefixLengths = new int[numDims];
            this.scratchDocIDs = new int[maxPointsInLeafNode];
            this.scratchPackedValue = new byte[packedBytesLength];
        }
    }
}

