/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.BlockHeader;
import org.apache.lucene.codecs.uniformsplit.BlockLine;
import org.apache.lucene.codecs.uniformsplit.DeltaBaseTermStateSerializer;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.TermBytes;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;

public class BlockWriter {
    protected final int targetNumBlockLines;
    protected final int deltaNumLines;
    protected final List<BlockLine> blockLines;
    protected final IndexOutput blockOutput;
    protected final ByteBuffersDataOutput blockLinesWriteBuffer;
    protected final ByteBuffersDataOutput termStatesWriteBuffer;
    protected final DeltaBaseTermStateSerializer termStateSerializer;
    protected final BlockEncoder blockEncoder;
    protected final ByteBuffersDataOutput blockWriteBuffer;
    protected FieldMetadata fieldMetadata;
    protected BytesRef lastTerm;
    protected final BlockHeader reusableBlockHeader;
    protected BytesRef scratchBytesRef;

    protected BlockWriter(IndexOutput blockOutput, int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder) {
        assert (blockOutput != null);
        assert (targetNumBlockLines > 0);
        assert (deltaNumLines > 0);
        assert (deltaNumLines < targetNumBlockLines);
        this.blockOutput = blockOutput;
        this.targetNumBlockLines = targetNumBlockLines;
        this.deltaNumLines = deltaNumLines;
        this.blockEncoder = blockEncoder;
        this.blockLines = new ArrayList<BlockLine>(targetNumBlockLines);
        this.termStateSerializer = new DeltaBaseTermStateSerializer();
        this.blockLinesWriteBuffer = ByteBuffersDataOutput.newResettableInstance();
        this.termStatesWriteBuffer = ByteBuffersDataOutput.newResettableInstance();
        this.blockWriteBuffer = ByteBuffersDataOutput.newResettableInstance();
        this.reusableBlockHeader = new BlockHeader();
        this.scratchBytesRef = new BytesRef();
    }

    protected void addLine(BytesRef term, BlockTermState blockTermState, IndexDictionary.Builder dictionaryBuilder) throws IOException {
        assert (term != null);
        assert (blockTermState != null);
        int mdpLength = TermBytes.computeMdpLength(this.lastTerm, term);
        this.blockLines.add(new BlockLine(new TermBytes(mdpLength, term), blockTermState));
        this.lastTerm = term;
        if (this.blockLines.size() >= this.targetNumBlockLines + this.deltaNumLines) {
            this.splitAndWriteBlock(dictionaryBuilder);
        }
    }

    protected void finishLastBlock(IndexDictionary.Builder dictionaryBuilder) throws IOException {
        while (!this.blockLines.isEmpty()) {
            this.splitAndWriteBlock(dictionaryBuilder);
        }
        this.fieldMetadata = null;
        this.lastTerm = null;
    }

    protected void splitAndWriteBlock(IndexDictionary.Builder dictionaryBuilder) throws IOException {
        assert (!this.blockLines.isEmpty());
        int numLines = this.blockLines.size();
        if (numLines <= this.targetNumBlockLines - this.deltaNumLines) {
            this.writeBlock(this.blockLines, dictionaryBuilder);
            this.blockLines.clear();
            return;
        }
        int deltaStart = numLines - this.deltaNumLines * 2;
        assert (deltaStart >= 1) : "blockLines size: " + numLines;
        int minMdpLength = Integer.MAX_VALUE;
        int minMdpEndIndex = 0;
        for (int i = deltaStart; i < numLines; ++i) {
            TermBytes term = this.blockLines.get(i).getTermBytes();
            int mdpLength = term.getMdpLength();
            if (mdpLength > minMdpLength) continue;
            minMdpLength = mdpLength;
            minMdpEndIndex = i;
        }
        List<BlockLine> subList = this.blockLines.subList(0, minMdpEndIndex);
        this.writeBlock(subList, dictionaryBuilder);
        subList.clear();
    }

    protected void writeBlock(List<BlockLine> blockLines, IndexDictionary.Builder dictionaryBuilder) throws IOException {
        long blockStartFP = this.blockOutput.getFilePointer();
        this.addBlockKey(blockLines, dictionaryBuilder);
        int middle = blockLines.size() >> 1;
        int middleOffset = -1;
        BlockLine previousLine = null;
        int size = blockLines.size();
        for (int i = 0; i < size; ++i) {
            boolean isIncrementalEncodingSeed;
            boolean bl = isIncrementalEncodingSeed = i == 0;
            if (i == middle) {
                middleOffset = Math.toIntExact(this.blockLinesWriteBuffer.size());
                isIncrementalEncodingSeed = true;
            }
            BlockLine line = blockLines.get(i);
            this.writeBlockLine(isIncrementalEncodingSeed, line, previousLine);
            previousLine = line;
        }
        this.reusableBlockHeader.reset(blockLines.size(), this.termStateSerializer.getBaseDocStartFP(), this.termStateSerializer.getBasePosStartFP(), this.termStateSerializer.getBasePayStartFP(), Math.toIntExact(this.blockLinesWriteBuffer.size()), middleOffset);
        this.reusableBlockHeader.write((DataOutput)this.blockWriteBuffer);
        this.blockLinesWriteBuffer.copyTo((DataOutput)this.blockWriteBuffer);
        this.termStatesWriteBuffer.copyTo((DataOutput)this.blockWriteBuffer);
        if (this.blockEncoder == null) {
            this.blockOutput.writeVInt(Math.toIntExact(this.blockWriteBuffer.size()));
            this.blockWriteBuffer.copyTo((DataOutput)this.blockOutput);
        } else {
            BlockEncoder.WritableBytes encodedBytes = this.blockEncoder.encode((DataInput)this.blockWriteBuffer.toDataInput(), this.blockWriteBuffer.size());
            this.blockOutput.writeVInt(Math.toIntExact(encodedBytes.size()));
            encodedBytes.writeTo((DataOutput)this.blockOutput);
        }
        this.blockLinesWriteBuffer.reset();
        this.termStatesWriteBuffer.reset();
        this.blockWriteBuffer.reset();
        this.termStateSerializer.resetBaseStartFP();
        this.updateFieldMetadata(blockStartFP);
    }

    protected void updateFieldMetadata(long blockStartFP) {
        assert (this.fieldMetadata != null);
        if (this.fieldMetadata.getFirstBlockStartFP() == -1L) {
            this.fieldMetadata.setFirstBlockStartFP(blockStartFP);
        }
        this.fieldMetadata.setLastBlockStartFP(blockStartFP);
    }

    void setField(FieldMetadata fieldMetadata) {
        this.fieldMetadata = fieldMetadata;
    }

    protected void writeBlockLine(boolean isIncrementalEncodingSeed, BlockLine line, BlockLine previousLine) throws IOException {
        assert (this.fieldMetadata != null);
        BlockLine.Serializer.writeLine((DataOutput)this.blockLinesWriteBuffer, line, previousLine, Math.toIntExact(this.termStatesWriteBuffer.size()), isIncrementalEncodingSeed);
        BlockLine.Serializer.writeLineTermState((DataOutput)this.termStatesWriteBuffer, line, this.fieldMetadata.getFieldInfo(), this.termStateSerializer);
    }

    protected void addBlockKey(List<BlockLine> blockLines, IndexDictionary.Builder dictionaryBuilder) {
        assert (!blockLines.isEmpty());
        assert (dictionaryBuilder != null);
        TermBytes firstTerm = blockLines.get(0).getTermBytes();
        assert (firstTerm.getTerm().offset == 0);
        assert (this.scratchBytesRef.offset == 0);
        this.scratchBytesRef.bytes = firstTerm.getTerm().bytes;
        this.scratchBytesRef.length = firstTerm.getMdpLength();
        dictionaryBuilder.add(this.scratchBytesRef, this.blockOutput.getFilePointer());
    }
}

