/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.BlockLine;
import org.apache.lucene.codecs.uniformsplit.BlockWriter;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.TermBytes;
import org.apache.lucene.codecs.uniformsplit.sharedterms.FieldMetadataTermState;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STBlockLine;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;

public class STBlockWriter
extends BlockWriter {
    protected final Set<FieldMetadata> fieldsInBlock = new HashSet<FieldMetadata>();

    public STBlockWriter(IndexOutput blockOutput, int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder) {
        super(blockOutput, targetNumBlockLines, deltaNumLines, blockEncoder);
    }

    public void addLine(BytesRef term, List<FieldMetadataTermState> termStates, IndexDictionary.Builder dictionaryBuilder) throws IOException {
        if (termStates.isEmpty()) {
            return;
        }
        int mdpLength = TermBytes.computeMdpLength(this.lastTerm, term);
        this.blockLines.add(new STBlockLine(new TermBytes(mdpLength, term), termStates));
        this.lastTerm = term;
        if (this.blockLines.size() >= this.targetNumBlockLines + this.deltaNumLines) {
            this.splitAndWriteBlock(dictionaryBuilder);
        }
    }

    @Override
    protected void finishLastBlock(IndexDictionary.Builder dictionaryBuilder) throws IOException {
        super.finishLastBlock(dictionaryBuilder);
    }

    @Override
    protected void writeBlockLine(boolean isIncrementalEncodingSeed, BlockLine line, BlockLine previousLine) throws IOException {
        STBlockLine.Serializer.writeLine((DataOutput)this.blockLinesWriteBuffer, line, previousLine, Math.toIntExact(this.termStatesWriteBuffer.size()), isIncrementalEncodingSeed);
        STBlockLine.Serializer.writeLineTermStates((DataOutput)this.termStatesWriteBuffer, (STBlockLine)line, this.termStateSerializer);
        ((STBlockLine)line).collectFields(this.fieldsInBlock);
    }

    @Override
    protected void updateFieldMetadata(long blockStartFP) {
        assert (!this.fieldsInBlock.isEmpty());
        for (FieldMetadata fieldMetadata : this.fieldsInBlock) {
            if (fieldMetadata.getFirstBlockStartFP() == -1L) {
                fieldMetadata.setFirstBlockStartFP(blockStartFP);
            }
            fieldMetadata.setLastBlockStartFP(blockStartFP);
        }
        this.fieldsInBlock.clear();
    }
}

