/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.util.BytesRef;

public class UnionFieldMetadataBuilder {
    private long minStartBlockFP;
    private long maxEndBlockFP;
    private BytesRef maxLastTerm;

    public UnionFieldMetadataBuilder() {
        this.reset();
    }

    public UnionFieldMetadataBuilder reset() {
        this.maxEndBlockFP = Long.MIN_VALUE;
        this.minStartBlockFP = Long.MAX_VALUE;
        this.maxLastTerm = null;
        return this;
    }

    public UnionFieldMetadataBuilder addFieldMetadata(FieldMetadata fieldMetadata) {
        this.minStartBlockFP = Math.min(this.minStartBlockFP, fieldMetadata.getFirstBlockStartFP());
        this.maxEndBlockFP = Math.max(this.maxEndBlockFP, fieldMetadata.getLastBlockStartFP());
        if (this.maxLastTerm == null || this.maxLastTerm.compareTo(fieldMetadata.getLastTerm()) < 0) {
            this.maxLastTerm = fieldMetadata.getLastTerm();
        }
        return this;
    }

    public FieldMetadata build() {
        if (this.maxLastTerm == null) {
            throw new IllegalStateException("no field metadata was provided");
        }
        return new FieldMetadata(null, 0, false, this.minStartBlockFP, this.maxEndBlockFP, this.maxLastTerm);
    }
}

