/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.FSTDictionary;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;

public class DictionaryBrowserSupplier
implements Supplier<IndexDictionary.Browser>,
Accountable {
    protected final IndexInput dictionaryInput;
    protected final BlockDecoder blockDecoder;
    protected IndexDictionary dictionary;

    public DictionaryBrowserSupplier(IndexInput dictionaryInput, long startFilePointer, BlockDecoder blockDecoder) throws IOException {
        this.dictionaryInput = dictionaryInput.clone();
        this.dictionaryInput.seek(startFilePointer);
        this.blockDecoder = blockDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDictionary.Browser get() {
        if (this.dictionary == null) {
            DictionaryBrowserSupplier dictionaryBrowserSupplier = this;
            synchronized (dictionaryBrowserSupplier) {
                try {
                    if (this.dictionary == null) {
                        this.dictionary = FSTDictionary.read((DataInput)this.dictionaryInput, this.blockDecoder);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return this.dictionary.browser();
    }

    public long ramBytesUsed() {
        return this.dictionary == null ? 0L : this.dictionary.ramBytesUsed();
    }
}

