/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

class DirectDocValuesProducer
extends DocValuesProducer {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedEntry> sorteds;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedNumericEntry> sortedNumerics;
    private final IndexInput data;
    private final Map<String, NumericRawValues> numericInstances;
    private final Map<String, BinaryRawValues> binaryInstances;
    private final Map<String, SortedRawValues> sortedInstances;
    private final Map<String, SortedSetRawValues> sortedSetInstances;
    private final Map<String, SortedNumericRawValues> sortedNumericInstances;
    private final Map<String, FixedBitSet> docsWithFieldInstances;
    private final int numEntries;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final int version;
    private final boolean merging;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final byte SORTED_SET_SINGLETON = 4;
    static final byte SORTED_NUMERIC = 5;
    static final byte SORTED_NUMERIC_SINGLETON = 6;
    static final int VERSION_START = 3;
    static final int VERSION_CURRENT = 3;

    DirectDocValuesProducer(DirectDocValuesProducer original) throws IOException {
        this.numerics = new HashMap<String, NumericEntry>();
        this.binaries = new HashMap<String, BinaryEntry>();
        this.sorteds = new HashMap<String, SortedEntry>();
        this.sortedSets = new HashMap<String, SortedSetEntry>();
        this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
        this.numericInstances = new HashMap<String, NumericRawValues>();
        this.binaryInstances = new HashMap<String, BinaryRawValues>();
        this.sortedInstances = new HashMap<String, SortedRawValues>();
        this.sortedSetInstances = new HashMap<String, SortedSetRawValues>();
        this.sortedNumericInstances = new HashMap<String, SortedNumericRawValues>();
        this.docsWithFieldInstances = new HashMap<String, FixedBitSet>();
        assert (Thread.holdsLock((Object)original));
        this.numerics.putAll(original.numerics);
        this.binaries.putAll(original.binaries);
        this.sorteds.putAll(original.sorteds);
        this.sortedSets.putAll(original.sortedSets);
        this.sortedNumerics.putAll(original.sortedNumerics);
        this.data = original.data.clone();
        this.numericInstances.putAll(original.numericInstances);
        this.binaryInstances.putAll(original.binaryInstances);
        this.sortedInstances.putAll(original.sortedInstances);
        this.sortedSetInstances.putAll(original.sortedSetInstances);
        this.sortedNumericInstances.putAll(original.sortedNumericInstances);
        this.docsWithFieldInstances.putAll(original.docsWithFieldInstances);
        this.numEntries = original.numEntries;
        this.maxDoc = original.maxDoc;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.version = original.version;
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block8: {
            ChecksumIndexInput in;
            block7: {
                this.numerics = new HashMap<String, NumericEntry>();
                this.binaries = new HashMap<String, BinaryEntry>();
                this.sorteds = new HashMap<String, SortedEntry>();
                this.sortedSets = new HashMap<String, SortedSetEntry>();
                this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
                this.numericInstances = new HashMap<String, NumericRawValues>();
                this.binaryInstances = new HashMap<String, BinaryRawValues>();
                this.sortedInstances = new HashMap<String, SortedRawValues>();
                this.sortedSetInstances = new HashMap<String, SortedSetRawValues>();
                this.sortedNumericInstances = new HashMap<String, SortedNumericRawValues>();
                this.docsWithFieldInstances = new HashMap<String, FixedBitSet>();
                this.maxDoc = state.segmentInfo.getDocCount();
                this.merging = false;
                String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
                in = state.directory.openChecksumInput(metaName, state.context);
                this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(((Object)((Object)this)).getClass()));
                success = false;
                try {
                    this.version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)3, (int)3, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.numEntries = this.readFields((IndexInput)in, state.fieldInfos);
                    CodecUtil.checkFooter((ChecksumIndexInput)in);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block8;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)3, (int)3, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + this.version + ", data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
    }

    private NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.offset = meta.readLong();
        entry.count = meta.readInt();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.byteWidth = meta.readByte();
        return entry;
    }

    private BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.offset = meta.readLong();
        entry.numBytes = meta.readInt();
        entry.count = meta.readInt();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        return entry;
    }

    private SortedEntry readSortedEntry(IndexInput meta) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.docToOrd = this.readNumericEntry(meta);
        entry.values = this.readBinaryEntry(meta);
        return entry;
    }

    private SortedSetEntry readSortedSetEntry(IndexInput meta, boolean singleton) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        if (!singleton) {
            entry.docToOrdAddress = this.readNumericEntry(meta);
        }
        entry.ords = this.readNumericEntry(meta);
        entry.values = this.readBinaryEntry(meta);
        return entry;
    }

    private SortedNumericEntry readSortedNumericEntry(IndexInput meta, boolean singleton) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        if (!singleton) {
            entry.docToAddress = this.readNumericEntry(meta);
        }
        entry.values = this.readNumericEntry(meta);
        return entry;
    }

    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numEntries = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            ++numEntries;
            FieldInfo info = infos.fieldInfo(fieldNumber);
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                this.numerics.put(info.name, this.readNumericEntry(meta));
            } else if (fieldType == 1) {
                this.binaries.put(info.name, this.readBinaryEntry(meta));
            } else if (fieldType == 2) {
                entry = this.readSortedEntry(meta);
                this.sorteds.put(info.name, (SortedEntry)entry);
                this.binaries.put(info.name, ((SortedEntry)entry).values);
            } else if (fieldType == 3) {
                entry = this.readSortedSetEntry(meta, false);
                this.sortedSets.put(info.name, (SortedSetEntry)entry);
                this.binaries.put(info.name, ((SortedSetEntry)entry).values);
            } else if (fieldType == 4) {
                entry = this.readSortedSetEntry(meta, true);
                this.sortedSets.put(info.name, (SortedSetEntry)entry);
                this.binaries.put(info.name, ((SortedSetEntry)entry).values);
            } else if (fieldType == 5) {
                entry = this.readSortedNumericEntry(meta, false);
                this.sortedNumerics.put(info.name, (SortedNumericEntry)entry);
            } else if (fieldType == 6) {
                entry = this.readSortedNumericEntry(meta, true);
                this.sortedNumerics.put(info.name, (SortedNumericEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", field= " + info.name, (DataInput)meta);
            }
            fieldNumber = meta.readVInt();
        }
        return numEntries;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    public synchronized Collection<Accountable> getChildResources() {
        ArrayList resources = new ArrayList();
        resources.addAll(Accountables.namedAccountables((String)"numeric field", this.numericInstances));
        resources.addAll(Accountables.namedAccountables((String)"binary field", this.binaryInstances));
        resources.addAll(Accountables.namedAccountables((String)"sorted field", this.sortedInstances));
        resources.addAll(Accountables.namedAccountables((String)"sorted set field", this.sortedSetInstances));
        resources.addAll(Accountables.namedAccountables((String)"sorted numeric field", this.sortedNumericInstances));
        resources.addAll(Accountables.namedAccountables((String)"missing bitset field", this.docsWithFieldInstances));
        return Collections.unmodifiableList(resources);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(entries=" + this.numEntries + ")";
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericRawValues instance = this.numericInstances.get(field.name);
        if (instance == null) {
            instance = this.loadNumeric(this.numerics.get(field.name));
            if (!this.merging) {
                this.numericInstances.put(field.name, instance);
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
            }
        }
        return instance.numerics;
    }

    private NumericRawValues loadNumeric(NumericEntry entry) throws IOException {
        NumericRawValues ret = new NumericRawValues();
        this.data.seek(entry.offset + entry.missingBytes);
        switch (entry.byteWidth) {
            case 1: {
                final byte[] values = new byte[entry.count];
                this.data.readBytes(values, 0, entry.count);
                ret.bytesUsed = RamUsageEstimator.sizeOf((byte[])values);
                ret.numerics = new NumericDocValues(){

                    public long get(int idx) {
                        return values[idx];
                    }
                };
                return ret;
            }
            case 2: {
                final short[] values = new short[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readShort();
                }
                ret.bytesUsed = RamUsageEstimator.sizeOf((short[])values);
                ret.numerics = new NumericDocValues(){

                    public long get(int idx) {
                        return values[idx];
                    }
                };
                return ret;
            }
            case 4: {
                final int[] values = new int[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readInt();
                }
                ret.bytesUsed = RamUsageEstimator.sizeOf((int[])values);
                ret.numerics = new NumericDocValues(){

                    public long get(int idx) {
                        return values[idx];
                    }
                };
                return ret;
            }
            case 8: {
                final long[] values = new long[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readLong();
                }
                ret.bytesUsed = RamUsageEstimator.sizeOf((long[])values);
                ret.numerics = new NumericDocValues(){

                    public long get(int idx) {
                        return values[idx];
                    }
                };
                return ret;
            }
        }
        throw new AssertionError();
    }

    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryRawValues instance = this.binaryInstances.get(field.name);
        if (instance == null) {
            instance = this.loadBinary(this.binaries.get(field.name));
            if (!this.merging) {
                this.binaryInstances.put(field.name, instance);
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
            }
        }
        final byte[] bytes = instance.bytes;
        final int[] address = instance.address;
        return new BinaryDocValues(){
            final BytesRef term = new BytesRef();

            public BytesRef get(int docID) {
                this.term.bytes = bytes;
                this.term.offset = address[docID];
                this.term.length = address[docID + 1] - this.term.offset;
                return this.term;
            }
        };
    }

    private BinaryRawValues loadBinary(BinaryEntry entry) throws IOException {
        this.data.seek(entry.offset);
        byte[] bytes = new byte[entry.numBytes];
        this.data.readBytes(bytes, 0, entry.numBytes);
        this.data.seek(entry.offset + (long)entry.numBytes + entry.missingBytes);
        int[] address = new int[entry.count + 1];
        for (int i = 0; i < entry.count; ++i) {
            address[i] = this.data.readInt();
        }
        address[entry.count] = this.data.readInt();
        BinaryRawValues values = new BinaryRawValues();
        values.bytes = bytes;
        values.address = address;
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedRawValues instance;
        SortedEntry entry = this.sorteds.get(field.name);
        DirectDocValuesProducer directDocValuesProducer = this;
        synchronized (directDocValuesProducer) {
            instance = this.sortedInstances.get(field.name);
            if (instance == null) {
                instance = this.loadSorted(field);
                if (!this.merging) {
                    this.sortedInstances.put(field.name, instance);
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                }
            }
        }
        return this.newSortedInstance(instance.docToOrd.numerics, this.getBinary(field), entry.values.count);
    }

    private SortedDocValues newSortedInstance(final NumericDocValues docToOrd, final BinaryDocValues values, final int count) {
        return new SortedDocValues(){

            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            public BytesRef lookupOrd(int ord) {
                return values.get(ord);
            }

            public int getValueCount() {
                return count;
            }
        };
    }

    private SortedRawValues loadSorted(FieldInfo field) throws IOException {
        SortedEntry entry = this.sorteds.get(field.name);
        NumericRawValues docToOrd = this.loadNumeric(entry.docToOrd);
        SortedRawValues values = new SortedRawValues();
        values.docToOrd = docToOrd;
        return values;
    }

    public synchronized SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedNumericRawValues instance = this.sortedNumericInstances.get(field.name);
        SortedNumericEntry entry = this.sortedNumerics.get(field.name);
        if (instance == null) {
            instance = this.loadSortedNumeric(entry);
            if (!this.merging) {
                this.sortedNumericInstances.put(field.name, instance);
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
            }
        }
        if (entry.docToAddress == null) {
            NumericDocValues single = instance.values.numerics;
            Bits docsWithField = this.getMissingBits(field, entry.values.missingOffset, entry.values.missingBytes);
            return DocValues.singleton((NumericDocValues)single, (Bits)docsWithField);
        }
        final NumericDocValues docToAddress = instance.docToAddress.numerics;
        final NumericDocValues values = instance.values.numerics;
        return new SortedNumericDocValues(){
            int valueStart;
            int valueLimit;

            public void setDocument(int doc) {
                this.valueStart = (int)docToAddress.get(doc);
                this.valueLimit = (int)docToAddress.get(doc + 1);
            }

            public long valueAt(int index) {
                return values.get(this.valueStart + index);
            }

            public int count() {
                return this.valueLimit - this.valueStart;
            }
        };
    }

    private SortedNumericRawValues loadSortedNumeric(SortedNumericEntry entry) throws IOException {
        SortedNumericRawValues instance = new SortedNumericRawValues();
        if (entry.docToAddress != null) {
            instance.docToAddress = this.loadNumeric(entry.docToAddress);
        }
        instance.values = this.loadNumeric(entry.values);
        return instance;
    }

    public synchronized SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetRawValues instance = this.sortedSetInstances.get(field.name);
        final SortedSetEntry entry = this.sortedSets.get(field.name);
        if (instance == null) {
            instance = this.loadSortedSet(entry);
            if (!this.merging) {
                this.sortedSetInstances.put(field.name, instance);
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
            }
        }
        if (instance.docToOrdAddress == null) {
            SortedDocValues sorted = this.newSortedInstance(instance.ords.numerics, this.getBinary(field), entry.values.count);
            return DocValues.singleton((SortedDocValues)sorted);
        }
        final NumericDocValues docToOrdAddress = instance.docToOrdAddress.numerics;
        final NumericDocValues ords = instance.ords.numerics;
        final BinaryDocValues values = this.getBinary(field);
        return new RandomAccessOrds(){
            int ordStart;
            int ordUpto;
            int ordLimit;

            public long nextOrd() {
                if (this.ordUpto == this.ordLimit) {
                    return -1L;
                }
                return ords.get(this.ordUpto++);
            }

            public void setDocument(int docID) {
                this.ordStart = this.ordUpto = (int)docToOrdAddress.get(docID);
                this.ordLimit = (int)docToOrdAddress.get(docID + 1);
            }

            public BytesRef lookupOrd(long ord) {
                return values.get((int)ord);
            }

            public long getValueCount() {
                return entry.values.count;
            }

            public long ordAt(int index) {
                return ords.get(this.ordStart + index);
            }

            public int cardinality() {
                return this.ordLimit - this.ordStart;
            }
        };
    }

    private SortedSetRawValues loadSortedSet(SortedSetEntry entry) throws IOException {
        SortedSetRawValues instance = new SortedSetRawValues();
        if (entry.docToOrdAddress != null) {
            instance.docToOrdAddress = this.loadNumeric(entry.docToOrdAddress);
        }
        instance.ords = this.loadNumeric(entry.ords);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(FieldInfo field, long offset, long length) throws IOException {
        FixedBitSet instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        DirectDocValuesProducer directDocValuesProducer = this;
        synchronized (directDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(field.name);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(offset);
                assert (length % 8L == 0L);
                long[] bits = new long[(int)length >> 3];
                for (int i = 0; i < bits.length; ++i) {
                    bits[i] = data.readLong();
                }
                instance = new FixedBitSet(bits, this.maxDoc);
                if (!this.merging) {
                    this.docsWithFieldInstances.put(field.name, instance);
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                }
            }
        }
        return instance;
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue((SortedSetDocValues)this.getSortedSet(field), (int)this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue((SortedNumericDocValues)this.getSortedNumeric(field), (int)this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue((SortedDocValues)this.getSorted(field), (int)this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.name);
                return this.getMissingBits(field, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.name);
                return this.getMissingBits(field, ne.missingOffset, ne.missingBytes);
            }
        }
        throw new AssertionError();
    }

    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new DirectDocValuesProducer(this);
    }

    public void close() throws IOException {
        this.data.close();
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class SortedNumericEntry {
        NumericEntry docToAddress;
        NumericEntry values;

        SortedNumericEntry() {
        }
    }

    static class SortedSetEntry {
        NumericEntry docToOrdAddress;
        NumericEntry ords;
        BinaryEntry values;

        SortedSetEntry() {
        }
    }

    static class SortedEntry {
        NumericEntry docToOrd;
        BinaryEntry values;

        SortedEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        int count;
        int numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        int count;
        long missingOffset;
        long missingBytes;
        byte byteWidth;
        int packedIntsVersion;

        NumericEntry() {
        }
    }

    static class SortedSetRawValues
    implements Accountable {
        NumericRawValues docToOrdAddress;
        NumericRawValues ords;

        SortedSetRawValues() {
        }

        public long ramBytesUsed() {
            long bytesUsed = this.ords.ramBytesUsed();
            if (this.docToOrdAddress != null) {
                bytesUsed += this.docToOrdAddress.ramBytesUsed();
            }
            return bytesUsed;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            if (this.docToOrdAddress != null) {
                resources.add(Accountables.namedAccountable((String)"addresses", (Accountable)this.docToOrdAddress));
            }
            resources.add(Accountables.namedAccountable((String)"ordinals", (Accountable)this.ords));
            return Collections.unmodifiableList(resources);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class SortedNumericRawValues
    implements Accountable {
        NumericRawValues docToAddress;
        NumericRawValues values;

        SortedNumericRawValues() {
        }

        public long ramBytesUsed() {
            long bytesUsed = this.values.ramBytesUsed();
            if (this.docToAddress != null) {
                bytesUsed += this.docToAddress.ramBytesUsed();
            }
            return bytesUsed;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            if (this.docToAddress != null) {
                resources.add(Accountables.namedAccountable((String)"addresses", (Accountable)this.docToAddress));
            }
            resources.add(Accountables.namedAccountable((String)"values", (Accountable)this.values));
            return Collections.unmodifiableList(resources);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class SortedRawValues
    implements Accountable {
        NumericRawValues docToOrd;

        SortedRawValues() {
        }

        public long ramBytesUsed() {
            return this.docToOrd.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            return this.docToOrd.getChildResources();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class NumericRawValues
    implements Accountable {
        NumericDocValues numerics;
        long bytesUsed;

        NumericRawValues() {
        }

        public long ramBytesUsed() {
            return this.bytesUsed;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class BinaryRawValues
    implements Accountable {
        byte[] bytes;
        int[] address;

        BinaryRawValues() {
        }

        public long ramBytesUsed() {
            long bytesUsed = RamUsageEstimator.sizeOf((byte[])this.bytes);
            if (this.address != null) {
                bytesUsed += RamUsageEstimator.sizeOf((int[])this.address);
            }
            return bytesUsed;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            if (this.address != null) {
                resources.add(Accountables.namedAccountable((String)"addresses", (long)RamUsageEstimator.sizeOf((int[])this.address)));
            }
            resources.add(Accountables.namedAccountable((String)"bytes", (long)RamUsageEstimator.sizeOf((byte[])this.bytes)));
            return Collections.unmodifiableList(resources);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

