/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class MemoryDocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, FSTEntry> fsts;
    private final IndexInput data;
    private final Map<Integer, NumericDocValues> numericInstances;
    private final Map<Integer, BinaryDocValues> binaryInstances;
    private final Map<Integer, FST<Long>> fstInstances;
    private final Map<Integer, Bits> docsWithFieldInstances;
    private final int maxDoc;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte FST = 2;
    static final int BLOCK_SIZE = 4096;
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte UNCOMPRESSED = 2;
    static final byte GCD_COMPRESSED = 3;
    static final int VERSION_START = 0;
    static final int VERSION_GCD_COMPRESSION = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MemoryDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        boolean success;
        block8: {
            IndexInput in;
            block7: {
                this.numericInstances = new HashMap<Integer, NumericDocValues>();
                this.binaryInstances = new HashMap<Integer, BinaryDocValues>();
                this.fstInstances = new HashMap<Integer, FST<Long>>();
                this.docsWithFieldInstances = new HashMap<Integer, Bits>();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
                in = state.directory.openInput(metaName, state.context);
                success = false;
                try {
                    version = CodecUtil.checkHeader((DataInput)in, (String)metaCodec, (int)0, (int)1);
                    this.numerics = new HashMap<Integer, NumericEntry>();
                    this.binaries = new HashMap<Integer, BinaryEntry>();
                    this.fsts = new HashMap<Integer, FSTEntry>();
                    this.readFields(in, state.fieldInfos);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block8;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        success = false;
        try {
            String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
            this.data = state.directory.openInput(dataName, state.context);
            int version2 = CodecUtil.checkHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)1);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                entry = new NumericEntry();
                ((NumericEntry)entry).offset = meta.readLong();
                ((NumericEntry)entry).missingOffset = meta.readLong();
                ((NumericEntry)entry).missingBytes = ((NumericEntry)entry).missingOffset != -1L ? meta.readLong() : 0L;
                ((NumericEntry)entry).format = meta.readByte();
                switch (((NumericEntry)entry).format) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("Unknown format: " + ((NumericEntry)entry).format + ", input=" + meta);
                    }
                }
                if (((NumericEntry)entry).format != 2) {
                    ((NumericEntry)entry).packedIntsVersion = meta.readVInt();
                }
                this.numerics.put(fieldNumber, (NumericEntry)entry);
            } else if (fieldType == 1) {
                entry = new BinaryEntry();
                ((BinaryEntry)entry).offset = meta.readLong();
                ((BinaryEntry)entry).numBytes = meta.readLong();
                ((BinaryEntry)entry).missingOffset = meta.readLong();
                ((BinaryEntry)entry).missingBytes = ((BinaryEntry)entry).missingOffset != -1L ? meta.readLong() : 0L;
                ((BinaryEntry)entry).minLength = meta.readVInt();
                ((BinaryEntry)entry).maxLength = meta.readVInt();
                if (((BinaryEntry)entry).minLength != ((BinaryEntry)entry).maxLength) {
                    ((BinaryEntry)entry).packedIntsVersion = meta.readVInt();
                    ((BinaryEntry)entry).blockSize = meta.readVInt();
                }
                this.binaries.put(fieldNumber, (BinaryEntry)entry);
            } else if (fieldType == 2) {
                entry = new FSTEntry();
                ((FSTEntry)entry).offset = meta.readLong();
                ((FSTEntry)entry).numOrds = meta.readVLong();
                this.fsts.put(fieldNumber, (FSTEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", input=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
    }

    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field.number);
        if (instance == null) {
            instance = this.loadNumeric(field);
            this.numericInstances.put(field.number, instance);
        }
        return instance;
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf((Object)((Object)this));
    }

    private NumericDocValues loadNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        this.data.seek(entry.offset + entry.missingBytes);
        switch (entry.format) {
            case 1: {
                int size = this.data.readVInt();
                if (size > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + this.data);
                }
                final long[] decode = new long[size];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader((DataInput)this.data, (PackedInts.Format)PackedInts.Format.byId((int)formatID), (int)entry.packedIntsVersion, (int)this.maxDoc, (int)bitsPerValue);
                return new NumericDocValues(){

                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
            case 0: {
                int blockSize = this.data.readVInt();
                final BlockPackedReader reader = new BlockPackedReader(this.data, entry.packedIntsVersion, blockSize, (long)this.maxDoc, false);
                return new NumericDocValues(){

                    public long get(int docID) {
                        return reader.get((long)docID);
                    }
                };
            }
            case 2: {
                final byte[] bytes = new byte[this.maxDoc];
                this.data.readBytes(bytes, 0, bytes.length);
                return new NumericDocValues(){

                    public long get(int docID) {
                        return bytes[docID];
                    }
                };
            }
            case 3: {
                final long min = this.data.readLong();
                final long mult = this.data.readLong();
                int quotientBlockSize = this.data.readVInt();
                final BlockPackedReader quotientReader = new BlockPackedReader(this.data, entry.packedIntsVersion, quotientBlockSize, (long)this.maxDoc, false);
                return new NumericDocValues(){

                    public long get(int docID) {
                        return min + mult * quotientReader.get((long)docID);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field.number);
        if (instance == null) {
            instance = this.loadBinary(field);
            this.binaryInstances.put(field.number, instance);
        }
        return instance;
    }

    private BinaryDocValues loadBinary(FieldInfo field) throws IOException {
        BinaryEntry entry = this.binaries.get(field.number);
        this.data.seek(entry.offset);
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(this.data, entry.numBytes);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        if (entry.minLength == entry.maxLength) {
            final int fixedLength = entry.minLength;
            return new BinaryDocValues(){

                public void get(int docID, BytesRef result) {
                    bytesReader.fillSlice(result, (long)fixedLength * (long)docID, fixedLength);
                }
            };
        }
        this.data.seek(this.data.getFilePointer() + entry.missingBytes);
        final MonotonicBlockPackedReader addresses = new MonotonicBlockPackedReader(this.data, entry.packedIntsVersion, entry.blockSize, (long)this.maxDoc, false);
        return new BinaryDocValues(){

            public void get(int docID, BytesRef result) {
                long startAddress = docID == 0 ? 0L : addresses.get((long)(docID - 1));
                long endAddress = addresses.get((long)docID);
                bytesReader.fillSlice(result, startAddress, (int)(endAddress - startAddress));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        FST instance;
        final FSTEntry entry = this.fsts.get(field.number);
        if (entry.numOrds == 0L) {
            return SortedDocValues.EMPTY;
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field.number);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST((DataInput)this.data, (Outputs)PositiveIntOutputs.getSingleton());
                this.fstInstances.put(field.number, (FST<Long>)instance);
            }
        }
        final NumericDocValues docToOrd = this.getNumeric(field);
        final FST fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(fst);
        return new SortedDocValues(){

            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            public void lookupOrd(int ord, BytesRef result) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput((FST)fst, (long)ord, (FST.BytesReader)in, (FST.Arc)firstArc, (FST.Arc)scratchArc, (IntsRef)scratchInts);
                    result.bytes = new byte[output.length];
                    result.offset = 0;
                    result.length = 0;
                    Util.toBytesRef((IntsRef)output, (BytesRef)result);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public int lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1;
                    }
                    if (o.input.equals((Object)key)) {
                        return ((Long)o.output).intValue();
                    }
                    return (int)(-((Long)o.output).longValue()) - 1;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public int getValueCount() {
                return (int)entry.numOrds;
            }

            public TermsEnum termsEnum() {
                return new FSTTermsEnum((FST<Long>)fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        FST instance;
        final FSTEntry entry = this.fsts.get(field.number);
        if (entry.numOrds == 0L) {
            return SortedSetDocValues.EMPTY;
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field.number);
            if (instance == null) {
                this.data.seek(entry.offset);
                instance = new FST((DataInput)this.data, (Outputs)PositiveIntOutputs.getSingleton());
                this.fstInstances.put(field.number, (FST<Long>)instance);
            }
        }
        final BinaryDocValues docToOrds = this.getBinary(field);
        final FST fst = instance;
        final FST.BytesReader in = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(fst);
        final BytesRef ref = new BytesRef();
        final ByteArrayDataInput input = new ByteArrayDataInput();
        return new SortedSetDocValues(){
            long currentOrd;

            public long nextOrd() {
                if (input.eof()) {
                    return -1L;
                }
                this.currentOrd += input.readVLong();
                return this.currentOrd;
            }

            public void setDocument(int docID) {
                docToOrds.get(docID, ref);
                input.reset(ref.bytes, ref.offset, ref.length);
                this.currentOrd = 0L;
            }

            public void lookupOrd(long ord, BytesRef result) {
                try {
                    in.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput((FST)fst, (long)ord, (FST.BytesReader)in, (FST.Arc)firstArc, (FST.Arc)scratchArc, (IntsRef)scratchInts);
                    result.bytes = new byte[output.length];
                    result.offset = 0;
                    result.length = 0;
                    Util.toBytesRef((IntsRef)output, (BytesRef)result);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public long lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1L;
                    }
                    if (o.input.equals((Object)key)) {
                        return ((Long)o.output).intValue();
                    }
                    return -((Long)o.output).longValue() - 1L;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            public long getValueCount() {
                return entry.numOrds;
            }

            public TermsEnum termsEnum() {
                return new FSTTermsEnum((FST<Long>)fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(int fieldNumber, long offset, long length) throws IOException {
        Bits instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(fieldNumber);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(offset);
                assert (length % 8L == 0L);
                long[] bits = new long[(int)length >> 3];
                for (int i = 0; i < bits.length; ++i) {
                    bits[i] = data.readLong();
                }
                instance = new FixedBitSet(bits, this.maxDoc);
                this.docsWithFieldInstances.put(fieldNumber, instance);
            }
        }
        return instance;
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return new DocValuesProducer.SortedSetDocsWithField(this.getSortedSet(field), this.maxDoc);
            }
            case SORTED: {
                return new DocValuesProducer.SortedDocsWithField(this.getSorted(field), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.number);
                return this.getMissingBits(field.number, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.number);
                return this.getMissingBits(field.number, ne.missingOffset, ne.missingBytes);
            }
        }
        throw new AssertionError();
    }

    public void close() throws IOException {
        this.data.close();
    }

    static class FSTTermsEnum
    extends TermsEnum {
        final BytesRefFSTEnum<Long> in;
        final FST<Long> fst;
        final FST.BytesReader bytesReader;
        final FST.Arc<Long> firstArc = new FST.Arc();
        final FST.Arc<Long> scratchArc = new FST.Arc();
        final IntsRef scratchInts = new IntsRef();
        final BytesRef scratchBytes = new BytesRef();

        FSTTermsEnum(FST<Long> fst) {
            this.fst = fst;
            this.in = new BytesRefFSTEnum(fst);
            this.bytesReader = fst.getBytesReader();
        }

        public BytesRef next() throws IOException {
            BytesRefFSTEnum.InputOutput io = this.in.next();
            if (io == null) {
                return null;
            }
            return io.input;
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            if (this.in.seekCeil(text) == null) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.term().equals((Object)text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public boolean seekExact(BytesRef text) throws IOException {
            return this.in.seekExact(text) != null;
        }

        public void seekExact(long ord) throws IOException {
            this.bytesReader.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            IntsRef output = Util.getByOutput(this.fst, (long)ord, (FST.BytesReader)this.bytesReader, this.firstArc, this.scratchArc, (IntsRef)this.scratchInts);
            this.scratchBytes.bytes = new byte[output.length];
            this.scratchBytes.offset = 0;
            this.scratchBytes.length = 0;
            Util.toBytesRef((IntsRef)output, (BytesRef)this.scratchBytes);
            this.in.seekExact(this.scratchBytes);
        }

        public BytesRef term() throws IOException {
            return this.in.current().input;
        }

        public long ord() throws IOException {
            return (Long)this.in.current().output;
        }

        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        long numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        byte format;
        int packedIntsVersion;

        NumericEntry() {
        }
    }
}

