/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public class VariableGapTermsIndexReader
extends TermsIndexReaderBase {
    private final PositiveIntOutputs fstOutputs;
    final HashMap<String, FST<Long>> fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableGapTermsIndexReader(SegmentReadState state) throws IOException {
        block20: {
            this.fstOutputs = PositiveIntOutputs.getSingleton();
            this.fields = new HashMap();
            String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"tmv");
            String indexFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"tiv");
            try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(metaFileName);
                 ChecksumIndexInput indexIn = state.directory.openChecksumInput(indexFileName);){
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader((DataInput)metaIn, (String)"VariableGapTermsMeta", (int)4, (int)4, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    CodecUtil.checkIndexHeader((DataInput)indexIn, (String)"VariableGapTermsIndex", (int)4, (int)4, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    int field = metaIn.readInt();
                    while (field != -1) {
                        long indexStart = metaIn.readVLong();
                        FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                        if (indexIn.getFilePointer() != indexStart) {
                            throw new CorruptIndexException("Gap in FST, expected position " + indexIn.getFilePointer() + ", got " + indexStart, (DataInput)metaIn);
                        }
                        FST fst = new FST(FST.readMetadata((DataInput)metaIn, (Outputs)this.fstOutputs), (DataInput)indexIn);
                        FST<Long> previous = this.fields.put(fieldInfo.name, (FST<Long>)fst);
                        if (previous != null) {
                            throw new CorruptIndexException("duplicate field: " + fieldInfo.name, (DataInput)metaIn);
                        }
                        field = metaIn.readInt();
                    }
                }
                catch (Throwable t) {
                    try {
                        priorE = t;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                        CodecUtil.checkFooter((ChecksumIndexInput)indexIn, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                CodecUtil.checkFooter((ChecksumIndexInput)indexIn, (Throwable)priorE);
            }
        }
    }

    @Override
    public boolean supportsOrd() {
        return false;
    }

    @Override
    public TermsIndexReaderBase.FieldIndexEnum getFieldEnum(FieldInfo fieldInfo) {
        FST<Long> fieldData = this.fields.get(fieldInfo.name);
        if (fieldData == null) {
            return null;
        }
        return new IndexEnum(fieldData);
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ")";
    }

    private static class IndexEnum
    extends TermsIndexReaderBase.FieldIndexEnum {
        private final BytesRefFSTEnum<Long> fstEnum;
        private BytesRefFSTEnum.InputOutput<Long> current;

        public IndexEnum(FST<Long> fst) {
            this.fstEnum = new BytesRefFSTEnum(fst);
        }

        @Override
        public BytesRef term() {
            if (this.current == null) {
                return null;
            }
            return this.current.input;
        }

        @Override
        public long seek(BytesRef target) throws IOException {
            this.current = this.fstEnum.seekFloor(target);
            return (Long)this.current.output;
        }

        @Override
        public long next() throws IOException {
            this.current = this.fstEnum.next();
            if (this.current == null) {
                return -1L;
            }
            return (Long)this.current.output;
        }

        @Override
        public long ord() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long seek(long ord) {
            throw new UnsupportedOperationException();
        }
    }
}

