/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.plugins.di.Binding;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.internal.util.HierarchicalMap;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.InternalApi;

@InternalApi
public class BindingMap {
    private final HierarchicalMap<Key<?>, Binding<?>> bindings;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    private BindingMap(HierarchicalMap<Key<?>, Binding<?>> bindings) {
        this.bindings = bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Binding<T> get(Key<T> key, Collection<String> aliases) {
        this.lock.readLock().lock();
        try {
            Binding<T> existing = this.get(key);
            if (existing != null) {
                Binding<T> binding = existing;
                return binding;
            }
            for (String alias : aliases) {
                Binding<T> existingAlias = this.get(key.withName(alias));
                if (existingAlias == null) continue;
                Binding<T> binding = existingAlias;
                return binding;
            }
            Iterator<String> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    <T> Binding<T> get(Key<T> key) {
        return (Binding)Cast.cast(this.bindings.get(key));
    }

    public void put(Binding<?> binding) {
        this.lock.writeLock().lock();
        try {
            this.bindings.put(binding.getKey(), binding);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding<?> putIfAbsent(Binding<?> binding) {
        this.lock.readLock().lock();
        try {
            Binding existing = (Binding)this.bindings.get(binding.getKey());
            if (existing != null) {
                Binding binding2 = existing;
                return binding2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            Binding<?> binding3 = this.bindings.putIfAbsent(binding.getKey(), binding);
            return binding3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Binding<T> merge(Binding<T> binding) {
        Key key = binding.getKey();
        this.lock.writeLock().lock();
        try {
            Binding merged = this.bindings.merge(key, binding, (existingBinding, ignored) -> {
                Binding existing = (Binding)Cast.cast((Object)existingBinding);
                Key existingKey = existing.getKey();
                int compared = existingKey.compareTo(key);
                return compared > 0 ? binding : existing;
            });
            Binding binding2 = (Binding)Cast.cast((Object)merged);
            return binding2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(Key<?> key) {
        this.lock.writeLock().lock();
        try {
            this.bindings.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean containsKey(Key<?> key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.bindings.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsLocalKey(Key<?> key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.bindings.containsLocalKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public BindingMap newChildMap() {
        return new BindingMap(this.bindings.newChildMap());
    }

    public static BindingMap newRootMap() {
        return new BindingMap(HierarchicalMap.newRootMap());
    }
}

