/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.condition;

import java.lang.reflect.AnnotatedElement;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.condition.Condition;
import org.apache.logging.log4j.plugins.condition.ConditionalOnProperty;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

@Singleton
public class OnPropertyCondition
implements Condition {
    private static final Logger LOGGER = StatusLogger.getLogger();

    @Override
    public boolean matches(Key<?> key, AnnotatedElement element) {
        ConditionalOnProperty annotation = AnnotationUtil.getLogicalAnnotation(element, ConditionalOnProperty.class);
        if (annotation == null) {
            return false;
        }
        String name = annotation.name();
        String value = annotation.value();
        String property = PropertiesUtil.getProperties().getStringProperty(name);
        boolean result = property != null && (value.isEmpty() || value.equalsIgnoreCase(property));
        LOGGER.debug("ConditionalOnProperty {} for name='{}', value='{}'; property='{}'", (Object)result, (Object)name, (Object)value, (Object)property);
        return result;
    }
}

