/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.util.Strings;

public final class PatternResolver
implements EventResolver {
    private final BiConsumer<StringBuilder, LogEvent> emitter;

    PatternResolver(EventResolverContext context, TemplateResolverConfig config) {
        String pattern = config.getString("pattern");
        if (Strings.isBlank((String)pattern)) {
            throw new IllegalArgumentException("blank pattern: " + config);
        }
        boolean stackTraceEnabled = Optional.ofNullable(config.getBoolean("stackTraceEnabled")).orElse(context.isStackTraceEnabled());
        PatternLayout patternLayout = PatternLayout.newBuilder().withConfiguration(context.getConfiguration()).withCharset(context.getCharset()).withPattern(pattern).withAlwaysWriteExceptions(stackTraceEnabled).build();
        this.emitter = (stringBuilder, logEvent) -> patternLayout.serialize(logEvent, stringBuilder);
    }

    static String getName() {
        return "pattern";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        jsonWriter.writeString(this.emitter, logEvent);
    }
}

